# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PackageImages(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, thumbnail_image=None, details_image=None, banner_image=None):
        """
        PackageImages - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'thumbnail_image': 'list[str]',
            'details_image': 'list[str]',
            'banner_image': 'list[str]'
        }

        self.attribute_map = {
            'thumbnail_image': 'thumbnail_image',
            'details_image': 'details_image',
            'banner_image': 'banner_image'
        }

        self._thumbnail_image = thumbnail_image
        self._details_image = details_image
        self._banner_image = banner_image

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this PackageImages.
        image name and hash.

        :return: The thumbnail_image of this PackageImages.
        :rtype: list[str]
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this PackageImages.
        image name and hash.

        :param thumbnail_image: The thumbnail_image of this PackageImages.
        :type: list[str]
        """

        self._thumbnail_image = thumbnail_image

    @property
    def details_image(self):
        """
        Gets the details_image of this PackageImages.
        image name and hash.

        :return: The details_image of this PackageImages.
        :rtype: list[str]
        """
        return self._details_image

    @details_image.setter
    def details_image(self, details_image):
        """
        Sets the details_image of this PackageImages.
        image name and hash.

        :param details_image: The details_image of this PackageImages.
        :type: list[str]
        """

        self._details_image = details_image

    @property
    def banner_image(self):
        """
        Gets the banner_image of this PackageImages.
        image name and hash.

        :return: The banner_image of this PackageImages.
        :rtype: list[str]
        """
        return self._banner_image

    @banner_image.setter
    def banner_image(self, banner_image):
        """
        Sets the banner_image of this PackageImages.
        image name and hash.

        :param banner_image: The banner_image of this PackageImages.
        :type: list[str]
        """

        self._banner_image = banner_image

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
