# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PackageDetailData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, slug=None, user=None, name=None, type=None):
        """
        PackageDetailData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'str',
            'slug': 'str',
            'user': 'str',
            'name': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'account': 'account',
            'slug': 'slug',
            'user': 'user',
            'name': 'name',
            'type': 'type'
        }

        self._account = account
        self._slug = slug
        self._user = user
        self._name = name
        self._type = type

    @property
    def account(self):
        """
        Gets the account of this PackageDetailData.
        account slug of package

        :return: The account of this PackageDetailData.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this PackageDetailData.
        account slug of package

        :param account: The account of this PackageDetailData.
        :type: str
        """

        self._account = account

    @property
    def slug(self):
        """
        Gets the slug of this PackageDetailData.
        slug of package

        :return: The slug of this PackageDetailData.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this PackageDetailData.
        slug of package

        :param slug: The slug of this PackageDetailData.
        :type: str
        """

        self._slug = slug

    @property
    def user(self):
        """
        Gets the user of this PackageDetailData.
        actual user of package

        :return: The user of this PackageDetailData.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this PackageDetailData.
        actual user of package

        :param user: The user of this PackageDetailData.
        :type: str
        """

        self._user = user

    @property
    def name(self):
        """
        Gets the name of this PackageDetailData.
        Fully qualified name, account_slug/slug of package

        :return: The name of this PackageDetailData.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PackageDetailData.
        Fully qualified name, account_slug/slug of package

        :param name: The name of this PackageDetailData.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this PackageDetailData.
        Either 'theme' or 'layout'

        :return: The type of this PackageDetailData.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PackageDetailData.
        Either 'theme' or 'layout'

        :param type: The type of this PackageDetailData.
        :type: str
        """

        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
