# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class NewDraft(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, draft=None, tokens=None, package_hash=None):
        """
        NewDraft - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'draft': 'HyperLinkDraft',
            'tokens': 'object',
            'package_hash': 'str'
        }

        self.attribute_map = {
            'draft': 'draft',
            'tokens': 'tokens',
            'package_hash': 'package_hash'
        }

        self._draft = draft
        self._tokens = tokens
        self._package_hash = package_hash

    @property
    def draft(self):
        """
        Gets the draft of this NewDraft.
        Draft object.

        :return: The draft of this NewDraft.
        :rtype: HyperLinkDraft
        """
        return self._draft

    @draft.setter
    def draft(self, draft):
        """
        Sets the draft of this NewDraft.
        Draft object.

        :param draft: The draft of this NewDraft.
        :type: HyperLinkDraft
        """

        self._draft = draft

    @property
    def tokens(self):
        """
        Gets the tokens of this NewDraft.
        tokens used to upload images.

        :return: The tokens of this NewDraft.
        :rtype: object
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """
        Sets the tokens of this NewDraft.
        tokens used to upload images.

        :param tokens: The tokens of this NewDraft.
        :type: object
        """

        self._tokens = tokens

    @property
    def package_hash(self):
        """
        Gets the package_hash of this NewDraft.
        package hash of the draft

        :return: The package_hash of this NewDraft.
        :rtype: str
        """
        return self._package_hash

    @package_hash.setter
    def package_hash(self, package_hash):
        """
        Sets the package_hash of this NewDraft.
        package hash of the draft

        :param package_hash: The package_hash of this NewDraft.
        :type: str
        """

        self._package_hash = package_hash

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
