# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Login(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, user_name=None, password=None, active_account=None):
        """
        Login - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_name': 'str',
            'password': 'str',
            'active_account': 'str'
        }

        self.attribute_map = {
            'user_name': 'user_name',
            'password': 'password',
            'active_account': 'active_account'
        }

        self._user_name = user_name
        self._password = password
        self._active_account = active_account

    @property
    def user_name(self):
        """
        Gets the user_name of this Login.
        unique name used for user account,used to login.

        :return: The user_name of this Login.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this Login.
        unique name used for user account,used to login.

        :param user_name: The user_name of this Login.
        :type: str
        """

        self._user_name = user_name

    @property
    def password(self):
        """
        Gets the password of this Login.
        user account password.

        :return: The password of this Login.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this Login.
        user account password.

        :param password: The password of this Login.
        :type: str
        """

        self._password = password

    @property
    def active_account(self):
        """
        Gets the active_account of this Login.
        slug if you want to activate any of your organizations.

        :return: The active_account of this Login.
        :rtype: str
        """
        return self._active_account

    @active_account.setter
    def active_account(self, active_account):
        """
        Sets the active_account of this Login.
        slug if you want to activate any of your organizations.

        :param active_account: The active_account of this Login.
        :type: str
        """

        self._active_account = active_account

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
