# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class InitialPackage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, name=None, account=None, slug=None, acquisition_type=None, is_published=None, canonical=None, is_active=None, version=None, title=None, user=None):
        """
        InitialPackage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'name': 'str',
            'account': 'str',
            'slug': 'str',
            'acquisition_type': 'str',
            'is_published': 'bool',
            'canonical': 'object',
            'is_active': 'bool',
            'version': 'str',
            'title': 'str',
            'user': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'name': 'name',
            'account': 'account',
            'slug': 'slug',
            'acquisition_type': 'acquisition_type',
            'is_published': 'is_published',
            'canonical': 'canonical',
            'is_active': 'is_active',
            'version': 'version',
            'title': 'title',
            'user': 'user'
        }

        self._href = href
        self._name = name
        self._account = account
        self._slug = slug
        self._acquisition_type = acquisition_type
        self._is_published = is_published
        self._canonical = canonical
        self._is_active = is_active
        self._version = version
        self._title = title
        self._user = user

    @property
    def href(self):
        """
        Gets the href of this InitialPackage.
        current object reference url

        :return: The href of this InitialPackage.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this InitialPackage.
        current object reference url

        :param href: The href of this InitialPackage.
        :type: str
        """

        self._href = href

    @property
    def name(self):
        """
        Gets the name of this InitialPackage.
        package name.

        :return: The name of this InitialPackage.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InitialPackage.
        package name.

        :param name: The name of this InitialPackage.
        :type: str
        """

        self._name = name

    @property
    def account(self):
        """
        Gets the account of this InitialPackage.
        package creator name.

        :return: The account of this InitialPackage.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this InitialPackage.
        package creator name.

        :param account: The account of this InitialPackage.
        :type: str
        """

        self._account = account

    @property
    def slug(self):
        """
        Gets the slug of this InitialPackage.
        value used to uniquely identify package.

        :return: The slug of this InitialPackage.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this InitialPackage.
        value used to uniquely identify package.

        :param slug: The slug of this InitialPackage.
        :type: str
        """

        self._slug = slug

    @property
    def acquisition_type(self):
        """
        Gets the acquisition_type of this InitialPackage.
        acquisition type

        :return: The acquisition_type of this InitialPackage.
        :rtype: str
        """
        return self._acquisition_type

    @acquisition_type.setter
    def acquisition_type(self, acquisition_type):
        """
        Sets the acquisition_type of this InitialPackage.
        acquisition type

        :param acquisition_type: The acquisition_type of this InitialPackage.
        :type: str
        """

        self._acquisition_type = acquisition_type

    @property
    def is_published(self):
        """
        Gets the is_published of this InitialPackage.
        package is published or not.

        :return: The is_published of this InitialPackage.
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """
        Sets the is_published of this InitialPackage.
        package is published or not.

        :param is_published: The is_published of this InitialPackage.
        :type: bool
        """

        self._is_published = is_published

    @property
    def canonical(self):
        """
        Gets the canonical of this InitialPackage.
        Canonical Package Details.

        :return: The canonical of this InitialPackage.
        :rtype: object
        """
        return self._canonical

    @canonical.setter
    def canonical(self, canonical):
        """
        Sets the canonical of this InitialPackage.
        Canonical Package Details.

        :param canonical: The canonical of this InitialPackage.
        :type: object
        """

        self._canonical = canonical

    @property
    def is_active(self):
        """
        Gets the is_active of this InitialPackage.
        Suggested the client of Active Theme.

        :return: The is_active of this InitialPackage.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """
        Sets the is_active of this InitialPackage.
        Suggested the client of Active Theme.

        :param is_active: The is_active of this InitialPackage.
        :type: bool
        """

        self._is_active = is_active

    @property
    def version(self):
        """
        Gets the version of this InitialPackage.
        label detail

        :return: The version of this InitialPackage.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this InitialPackage.
        label detail

        :param version: The version of this InitialPackage.
        :type: str
        """

        self._version = version

    @property
    def title(self):
        """
        Gets the title of this InitialPackage.
        package title

        :return: The title of this InitialPackage.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this InitialPackage.
        package title

        :param title: The title of this InitialPackage.
        :type: str
        """

        self._title = title

    @property
    def user(self):
        """
        Gets the user of this InitialPackage.
        package.user.user_name

        :return: The user of this InitialPackage.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this InitialPackage.
        package.user.user_name

        :param user: The user of this InitialPackage.
        :type: str
        """

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
