# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class HyperLinkDraft(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, package=None, draft_name=None, modified_date=None, created_date=None, package_hash=None, user=None, validatorplan=None, documents=None):
        """
        HyperLinkDraft - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'package': 'int',
            'draft_name': 'str',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'package_hash': 'str',
            'user': 'str',
            'validatorplan': 'object',
            'documents': 'object'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'package': 'package',
            'draft_name': 'draft_name',
            'modified_date': 'modified_date',
            'created_date': 'created_date',
            'package_hash': 'package_hash',
            'user': 'user',
            'validatorplan': 'validatorplan',
            'documents': 'documents'
        }

        self._href = href
        self._pk = pk
        self._package = package
        self._draft_name = draft_name
        self._modified_date = modified_date
        self._created_date = created_date
        self._package_hash = package_hash
        self._user = user
        self._validatorplan = validatorplan
        self._documents = documents

    @property
    def href(self):
        """
        Gets the href of this HyperLinkDraft.
        current object reference url

        :return: The href of this HyperLinkDraft.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this HyperLinkDraft.
        current object reference url

        :param href: The href of this HyperLinkDraft.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this HyperLinkDraft.
        unique identifier of draft.

        :return: The pk of this HyperLinkDraft.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this HyperLinkDraft.
        unique identifier of draft.

        :param pk: The pk of this HyperLinkDraft.
        :type: int
        """

        self._pk = pk

    @property
    def package(self):
        """
        Gets the package of this HyperLinkDraft.
        package pk.

        :return: The package of this HyperLinkDraft.
        :rtype: int
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this HyperLinkDraft.
        package pk.

        :param package: The package of this HyperLinkDraft.
        :type: int
        """

        self._package = package

    @property
    def draft_name(self):
        """
        Gets the draft_name of this HyperLinkDraft.
        draft name.

        :return: The draft_name of this HyperLinkDraft.
        :rtype: str
        """
        return self._draft_name

    @draft_name.setter
    def draft_name(self, draft_name):
        """
        Sets the draft_name of this HyperLinkDraft.
        draft name.

        :param draft_name: The draft_name of this HyperLinkDraft.
        :type: str
        """

        self._draft_name = draft_name

    @property
    def modified_date(self):
        """
        Gets the modified_date of this HyperLinkDraft.
        last modified date.

        :return: The modified_date of this HyperLinkDraft.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this HyperLinkDraft.
        last modified date.

        :param modified_date: The modified_date of this HyperLinkDraft.
        :type: datetime
        """

        self._modified_date = modified_date

    @property
    def created_date(self):
        """
        Gets the created_date of this HyperLinkDraft.
        package draft creation date.

        :return: The created_date of this HyperLinkDraft.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this HyperLinkDraft.
        package draft creation date.

        :param created_date: The created_date of this HyperLinkDraft.
        :type: datetime
        """

        self._created_date = created_date

    @property
    def package_hash(self):
        """
        Gets the package_hash of this HyperLinkDraft.
        package hash

        :return: The package_hash of this HyperLinkDraft.
        :rtype: str
        """
        return self._package_hash

    @package_hash.setter
    def package_hash(self, package_hash):
        """
        Sets the package_hash of this HyperLinkDraft.
        package hash

        :param package_hash: The package_hash of this HyperLinkDraft.
        :type: str
        """

        self._package_hash = package_hash

    @property
    def user(self):
        """
        Gets the user of this HyperLinkDraft.
        package draft creator name.

        :return: The user of this HyperLinkDraft.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this HyperLinkDraft.
        package draft creator name.

        :param user: The user of this HyperLinkDraft.
        :type: str
        """

        self._user = user

    @property
    def validatorplan(self):
        """
        Gets the validatorplan of this HyperLinkDraft.
        Detail view of rating.

        :return: The validatorplan of this HyperLinkDraft.
        :rtype: object
        """
        return self._validatorplan

    @validatorplan.setter
    def validatorplan(self, validatorplan):
        """
        Sets the validatorplan of this HyperLinkDraft.
        Detail view of rating.

        :param validatorplan: The validatorplan of this HyperLinkDraft.
        :type: object
        """

        self._validatorplan = validatorplan

    @property
    def documents(self):
        """
        Gets the documents of this HyperLinkDraft.
        Detail view of rating.

        :return: The documents of this HyperLinkDraft.
        :rtype: object
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this HyperLinkDraft.
        Detail view of rating.

        :param documents: The documents of this HyperLinkDraft.
        :type: object
        """

        self._documents = documents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
