# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class HyperLinkCurrentAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, slug=None, name=None, role=None, admins=None, users=None, pendings=None):
        """
        HyperLinkCurrentAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'slug': 'str',
            'name': 'str',
            'role': 'str',
            'admins': 'object',
            'users': 'object',
            'pendings': 'object'
        }

        self.attribute_map = {
            'href': 'href',
            'slug': 'slug',
            'name': 'name',
            'role': 'role',
            'admins': 'admins',
            'users': 'users',
            'pendings': 'pendings'
        }

        self._href = href
        self._slug = slug
        self._name = name
        self._role = role
        self._admins = admins
        self._users = users
        self._pendings = pendings

    @property
    def href(self):
        """
        Gets the href of this HyperLinkCurrentAccount.
        current object reference url

        :return: The href of this HyperLinkCurrentAccount.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this HyperLinkCurrentAccount.
        current object reference url

        :param href: The href of this HyperLinkCurrentAccount.
        :type: str
        """

        self._href = href

    @property
    def slug(self):
        """
        Gets the slug of this HyperLinkCurrentAccount.
        unique value used for account.

        :return: The slug of this HyperLinkCurrentAccount.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this HyperLinkCurrentAccount.
        unique value used for account.

        :param slug: The slug of this HyperLinkCurrentAccount.
        :type: str
        """

        self._slug = slug

    @property
    def name(self):
        """
        Gets the name of this HyperLinkCurrentAccount.
        name of the account.

        :return: The name of this HyperLinkCurrentAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this HyperLinkCurrentAccount.
        name of the account.

        :param name: The name of this HyperLinkCurrentAccount.
        :type: str
        """

        self._name = name

    @property
    def role(self):
        """
        Gets the role of this HyperLinkCurrentAccount.
        user's role in this account.

        :return: The role of this HyperLinkCurrentAccount.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this HyperLinkCurrentAccount.
        user's role in this account.

        :param role: The role of this HyperLinkCurrentAccount.
        :type: str
        """

        self._role = role

    @property
    def admins(self):
        """
        Gets the admins of this HyperLinkCurrentAccount.
        account admin users details.

        :return: The admins of this HyperLinkCurrentAccount.
        :rtype: object
        """
        return self._admins

    @admins.setter
    def admins(self, admins):
        """
        Sets the admins of this HyperLinkCurrentAccount.
        account admin users details.

        :param admins: The admins of this HyperLinkCurrentAccount.
        :type: object
        """

        self._admins = admins

    @property
    def users(self):
        """
        Gets the users of this HyperLinkCurrentAccount.
        account regular users details.

        :return: The users of this HyperLinkCurrentAccount.
        :rtype: object
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this HyperLinkCurrentAccount.
        account regular users details.

        :param users: The users of this HyperLinkCurrentAccount.
        :type: object
        """

        self._users = users

    @property
    def pendings(self):
        """
        Gets the pendings of this HyperLinkCurrentAccount.
        account pendings users details

        :return: The pendings of this HyperLinkCurrentAccount.
        :rtype: object
        """
        return self._pendings

    @pendings.setter
    def pendings(self, pendings):
        """
        Sets the pendings of this HyperLinkCurrentAccount.
        account pendings users details

        :param pendings: The pendings of this HyperLinkCurrentAccount.
        :type: object
        """

        self._pendings = pendings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
