# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class FailedDependencyError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, package=None, third_party=None, get_or_purchased=None, to_do=None, to_account=None, dependency_of_package=None, dependency_package_details=None):
        """
        FailedDependencyError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'package': 'str',
            'third_party': 'bool',
            'get_or_purchased': 'bool',
            'to_do': 'str',
            'to_account': 'str',
            'dependency_of_package': 'str',
            'dependency_package_details': 'object'
        }

        self.attribute_map = {
            'package': 'package',
            'third_party': 'third_party',
            'get_or_purchased': 'get_or_purchased',
            'to_do': 'to_do',
            'to_account': 'to_account',
            'dependency_of_package': 'dependency_of_package',
            'dependency_package_details': 'dependency_package_details'
        }

        self._package = package
        self._third_party = third_party
        self._get_or_purchased = get_or_purchased
        self._to_do = to_do
        self._to_account = to_account
        self._dependency_of_package = dependency_of_package
        self._dependency_package_details = dependency_package_details

    @property
    def package(self):
        """
        Gets the package of this FailedDependencyError.
        fully qualified package name

        :return: The package of this FailedDependencyError.
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this FailedDependencyError.
        fully qualified package name

        :param package: The package of this FailedDependencyError.
        :type: str
        """

        self._package = package

    @property
    def third_party(self):
        """
        Gets the third_party of this FailedDependencyError.
        boolean field to identify third party package.

        :return: The third_party of this FailedDependencyError.
        :rtype: bool
        """
        return self._third_party

    @third_party.setter
    def third_party(self, third_party):
        """
        Sets the third_party of this FailedDependencyError.
        boolean field to identify third party package.

        :param third_party: The third_party of this FailedDependencyError.
        :type: bool
        """

        self._third_party = third_party

    @property
    def get_or_purchased(self):
        """
        Gets the get_or_purchased of this FailedDependencyError.
        boolean field to identify purchased packages.

        :return: The get_or_purchased of this FailedDependencyError.
        :rtype: bool
        """
        return self._get_or_purchased

    @get_or_purchased.setter
    def get_or_purchased(self, get_or_purchased):
        """
        Sets the get_or_purchased of this FailedDependencyError.
        boolean field to identify purchased packages.

        :param get_or_purchased: The get_or_purchased of this FailedDependencyError.
        :type: bool
        """

        self._get_or_purchased = get_or_purchased

    @property
    def to_do(self):
        """
        Gets the to_do of this FailedDependencyError.
        message for end user.

        :return: The to_do of this FailedDependencyError.
        :rtype: str
        """
        return self._to_do

    @to_do.setter
    def to_do(self, to_do):
        """
        Sets the to_do of this FailedDependencyError.
        message for end user.

        :param to_do: The to_do of this FailedDependencyError.
        :type: str
        """

        self._to_do = to_do

    @property
    def to_account(self):
        """
        Gets the to_account of this FailedDependencyError.
        intended recipient during initiated operation.

        :return: The to_account of this FailedDependencyError.
        :rtype: str
        """
        return self._to_account

    @to_account.setter
    def to_account(self, to_account):
        """
        Sets the to_account of this FailedDependencyError.
        intended recipient during initiated operation.

        :param to_account: The to_account of this FailedDependencyError.
        :type: str
        """

        self._to_account = to_account

    @property
    def dependency_of_package(self):
        """
        Gets the dependency_of_package of this FailedDependencyError.
        package for which the package is dependency of.

        :return: The dependency_of_package of this FailedDependencyError.
        :rtype: str
        """
        return self._dependency_of_package

    @dependency_of_package.setter
    def dependency_of_package(self, dependency_of_package):
        """
        Sets the dependency_of_package of this FailedDependencyError.
        package for which the package is dependency of.

        :param dependency_of_package: The dependency_of_package of this FailedDependencyError.
        :type: str
        """

        self._dependency_of_package = dependency_of_package

    @property
    def dependency_package_details(self):
        """
        Gets the dependency_package_details of this FailedDependencyError.
        details of the dependency package.

        :return: The dependency_package_details of this FailedDependencyError.
        :rtype: object
        """
        return self._dependency_package_details

    @dependency_package_details.setter
    def dependency_package_details(self, dependency_package_details):
        """
        Sets the dependency_package_details of this FailedDependencyError.
        details of the dependency package.

        :param dependency_package_details: The dependency_package_details of this FailedDependencyError.
        :type: object
        """

        self._dependency_package_details = dependency_package_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
