# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ErrorResponse412(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, status_code=None, error=None, message=None, items=None, data=None, thumbnail_image_data=None, redirect_url=None, validator_sets_to_pass=None):
        """
        ErrorResponse412 - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status_code': 'int',
            'error': 'list[FailedDependencyError]',
            'message': 'str',
            'items': 'str',
            'data': 'list[DependencyPackageDetail]',
            'thumbnail_image_data': 'list[object]',
            'redirect_url': 'str',
            'validator_sets_to_pass': 'list[ValidatorSetsInBadge]'
        }

        self.attribute_map = {
            'status_code': 'status_code',
            'error': 'error',
            'message': 'message',
            'items': 'items',
            'data': 'data',
            'thumbnail_image_data': 'thumbnail_image_data',
            'redirect_url': 'redirect_url',
            'validator_sets_to_pass': 'validator_sets_to_pass'
        }

        self._status_code = status_code
        self._error = error
        self._message = message
        self._items = items
        self._data = data
        self._thumbnail_image_data = thumbnail_image_data
        self._redirect_url = redirect_url
        self._validator_sets_to_pass = validator_sets_to_pass

    @property
    def status_code(self):
        """
        Gets the status_code of this ErrorResponse412.
        Error custom status code.

        :return: The status_code of this ErrorResponse412.
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """
        Sets the status_code of this ErrorResponse412.
        Error custom status code.

        :param status_code: The status_code of this ErrorResponse412.
        :type: int
        """

        self._status_code = status_code

    @property
    def error(self):
        """
        Gets the error of this ErrorResponse412.
        Validation error.

        :return: The error of this ErrorResponse412.
        :rtype: list[FailedDependencyError]
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this ErrorResponse412.
        Validation error.

        :param error: The error of this ErrorResponse412.
        :type: list[FailedDependencyError]
        """

        self._error = error

    @property
    def message(self):
        """
        Gets the message of this ErrorResponse412.
        error message.

        :return: The message of this ErrorResponse412.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ErrorResponse412.
        error message.

        :param message: The message of this ErrorResponse412.
        :type: str
        """

        self._message = message

    @property
    def items(self):
        """
        Gets the items of this ErrorResponse412.
        Validation error. List of private dependencies

        :return: The items of this ErrorResponse412.
        :rtype: str
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ErrorResponse412.
        Validation error. List of private dependencies

        :param items: The items of this ErrorResponse412.
        :type: str
        """

        self._items = items

    @property
    def data(self):
        """
        Gets the data of this ErrorResponse412.
        Validation error. List of paid dependencies

        :return: The data of this ErrorResponse412.
        :rtype: list[DependencyPackageDetail]
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this ErrorResponse412.
        Validation error. List of paid dependencies

        :param data: The data of this ErrorResponse412.
        :type: list[DependencyPackageDetail]
        """

        self._data = data

    @property
    def thumbnail_image_data(self):
        """
        Gets the thumbnail_image_data of this ErrorResponse412.


        :return: The thumbnail_image_data of this ErrorResponse412.
        :rtype: list[object]
        """
        return self._thumbnail_image_data

    @thumbnail_image_data.setter
    def thumbnail_image_data(self, thumbnail_image_data):
        """
        Sets the thumbnail_image_data of this ErrorResponse412.


        :param thumbnail_image_data: The thumbnail_image_data of this ErrorResponse412.
        :type: list[object]
        """

        self._thumbnail_image_data = thumbnail_image_data

    @property
    def redirect_url(self):
        """
        Gets the redirect_url of this ErrorResponse412.
        url if redirection to website is needed at all.

        :return: The redirect_url of this ErrorResponse412.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this ErrorResponse412.
        url if redirection to website is needed at all.

        :param redirect_url: The redirect_url of this ErrorResponse412.
        :type: str
        """

        self._redirect_url = redirect_url

    @property
    def validator_sets_to_pass(self):
        """
        Gets the validator_sets_to_pass of this ErrorResponse412.
        Need to pass at least one complete set of validators

        :return: The validator_sets_to_pass of this ErrorResponse412.
        :rtype: list[ValidatorSetsInBadge]
        """
        return self._validator_sets_to_pass

    @validator_sets_to_pass.setter
    def validator_sets_to_pass(self, validator_sets_to_pass):
        """
        Sets the validator_sets_to_pass of this ErrorResponse412.
        Need to pass at least one complete set of validators

        :param validator_sets_to_pass: The validator_sets_to_pass of this ErrorResponse412.
        :type: list[ValidatorSetsInBadge]
        """

        self._validator_sets_to_pass = validator_sets_to_pass

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
