# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ErrorResponse409(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, status_code=None, errors=None, purchase_packages_required=None, purchase_packages_given=None, auto_share_packages_required=None, auto_share_packages_given=None, redirect_url=None):
        """
        ErrorResponse409 - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status_code': 'int',
            'errors': 'list[str]',
            'purchase_packages_required': 'list[str]',
            'purchase_packages_given': 'list[str]',
            'auto_share_packages_required': 'list[str]',
            'auto_share_packages_given': 'list[str]',
            'redirect_url': 'str'
        }

        self.attribute_map = {
            'status_code': 'status_code',
            'errors': 'errors',
            'purchase_packages_required': 'purchase_packages_required',
            'purchase_packages_given': 'purchase_packages_given',
            'auto_share_packages_required': 'auto_share_packages_required',
            'auto_share_packages_given': 'auto_share_packages_given',
            'redirect_url': 'redirect_url'
        }

        self._status_code = status_code
        self._errors = errors
        self._purchase_packages_required = purchase_packages_required
        self._purchase_packages_given = purchase_packages_given
        self._auto_share_packages_required = auto_share_packages_required
        self._auto_share_packages_given = auto_share_packages_given
        self._redirect_url = redirect_url

    @property
    def status_code(self):
        """
        Gets the status_code of this ErrorResponse409.
        Error custom status code.

        :return: The status_code of this ErrorResponse409.
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """
        Sets the status_code of this ErrorResponse409.
        Error custom status code.

        :param status_code: The status_code of this ErrorResponse409.
        :type: int
        """

        self._status_code = status_code

    @property
    def errors(self):
        """
        Gets the errors of this ErrorResponse409.
        Validation error.

        :return: The errors of this ErrorResponse409.
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this ErrorResponse409.
        Validation error.

        :param errors: The errors of this ErrorResponse409.
        :type: list[str]
        """

        self._errors = errors

    @property
    def purchase_packages_required(self):
        """
        Gets the purchase_packages_required of this ErrorResponse409.
        Validation error.

        :return: The purchase_packages_required of this ErrorResponse409.
        :rtype: list[str]
        """
        return self._purchase_packages_required

    @purchase_packages_required.setter
    def purchase_packages_required(self, purchase_packages_required):
        """
        Sets the purchase_packages_required of this ErrorResponse409.
        Validation error.

        :param purchase_packages_required: The purchase_packages_required of this ErrorResponse409.
        :type: list[str]
        """

        self._purchase_packages_required = purchase_packages_required

    @property
    def purchase_packages_given(self):
        """
        Gets the purchase_packages_given of this ErrorResponse409.
        Validation error.

        :return: The purchase_packages_given of this ErrorResponse409.
        :rtype: list[str]
        """
        return self._purchase_packages_given

    @purchase_packages_given.setter
    def purchase_packages_given(self, purchase_packages_given):
        """
        Sets the purchase_packages_given of this ErrorResponse409.
        Validation error.

        :param purchase_packages_given: The purchase_packages_given of this ErrorResponse409.
        :type: list[str]
        """

        self._purchase_packages_given = purchase_packages_given

    @property
    def auto_share_packages_required(self):
        """
        Gets the auto_share_packages_required of this ErrorResponse409.
        Validation error.

        :return: The auto_share_packages_required of this ErrorResponse409.
        :rtype: list[str]
        """
        return self._auto_share_packages_required

    @auto_share_packages_required.setter
    def auto_share_packages_required(self, auto_share_packages_required):
        """
        Sets the auto_share_packages_required of this ErrorResponse409.
        Validation error.

        :param auto_share_packages_required: The auto_share_packages_required of this ErrorResponse409.
        :type: list[str]
        """

        self._auto_share_packages_required = auto_share_packages_required

    @property
    def auto_share_packages_given(self):
        """
        Gets the auto_share_packages_given of this ErrorResponse409.
        Validation error.

        :return: The auto_share_packages_given of this ErrorResponse409.
        :rtype: list[str]
        """
        return self._auto_share_packages_given

    @auto_share_packages_given.setter
    def auto_share_packages_given(self, auto_share_packages_given):
        """
        Sets the auto_share_packages_given of this ErrorResponse409.
        Validation error.

        :param auto_share_packages_given: The auto_share_packages_given of this ErrorResponse409.
        :type: list[str]
        """

        self._auto_share_packages_given = auto_share_packages_given

    @property
    def redirect_url(self):
        """
        Gets the redirect_url of this ErrorResponse409.
        url if redirection to website is needed at all.

        :return: The redirect_url of this ErrorResponse409.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this ErrorResponse409.
        url if redirection to website is needed at all.

        :param redirect_url: The redirect_url of this ErrorResponse409.
        :type: str
        """

        self._redirect_url = redirect_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
