# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class DependencyPackageDetail(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, package=None, label=None, title=None, third_party=None, get_or_purchased=None, thumbnail_image=None, thumbnail_image_hash=None, license_price=None, type=None, dependency_of_package=None):
        """
        DependencyPackageDetail - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'package': 'str',
            'label': 'str',
            'title': 'str',
            'third_party': 'bool',
            'get_or_purchased': 'bool',
            'thumbnail_image': 'str',
            'thumbnail_image_hash': 'str',
            'license_price': 'int',
            'type': 'str',
            'dependency_of_package': 'DependencyPackageDetailDependencyOfPackage'
        }

        self.attribute_map = {
            'package': 'package',
            'label': 'label',
            'title': 'title',
            'third_party': 'third_party',
            'get_or_purchased': 'get_or_purchased',
            'thumbnail_image': 'thumbnail_image',
            'thumbnail_image_hash': 'thumbnail_image_hash',
            'license_price': 'license_price',
            'type': 'type',
            'dependency_of_package': 'dependency_of_package'
        }

        self._package = package
        self._label = label
        self._title = title
        self._third_party = third_party
        self._get_or_purchased = get_or_purchased
        self._thumbnail_image = thumbnail_image
        self._thumbnail_image_hash = thumbnail_image_hash
        self._license_price = license_price
        self._type = type
        self._dependency_of_package = dependency_of_package

    @property
    def package(self):
        """
        Gets the package of this DependencyPackageDetail.
        fully qualified package name

        :return: The package of this DependencyPackageDetail.
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this DependencyPackageDetail.
        fully qualified package name

        :param package: The package of this DependencyPackageDetail.
        :type: str
        """

        self._package = package

    @property
    def label(self):
        """
        Gets the label of this DependencyPackageDetail.
        version label of dependency package

        :return: The label of this DependencyPackageDetail.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this DependencyPackageDetail.
        version label of dependency package

        :param label: The label of this DependencyPackageDetail.
        :type: str
        """

        self._label = label

    @property
    def title(self):
        """
        Gets the title of this DependencyPackageDetail.
        title of the dependency package

        :return: The title of this DependencyPackageDetail.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this DependencyPackageDetail.
        title of the dependency package

        :param title: The title of this DependencyPackageDetail.
        :type: str
        """

        self._title = title

    @property
    def third_party(self):
        """
        Gets the third_party of this DependencyPackageDetail.
        boolean field to identify third party package.

        :return: The third_party of this DependencyPackageDetail.
        :rtype: bool
        """
        return self._third_party

    @third_party.setter
    def third_party(self, third_party):
        """
        Sets the third_party of this DependencyPackageDetail.
        boolean field to identify third party package.

        :param third_party: The third_party of this DependencyPackageDetail.
        :type: bool
        """

        self._third_party = third_party

    @property
    def get_or_purchased(self):
        """
        Gets the get_or_purchased of this DependencyPackageDetail.
        boolean field to identify purchased packages.

        :return: The get_or_purchased of this DependencyPackageDetail.
        :rtype: bool
        """
        return self._get_or_purchased

    @get_or_purchased.setter
    def get_or_purchased(self, get_or_purchased):
        """
        Sets the get_or_purchased of this DependencyPackageDetail.
        boolean field to identify purchased packages.

        :param get_or_purchased: The get_or_purchased of this DependencyPackageDetail.
        :type: bool
        """

        self._get_or_purchased = get_or_purchased

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this DependencyPackageDetail.
        thumbnail_image of the dependency package

        :return: The thumbnail_image of this DependencyPackageDetail.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this DependencyPackageDetail.
        thumbnail_image of the dependency package

        :param thumbnail_image: The thumbnail_image of this DependencyPackageDetail.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def thumbnail_image_hash(self):
        """
        Gets the thumbnail_image_hash of this DependencyPackageDetail.
        thumbnail_image_hash for base64 lookup in thumbnail_image_data

        :return: The thumbnail_image_hash of this DependencyPackageDetail.
        :rtype: str
        """
        return self._thumbnail_image_hash

    @thumbnail_image_hash.setter
    def thumbnail_image_hash(self, thumbnail_image_hash):
        """
        Sets the thumbnail_image_hash of this DependencyPackageDetail.
        thumbnail_image_hash for base64 lookup in thumbnail_image_data

        :param thumbnail_image_hash: The thumbnail_image_hash of this DependencyPackageDetail.
        :type: str
        """

        self._thumbnail_image_hash = thumbnail_image_hash

    @property
    def license_price(self):
        """
        Gets the license_price of this DependencyPackageDetail.
        price of the license which the dependency package is part of

        :return: The license_price of this DependencyPackageDetail.
        :rtype: int
        """
        return self._license_price

    @license_price.setter
    def license_price(self, license_price):
        """
        Sets the license_price of this DependencyPackageDetail.
        price of the license which the dependency package is part of

        :param license_price: The license_price of this DependencyPackageDetail.
        :type: int
        """

        self._license_price = license_price

    @property
    def type(self):
        """
        Gets the type of this DependencyPackageDetail.
        package type of dependency package

        :return: The type of this DependencyPackageDetail.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DependencyPackageDetail.
        package type of dependency package

        :param type: The type of this DependencyPackageDetail.
        :type: str
        """

        self._type = type

    @property
    def dependency_of_package(self):
        """
        Gets the dependency_of_package of this DependencyPackageDetail.


        :return: The dependency_of_package of this DependencyPackageDetail.
        :rtype: DependencyPackageDetailDependencyOfPackage
        """
        return self._dependency_of_package

    @dependency_of_package.setter
    def dependency_of_package(self, dependency_of_package):
        """
        Sets the dependency_of_package of this DependencyPackageDetail.


        :param dependency_of_package: The dependency_of_package of this DependencyPackageDetail.
        :type: DependencyPackageDetailDependencyOfPackage
        """

        self._dependency_of_package = dependency_of_package

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
