# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class CreateVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, hash_as_token=None, auto_share_packages=None, purchase_packages=None, skip_validation=None):
        """
        CreateVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'hash_as_token': 'str',
            'auto_share_packages': 'list[str]',
            'purchase_packages': 'list[str]',
            'skip_validation': 'bool'
        }

        self.attribute_map = {
            'label': 'label',
            'hash_as_token': 'hash_as_token',
            'auto_share_packages': 'auto_share_packages',
            'purchase_packages': 'purchase_packages',
            'skip_validation': 'skip_validation'
        }

        self._label = label
        self._hash_as_token = hash_as_token
        self._auto_share_packages = auto_share_packages
        self._purchase_packages = purchase_packages
        self._skip_validation = skip_validation

    @property
    def label(self):
        """
        Gets the label of this CreateVersion.
        version label.

        :return: The label of this CreateVersion.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this CreateVersion.
        version label.

        :param label: The label of this CreateVersion.
        :type: str
        """

        self._label = label

    @property
    def hash_as_token(self):
        """
        Gets the hash_as_token of this CreateVersion.
        use as token for push

        :return: The hash_as_token of this CreateVersion.
        :rtype: str
        """
        return self._hash_as_token

    @hash_as_token.setter
    def hash_as_token(self, hash_as_token):
        """
        Sets the hash_as_token of this CreateVersion.
        use as token for push

        :param hash_as_token: The hash_as_token of this CreateVersion.
        :type: str
        """

        self._hash_as_token = hash_as_token

    @property
    def auto_share_packages(self):
        """
        Gets the auto_share_packages of this CreateVersion.
        list of dependency packages which needs to shared.

        :return: The auto_share_packages of this CreateVersion.
        :rtype: list[str]
        """
        return self._auto_share_packages

    @auto_share_packages.setter
    def auto_share_packages(self, auto_share_packages):
        """
        Sets the auto_share_packages of this CreateVersion.
        list of dependency packages which needs to shared.

        :param auto_share_packages: The auto_share_packages of this CreateVersion.
        :type: list[str]
        """

        self._auto_share_packages = auto_share_packages

    @property
    def purchase_packages(self):
        """
        Gets the purchase_packages of this CreateVersion.
        list of dependency packages which needs to purchases.

        :return: The purchase_packages of this CreateVersion.
        :rtype: list[str]
        """
        return self._purchase_packages

    @purchase_packages.setter
    def purchase_packages(self, purchase_packages):
        """
        Sets the purchase_packages of this CreateVersion.
        list of dependency packages which needs to purchases.

        :param purchase_packages: The purchase_packages of this CreateVersion.
        :type: list[str]
        """

        self._purchase_packages = purchase_packages

    @property
    def skip_validation(self):
        """
        Gets the skip_validation of this CreateVersion.
        Flag to specify whether to run validators or skip

        :return: The skip_validation of this CreateVersion.
        :rtype: bool
        """
        return self._skip_validation

    @skip_validation.setter
    def skip_validation(self, skip_validation):
        """
        Sets the skip_validation of this CreateVersion.
        Flag to specify whether to run validators or skip

        :param skip_validation: The skip_validation of this CreateVersion.
        :type: bool
        """

        self._skip_validation = skip_validation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
