# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class CreatePackage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, slug=None, type=None, description=None):
        """
        CreatePackage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'slug': 'str',
            'type': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'slug': 'slug',
            'type': 'type',
            'description': 'description'
        }

        self._slug = slug
        self._type = type
        self._description = description

    @property
    def slug(self):
        """
        Gets the slug of this CreatePackage.
        name of the package.

        :return: The slug of this CreatePackage.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this CreatePackage.
        name of the package.

        :param slug: The slug of this CreatePackage.
        :type: str
        """

        self._slug = slug

    @property
    def type(self):
        """
        Gets the type of this CreatePackage.
        type of package.

        :return: The type of this CreatePackage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreatePackage.
        type of package.

        :param type: The type of this CreatePackage.
        :type: str
        """

        self._type = type

    @property
    def description(self):
        """
        Gets the description of this CreatePackage.
        Package description.

        :return: The description of this CreatePackage.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreatePackage.
        Package description.

        :param description: The description of this CreatePackage.
        :type: str
        """

        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
