# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class BundledPackagesError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, package=None, license_name=None, license_type=None, price=None, title=None, type=None, third_party=None, dependency_of_package=None, license_type_dependency_of_package=None, thumbnail_image=None, error=None):
        """
        BundledPackagesError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'package': 'str',
            'license_name': 'str',
            'license_type': 'str',
            'price': 'float',
            'title': 'str',
            'type': 'str',
            'third_party': 'str',
            'dependency_of_package': 'str',
            'license_type_dependency_of_package': 'str',
            'thumbnail_image': 'str',
            'error': 'list[PublicationValidationError]'
        }

        self.attribute_map = {
            'label': 'label',
            'package': 'package',
            'license_name': 'license_name',
            'license_type': 'license_type',
            'price': 'price',
            'title': 'title',
            'type': 'type',
            'third_party': 'third_party',
            'dependency_of_package': 'dependency_of_package',
            'license_type_dependency_of_package': 'license_type_dependency_of_package',
            'thumbnail_image': 'thumbnail_image',
            'error': 'ERROR'
        }

        self._label = label
        self._package = package
        self._license_name = license_name
        self._license_type = license_type
        self._price = price
        self._title = title
        self._type = type
        self._third_party = third_party
        self._dependency_of_package = dependency_of_package
        self._license_type_dependency_of_package = license_type_dependency_of_package
        self._thumbnail_image = thumbnail_image
        self._error = error

    @property
    def label(self):
        """
        Gets the label of this BundledPackagesError.
        label of package version

        :return: The label of this BundledPackagesError.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this BundledPackagesError.
        label of package version

        :param label: The label of this BundledPackagesError.
        :type: str
        """

        self._label = label

    @property
    def package(self):
        """
        Gets the package of this BundledPackagesError.
        fully qualified name of package

        :return: The package of this BundledPackagesError.
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this BundledPackagesError.
        fully qualified name of package

        :param package: The package of this BundledPackagesError.
        :type: str
        """

        self._package = package

    @property
    def license_name(self):
        """
        Gets the license_name of this BundledPackagesError.
        license name

        :return: The license_name of this BundledPackagesError.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this BundledPackagesError.
        license name

        :param license_name: The license_name of this BundledPackagesError.
        :type: str
        """

        self._license_name = license_name

    @property
    def license_type(self):
        """
        Gets the license_type of this BundledPackagesError.
        license type

        :return: The license_type of this BundledPackagesError.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this BundledPackagesError.
        license type

        :param license_type: The license_type of this BundledPackagesError.
        :type: str
        """

        self._license_type = license_type

    @property
    def price(self):
        """
        Gets the price of this BundledPackagesError.
        license type

        :return: The price of this BundledPackagesError.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this BundledPackagesError.
        license type

        :param price: The price of this BundledPackagesError.
        :type: float
        """

        self._price = price

    @property
    def title(self):
        """
        Gets the title of this BundledPackagesError.
        title of bundled package

        :return: The title of this BundledPackagesError.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this BundledPackagesError.
        title of bundled package

        :param title: The title of this BundledPackagesError.
        :type: str
        """

        self._title = title

    @property
    def type(self):
        """
        Gets the type of this BundledPackagesError.
        type of bundled package

        :return: The type of this BundledPackagesError.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BundledPackagesError.
        type of bundled package

        :param type: The type of this BundledPackagesError.
        :type: str
        """

        self._type = type

    @property
    def third_party(self):
        """
        Gets the third_party of this BundledPackagesError.
        is it a third_party package?

        :return: The third_party of this BundledPackagesError.
        :rtype: str
        """
        return self._third_party

    @third_party.setter
    def third_party(self, third_party):
        """
        Sets the third_party of this BundledPackagesError.
        is it a third_party package?

        :param third_party: The third_party of this BundledPackagesError.
        :type: str
        """

        self._third_party = third_party

    @property
    def dependency_of_package(self):
        """
        Gets the dependency_of_package of this BundledPackagesError.
        package name of upstream package

        :return: The dependency_of_package of this BundledPackagesError.
        :rtype: str
        """
        return self._dependency_of_package

    @dependency_of_package.setter
    def dependency_of_package(self, dependency_of_package):
        """
        Sets the dependency_of_package of this BundledPackagesError.
        package name of upstream package

        :param dependency_of_package: The dependency_of_package of this BundledPackagesError.
        :type: str
        """

        self._dependency_of_package = dependency_of_package

    @property
    def license_type_dependency_of_package(self):
        """
        Gets the license_type_dependency_of_package of this BundledPackagesError.
        license_type of upstream package

        :return: The license_type_dependency_of_package of this BundledPackagesError.
        :rtype: str
        """
        return self._license_type_dependency_of_package

    @license_type_dependency_of_package.setter
    def license_type_dependency_of_package(self, license_type_dependency_of_package):
        """
        Sets the license_type_dependency_of_package of this BundledPackagesError.
        license_type of upstream package

        :param license_type_dependency_of_package: The license_type_dependency_of_package of this BundledPackagesError.
        :type: str
        """

        self._license_type_dependency_of_package = license_type_dependency_of_package

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this BundledPackagesError.
        thumbnail_image of upstream package

        :return: The thumbnail_image of this BundledPackagesError.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this BundledPackagesError.
        thumbnail_image of upstream package

        :param thumbnail_image: The thumbnail_image of this BundledPackagesError.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def error(self):
        """
        Gets the error of this BundledPackagesError.
        list of errors will be displayed here.

        :return: The error of this BundledPackagesError.
        :rtype: list[PublicationValidationError]
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this BundledPackagesError.
        list of errors will be displayed here.

        :param error: The error of this BundledPackagesError.
        :type: list[PublicationValidationError]
        """

        self._error = error

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
