# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class BundledPackages(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, package=None, license_name=None, license_type=None, price=None, bundles_price=None):
        """
        BundledPackages - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'package': 'str',
            'license_name': 'str',
            'license_type': 'str',
            'price': 'float',
            'bundles_price': 'float'
        }

        self.attribute_map = {
            'label': 'label',
            'package': 'package',
            'license_name': 'license_name',
            'license_type': 'license_type',
            'price': 'price',
            'bundles_price': 'bundles_price'
        }

        self._label = label
        self._package = package
        self._license_name = license_name
        self._license_type = license_type
        self._price = price
        self._bundles_price = bundles_price

    @property
    def label(self):
        """
        Gets the label of this BundledPackages.
        label of package version

        :return: The label of this BundledPackages.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this BundledPackages.
        label of package version

        :param label: The label of this BundledPackages.
        :type: str
        """

        self._label = label

    @property
    def package(self):
        """
        Gets the package of this BundledPackages.
        fully qualified name of package

        :return: The package of this BundledPackages.
        :rtype: str
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this BundledPackages.
        fully qualified name of package

        :param package: The package of this BundledPackages.
        :type: str
        """

        self._package = package

    @property
    def license_name(self):
        """
        Gets the license_name of this BundledPackages.
        license name

        :return: The license_name of this BundledPackages.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this BundledPackages.
        license name

        :param license_name: The license_name of this BundledPackages.
        :type: str
        """

        self._license_name = license_name

    @property
    def license_type(self):
        """
        Gets the license_type of this BundledPackages.
        license type

        :return: The license_type of this BundledPackages.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this BundledPackages.
        license type

        :param license_type: The license_type of this BundledPackages.
        :type: str
        """

        self._license_type = license_type

    @property
    def price(self):
        """
        Gets the price of this BundledPackages.
        license type

        :return: The price of this BundledPackages.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this BundledPackages.
        license type

        :param price: The price of this BundledPackages.
        :type: float
        """

        self._price = price

    @property
    def bundles_price(self):
        """
        Gets the bundles_price of this BundledPackages.
        total price of bundled packages

        :return: The bundles_price of this BundledPackages.
        :rtype: float
        """
        return self._bundles_price

    @bundles_price.setter
    def bundles_price(self, bundles_price):
        """
        Sets the bundles_price of this BundledPackages.
        total price of bundled packages

        :param bundles_price: The bundles_price of this BundledPackages.
        :type: float
        """

        self._bundles_price = bundles_price

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
