# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class BlendedPackage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, slug=None, account=None, name=None, type=None, base_package=None, is_published=None, package_status=None, description=None, rating_avg=None, rating_count=None, modified_date=None, created_date=None, user=None, title=None, purchase_pending=None, recipient=None, thumbnail_image=None, details_image=None, banner_image=None, canonical_version=None, is_set_canonical=None, licenses=None, ratings=None, dependencies=None, canonical=None, draft=None):
        """
        BlendedPackage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'slug': 'str',
            'account': 'str',
            'name': 'str',
            'type': 'str',
            'base_package': 'int',
            'is_published': 'bool',
            'package_status': 'str',
            'description': 'str',
            'rating_avg': 'float',
            'rating_count': 'float',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'user': 'str',
            'title': 'str',
            'purchase_pending': 'bool',
            'recipient': 'str',
            'thumbnail_image': 'str',
            'details_image': 'str',
            'banner_image': 'str',
            'canonical_version': 'str',
            'is_set_canonical': 'int',
            'licenses': 'object',
            'ratings': 'object',
            'dependencies': 'object',
            'canonical': 'object',
            'draft': 'object'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'slug': 'slug',
            'account': 'account',
            'name': 'name',
            'type': 'type',
            'base_package': 'base_package',
            'is_published': 'is_published',
            'package_status': 'package_status',
            'description': 'description',
            'rating_avg': 'rating_avg',
            'rating_count': 'rating_count',
            'modified_date': 'modified_date',
            'created_date': 'created_date',
            'user': 'user',
            'title': 'title',
            'purchase_pending': 'purchase_pending',
            'recipient': 'recipient',
            'thumbnail_image': 'thumbnail_image',
            'details_image': 'details_image',
            'banner_image': 'banner_image',
            'canonical_version': 'canonical_version',
            'is_set_canonical': 'is_set_canonical',
            'licenses': 'licenses',
            'ratings': 'ratings',
            'dependencies': 'dependencies',
            'canonical': 'canonical',
            'draft': 'draft'
        }

        self._href = href
        self._pk = pk
        self._slug = slug
        self._account = account
        self._name = name
        self._type = type
        self._base_package = base_package
        self._is_published = is_published
        self._package_status = package_status
        self._description = description
        self._rating_avg = rating_avg
        self._rating_count = rating_count
        self._modified_date = modified_date
        self._created_date = created_date
        self._user = user
        self._title = title
        self._purchase_pending = purchase_pending
        self._recipient = recipient
        self._thumbnail_image = thumbnail_image
        self._details_image = details_image
        self._banner_image = banner_image
        self._canonical_version = canonical_version
        self._is_set_canonical = is_set_canonical
        self._licenses = licenses
        self._ratings = ratings
        self._dependencies = dependencies
        self._canonical = canonical
        self._draft = draft

    @property
    def href(self):
        """
        Gets the href of this BlendedPackage.
        current object reference url

        :return: The href of this BlendedPackage.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this BlendedPackage.
        current object reference url

        :param href: The href of this BlendedPackage.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this BlendedPackage.
        value used to uniquely identify package.

        :return: The pk of this BlendedPackage.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this BlendedPackage.
        value used to uniquely identify package.

        :param pk: The pk of this BlendedPackage.
        :type: int
        """

        self._pk = pk

    @property
    def slug(self):
        """
        Gets the slug of this BlendedPackage.
        value used to uniquely identify package.

        :return: The slug of this BlendedPackage.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this BlendedPackage.
        value used to uniquely identify package.

        :param slug: The slug of this BlendedPackage.
        :type: str
        """

        self._slug = slug

    @property
    def account(self):
        """
        Gets the account of this BlendedPackage.
        value used to uniquely identify account.

        :return: The account of this BlendedPackage.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this BlendedPackage.
        value used to uniquely identify account.

        :param account: The account of this BlendedPackage.
        :type: str
        """

        self._account = account

    @property
    def name(self):
        """
        Gets the name of this BlendedPackage.
        package name.

        :return: The name of this BlendedPackage.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BlendedPackage.
        package name.

        :param name: The name of this BlendedPackage.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this BlendedPackage.
        package type

        :return: The type of this BlendedPackage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BlendedPackage.
        package type

        :param type: The type of this BlendedPackage.
        :type: str
        """

        self._type = type

    @property
    def base_package(self):
        """
        Gets the base_package of this BlendedPackage.
        base package pk.

        :return: The base_package of this BlendedPackage.
        :rtype: int
        """
        return self._base_package

    @base_package.setter
    def base_package(self, base_package):
        """
        Sets the base_package of this BlendedPackage.
        base package pk.

        :param base_package: The base_package of this BlendedPackage.
        :type: int
        """

        self._base_package = base_package

    @property
    def is_published(self):
        """
        Gets the is_published of this BlendedPackage.
        package is published or not.

        :return: The is_published of this BlendedPackage.
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """
        Sets the is_published of this BlendedPackage.
        package is published or not.

        :param is_published: The is_published of this BlendedPackage.
        :type: bool
        """

        self._is_published = is_published

    @property
    def package_status(self):
        """
        Gets the package_status of this BlendedPackage.
        package status

        :return: The package_status of this BlendedPackage.
        :rtype: str
        """
        return self._package_status

    @package_status.setter
    def package_status(self, package_status):
        """
        Sets the package_status of this BlendedPackage.
        package status

        :param package_status: The package_status of this BlendedPackage.
        :type: str
        """

        self._package_status = package_status

    @property
    def description(self):
        """
        Gets the description of this BlendedPackage.
        package description.

        :return: The description of this BlendedPackage.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BlendedPackage.
        package description.

        :param description: The description of this BlendedPackage.
        :type: str
        """

        self._description = description

    @property
    def rating_avg(self):
        """
        Gets the rating_avg of this BlendedPackage.
        average rating of package.

        :return: The rating_avg of this BlendedPackage.
        :rtype: float
        """
        return self._rating_avg

    @rating_avg.setter
    def rating_avg(self, rating_avg):
        """
        Sets the rating_avg of this BlendedPackage.
        average rating of package.

        :param rating_avg: The rating_avg of this BlendedPackage.
        :type: float
        """

        self._rating_avg = rating_avg

    @property
    def rating_count(self):
        """
        Gets the rating_count of this BlendedPackage.
        package total rating submitted.

        :return: The rating_count of this BlendedPackage.
        :rtype: float
        """
        return self._rating_count

    @rating_count.setter
    def rating_count(self, rating_count):
        """
        Sets the rating_count of this BlendedPackage.
        package total rating submitted.

        :param rating_count: The rating_count of this BlendedPackage.
        :type: float
        """

        self._rating_count = rating_count

    @property
    def modified_date(self):
        """
        Gets the modified_date of this BlendedPackage.
        last modified date.

        :return: The modified_date of this BlendedPackage.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this BlendedPackage.
        last modified date.

        :param modified_date: The modified_date of this BlendedPackage.
        :type: datetime
        """

        self._modified_date = modified_date

    @property
    def created_date(self):
        """
        Gets the created_date of this BlendedPackage.
        package creation date.

        :return: The created_date of this BlendedPackage.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this BlendedPackage.
        package creation date.

        :param created_date: The created_date of this BlendedPackage.
        :type: datetime
        """

        self._created_date = created_date

    @property
    def user(self):
        """
        Gets the user of this BlendedPackage.
        package creator name.

        :return: The user of this BlendedPackage.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this BlendedPackage.
        package creator name.

        :param user: The user of this BlendedPackage.
        :type: str
        """

        self._user = user

    @property
    def title(self):
        """
        Gets the title of this BlendedPackage.
        package title.

        :return: The title of this BlendedPackage.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this BlendedPackage.
        package title.

        :param title: The title of this BlendedPackage.
        :type: str
        """

        self._title = title

    @property
    def purchase_pending(self):
        """
        Gets the purchase_pending of this BlendedPackage.
        used in transfer to me only for purchase pending lookup.

        :return: The purchase_pending of this BlendedPackage.
        :rtype: bool
        """
        return self._purchase_pending

    @purchase_pending.setter
    def purchase_pending(self, purchase_pending):
        """
        Sets the purchase_pending of this BlendedPackage.
        used in transfer to me only for purchase pending lookup.

        :param purchase_pending: The purchase_pending of this BlendedPackage.
        :type: bool
        """

        self._purchase_pending = purchase_pending

    @property
    def recipient(self):
        """
        Gets the recipient of this BlendedPackage.
        account slug or email of recipient.

        :return: The recipient of this BlendedPackage.
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """
        Sets the recipient of this BlendedPackage.
        account slug or email of recipient.

        :param recipient: The recipient of this BlendedPackage.
        :type: str
        """

        self._recipient = recipient

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this BlendedPackage.
        

        :return: The thumbnail_image of this BlendedPackage.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this BlendedPackage.
        

        :param thumbnail_image: The thumbnail_image of this BlendedPackage.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def details_image(self):
        """
        Gets the details_image of this BlendedPackage.
        

        :return: The details_image of this BlendedPackage.
        :rtype: str
        """
        return self._details_image

    @details_image.setter
    def details_image(self, details_image):
        """
        Sets the details_image of this BlendedPackage.
        

        :param details_image: The details_image of this BlendedPackage.
        :type: str
        """

        self._details_image = details_image

    @property
    def banner_image(self):
        """
        Gets the banner_image of this BlendedPackage.
        Banner image of package

        :return: The banner_image of this BlendedPackage.
        :rtype: str
        """
        return self._banner_image

    @banner_image.setter
    def banner_image(self, banner_image):
        """
        Sets the banner_image of this BlendedPackage.
        Banner image of package

        :param banner_image: The banner_image of this BlendedPackage.
        :type: str
        """

        self._banner_image = banner_image

    @property
    def canonical_version(self):
        """
        Gets the canonical_version of this BlendedPackage.
        canonical_version of the package, most recent if canonical was not set.

        :return: The canonical_version of this BlendedPackage.
        :rtype: str
        """
        return self._canonical_version

    @canonical_version.setter
    def canonical_version(self, canonical_version):
        """
        Sets the canonical_version of this BlendedPackage.
        canonical_version of the package, most recent if canonical was not set.

        :param canonical_version: The canonical_version of this BlendedPackage.
        :type: str
        """

        self._canonical_version = canonical_version

    @property
    def is_set_canonical(self):
        """
        Gets the is_set_canonical of this BlendedPackage.
        flag to know if canonical version was set by user

        :return: The is_set_canonical of this BlendedPackage.
        :rtype: int
        """
        return self._is_set_canonical

    @is_set_canonical.setter
    def is_set_canonical(self, is_set_canonical):
        """
        Sets the is_set_canonical of this BlendedPackage.
        flag to know if canonical version was set by user

        :param is_set_canonical: The is_set_canonical of this BlendedPackage.
        :type: int
        """

        self._is_set_canonical = is_set_canonical

    @property
    def licenses(self):
        """
        Gets the licenses of this BlendedPackage.
        Package Licenses.

        :return: The licenses of this BlendedPackage.
        :rtype: object
        """
        return self._licenses

    @licenses.setter
    def licenses(self, licenses):
        """
        Sets the licenses of this BlendedPackage.
        Package Licenses.

        :param licenses: The licenses of this BlendedPackage.
        :type: object
        """

        self._licenses = licenses

    @property
    def ratings(self):
        """
        Gets the ratings of this BlendedPackage.
        Package ratings.

        :return: The ratings of this BlendedPackage.
        :rtype: object
        """
        return self._ratings

    @ratings.setter
    def ratings(self, ratings):
        """
        Sets the ratings of this BlendedPackage.
        Package ratings.

        :param ratings: The ratings of this BlendedPackage.
        :type: object
        """

        self._ratings = ratings

    @property
    def dependencies(self):
        """
        Gets the dependencies of this BlendedPackage.
        Package ratings.

        :return: The dependencies of this BlendedPackage.
        :rtype: object
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """
        Sets the dependencies of this BlendedPackage.
        Package ratings.

        :param dependencies: The dependencies of this BlendedPackage.
        :type: object
        """

        self._dependencies = dependencies

    @property
    def canonical(self):
        """
        Gets the canonical of this BlendedPackage.
        Canonical Package Details.

        :return: The canonical of this BlendedPackage.
        :rtype: object
        """
        return self._canonical

    @canonical.setter
    def canonical(self, canonical):
        """
        Sets the canonical of this BlendedPackage.
        Canonical Package Details.

        :param canonical: The canonical of this BlendedPackage.
        :type: object
        """

        self._canonical = canonical

    @property
    def draft(self):
        """
        Gets the draft of this BlendedPackage.
        Canonical Package Details.

        :return: The draft of this BlendedPackage.
        :rtype: object
        """
        return self._draft

    @draft.setter
    def draft(self, draft):
        """
        Sets the draft of this BlendedPackage.
        Canonical Package Details.

        :param draft: The draft of this BlendedPackage.
        :type: object
        """

        self._draft = draft

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
