# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class AddPending(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, email=None, account_slug=None, access_type=None):
        """
        AddPending - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email': 'str',
            'account_slug': 'str',
            'access_type': 'str'
        }

        self.attribute_map = {
            'email': 'email',
            'account_slug': 'account_slug',
            'access_type': 'access_type'
        }

        self._email = email
        self._account_slug = account_slug
        self._access_type = access_type

    @property
    def email(self):
        """
        Gets the email of this AddPending.
        email that needs to be invite to join accoun.

        :return: The email of this AddPending.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this AddPending.
        email that needs to be invite to join accoun.

        :param email: The email of this AddPending.
        :type: str
        """

        self._email = email

    @property
    def account_slug(self):
        """
        Gets the account_slug of this AddPending.
        account slug of user that needs to be invite to join accoun

        :return: The account_slug of this AddPending.
        :rtype: str
        """
        return self._account_slug

    @account_slug.setter
    def account_slug(self, account_slug):
        """
        Sets the account_slug of this AddPending.
        account slug of user that needs to be invite to join accoun

        :param account_slug: The account_slug of this AddPending.
        :type: str
        """

        self._account_slug = account_slug

    @property
    def access_type(self):
        """
        Gets the access_type of this AddPending.
        Account permission for the invitee user.

        :return: The access_type of this AddPending.
        :rtype: str
        """
        return self._access_type

    @access_type.setter
    def access_type(self, access_type):
        """
        Sets the access_type of this AddPending.
        Account permission for the invitee user.

        :param access_type: The access_type of this AddPending.
        :type: str
        """

        self._access_type = access_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
