# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class AcquisitionResponseData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, slug=None, title=None, revoked_for=None, revoked_by=None, shared_to=None, shared_by=None, transferred_to=None, transferred_by=None, redirect_url=None):
        """
        AcquisitionResponseData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'str',
            'slug': 'str',
            'title': 'str',
            'revoked_for': 'str',
            'revoked_by': 'str',
            'shared_to': 'str',
            'shared_by': 'str',
            'transferred_to': 'str',
            'transferred_by': 'str',
            'redirect_url': 'str'
        }

        self.attribute_map = {
            'account': 'account',
            'slug': 'slug',
            'title': 'title',
            'revoked_for': 'revoked_for',
            'revoked_by': 'revoked_by',
            'shared_to': 'shared_to',
            'shared_by': 'shared_by',
            'transferred_to': 'transferred_to',
            'transferred_by': 'transferred_by',
            'redirect_url': 'redirect_url'
        }

        self._account = account
        self._slug = slug
        self._title = title
        self._revoked_for = revoked_for
        self._revoked_by = revoked_by
        self._shared_to = shared_to
        self._shared_by = shared_by
        self._transferred_to = transferred_to
        self._transferred_by = transferred_by
        self._redirect_url = redirect_url

    @property
    def account(self):
        """
        Gets the account of this AcquisitionResponseData.
        account slug of package

        :return: The account of this AcquisitionResponseData.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this AcquisitionResponseData.
        account slug of package

        :param account: The account of this AcquisitionResponseData.
        :type: str
        """

        self._account = account

    @property
    def slug(self):
        """
        Gets the slug of this AcquisitionResponseData.
        slug of package

        :return: The slug of this AcquisitionResponseData.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this AcquisitionResponseData.
        slug of package

        :param slug: The slug of this AcquisitionResponseData.
        :type: str
        """

        self._slug = slug

    @property
    def title(self):
        """
        Gets the title of this AcquisitionResponseData.
        title of package

        :return: The title of this AcquisitionResponseData.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this AcquisitionResponseData.
        title of package

        :param title: The title of this AcquisitionResponseData.
        :type: str
        """

        self._title = title

    @property
    def revoked_for(self):
        """
        Gets the revoked_for of this AcquisitionResponseData.
        acquisition revoked for account/email

        :return: The revoked_for of this AcquisitionResponseData.
        :rtype: str
        """
        return self._revoked_for

    @revoked_for.setter
    def revoked_for(self, revoked_for):
        """
        Sets the revoked_for of this AcquisitionResponseData.
        acquisition revoked for account/email

        :param revoked_for: The revoked_for of this AcquisitionResponseData.
        :type: str
        """

        self._revoked_for = revoked_for

    @property
    def revoked_by(self):
        """
        Gets the revoked_by of this AcquisitionResponseData.
        acquisition revoked by account

        :return: The revoked_by of this AcquisitionResponseData.
        :rtype: str
        """
        return self._revoked_by

    @revoked_by.setter
    def revoked_by(self, revoked_by):
        """
        Sets the revoked_by of this AcquisitionResponseData.
        acquisition revoked by account

        :param revoked_by: The revoked_by of this AcquisitionResponseData.
        :type: str
        """

        self._revoked_by = revoked_by

    @property
    def shared_to(self):
        """
        Gets the shared_to of this AcquisitionResponseData.
        shared to account

        :return: The shared_to of this AcquisitionResponseData.
        :rtype: str
        """
        return self._shared_to

    @shared_to.setter
    def shared_to(self, shared_to):
        """
        Sets the shared_to of this AcquisitionResponseData.
        shared to account

        :param shared_to: The shared_to of this AcquisitionResponseData.
        :type: str
        """

        self._shared_to = shared_to

    @property
    def shared_by(self):
        """
        Gets the shared_by of this AcquisitionResponseData.
        shared by account.

        :return: The shared_by of this AcquisitionResponseData.
        :rtype: str
        """
        return self._shared_by

    @shared_by.setter
    def shared_by(self, shared_by):
        """
        Sets the shared_by of this AcquisitionResponseData.
        shared by account.

        :param shared_by: The shared_by of this AcquisitionResponseData.
        :type: str
        """

        self._shared_by = shared_by

    @property
    def transferred_to(self):
        """
        Gets the transferred_to of this AcquisitionResponseData.
        transferred to account

        :return: The transferred_to of this AcquisitionResponseData.
        :rtype: str
        """
        return self._transferred_to

    @transferred_to.setter
    def transferred_to(self, transferred_to):
        """
        Sets the transferred_to of this AcquisitionResponseData.
        transferred to account

        :param transferred_to: The transferred_to of this AcquisitionResponseData.
        :type: str
        """

        self._transferred_to = transferred_to

    @property
    def transferred_by(self):
        """
        Gets the transferred_by of this AcquisitionResponseData.
        transferred by account.

        :return: The transferred_by of this AcquisitionResponseData.
        :rtype: str
        """
        return self._transferred_by

    @transferred_by.setter
    def transferred_by(self, transferred_by):
        """
        Sets the transferred_by of this AcquisitionResponseData.
        transferred by account.

        :param transferred_by: The transferred_by of this AcquisitionResponseData.
        :type: str
        """

        self._transferred_by = transferred_by

    @property
    def redirect_url(self):
        """
        Gets the redirect_url of this AcquisitionResponseData.
        url if redirection to website is needed at all.

        :return: The redirect_url of this AcquisitionResponseData.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this AcquisitionResponseData.
        url if redirection to website is needed at all.

        :param redirect_url: The redirect_url of this AcquisitionResponseData.
        :type: str
        """

        self._redirect_url = redirect_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
