# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Acquisition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, type=None, label=None, account_name=None, new_package_slug=None, new_package_title=None, license_name=None, email=None, message=None, auto_share_packages=None, purchase_packages=None):
        """
        Acquisition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'label': 'str',
            'account_name': 'str',
            'new_package_slug': 'str',
            'new_package_title': 'str',
            'license_name': 'str',
            'email': 'str',
            'message': 'str',
            'auto_share_packages': 'list[str]',
            'purchase_packages': 'list[str]'
        }

        self.attribute_map = {
            'type': 'type',
            'label': 'label',
            'account_name': 'account_name',
            'new_package_slug': 'new_package_slug',
            'new_package_title': 'new_package_title',
            'license_name': 'license_name',
            'email': 'email',
            'message': 'message',
            'auto_share_packages': 'auto_share_packages',
            'purchase_packages': 'purchase_packages'
        }

        self._type = type
        self._label = label
        self._account_name = account_name
        self._new_package_slug = new_package_slug
        self._new_package_title = new_package_title
        self._license_name = license_name
        self._email = email
        self._message = message
        self._auto_share_packages = auto_share_packages
        self._purchase_packages = purchase_packages

    @property
    def type(self):
        """
        Gets the type of this Acquisition.
        Type of acquisition user is going to create.Example : share, get,buy,transfer,extend and clone.

        :return: The type of this Acquisition.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Acquisition.
        Type of acquisition user is going to create.Example : share, get,buy,transfer,extend and clone.

        :param type: The type of this Acquisition.
        :type: str
        """

        self._type = type

    @property
    def label(self):
        """
        Gets the label of this Acquisition.
        version of the package for clone. 

        :return: The label of this Acquisition.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Acquisition.
        version of the package for clone. 

        :param label: The label of this Acquisition.
        :type: str
        """

        self._label = label

    @property
    def account_name(self):
        """
        Gets the account_name of this Acquisition.
        Name of the account where user wants to share or transfer package.

        :return: The account_name of this Acquisition.
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """
        Sets the account_name of this Acquisition.
        Name of the account where user wants to share or transfer package.

        :param account_name: The account_name of this Acquisition.
        :type: str
        """

        self._account_name = account_name

    @property
    def new_package_slug(self):
        """
        Gets the new_package_slug of this Acquisition.
        new package name used in clone and extend package.

        :return: The new_package_slug of this Acquisition.
        :rtype: str
        """
        return self._new_package_slug

    @new_package_slug.setter
    def new_package_slug(self, new_package_slug):
        """
        Sets the new_package_slug of this Acquisition.
        new package name used in clone and extend package.

        :param new_package_slug: The new_package_slug of this Acquisition.
        :type: str
        """

        self._new_package_slug = new_package_slug

    @property
    def new_package_title(self):
        """
        Gets the new_package_title of this Acquisition.
        new package title used in clone and extend package.

        :return: The new_package_title of this Acquisition.
        :rtype: str
        """
        return self._new_package_title

    @new_package_title.setter
    def new_package_title(self, new_package_title):
        """
        Sets the new_package_title of this Acquisition.
        new package title used in clone and extend package.

        :param new_package_title: The new_package_title of this Acquisition.
        :type: str
        """

        self._new_package_title = new_package_title

    @property
    def license_name(self):
        """
        Gets the license_name of this Acquisition.
        Name of the license used to buy or get package.

        :return: The license_name of this Acquisition.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this Acquisition.
        Name of the license used to buy or get package.

        :param license_name: The license_name of this Acquisition.
        :type: str
        """

        self._license_name = license_name

    @property
    def email(self):
        """
        Gets the email of this Acquisition.
        Email address for Inviting user via email.

        :return: The email of this Acquisition.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this Acquisition.
        Email address for Inviting user via email.

        :param email: The email of this Acquisition.
        :type: str
        """

        self._email = email

    @property
    def message(self):
        """
        Gets the message of this Acquisition.
        Message will be send with the invite in the email.

        :return: The message of this Acquisition.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this Acquisition.
        Message will be send with the invite in the email.

        :param message: The message of this Acquisition.
        :type: str
        """

        self._message = message

    @property
    def auto_share_packages(self):
        """
        Gets the auto_share_packages of this Acquisition.
        list of dependency packages which needs to shared.

        :return: The auto_share_packages of this Acquisition.
        :rtype: list[str]
        """
        return self._auto_share_packages

    @auto_share_packages.setter
    def auto_share_packages(self, auto_share_packages):
        """
        Sets the auto_share_packages of this Acquisition.
        list of dependency packages which needs to shared.

        :param auto_share_packages: The auto_share_packages of this Acquisition.
        :type: list[str]
        """

        self._auto_share_packages = auto_share_packages

    @property
    def purchase_packages(self):
        """
        Gets the purchase_packages of this Acquisition.
        list of dependency packages which needs to purchases.

        :return: The purchase_packages of this Acquisition.
        :rtype: list[str]
        """
        return self._purchase_packages

    @purchase_packages.setter
    def purchase_packages(self, purchase_packages):
        """
        Sets the purchase_packages of this Acquisition.
        list of dependency packages which needs to purchases.

        :param purchase_packages: The purchase_packages of this Acquisition.
        :type: list[str]
        """

        self._purchase_packages = purchase_packages

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
