# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class AccountInvitePending(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, role=None, received_date=None, profile_picture=None):
        """
        AccountInvitePending - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'str',
            'role': 'str',
            'received_date': 'datetime',
            'profile_picture': 'str'
        }

        self.attribute_map = {
            'account': 'account',
            'role': 'role',
            'received_date': 'received_date',
            'profile_picture': 'profile_picture'
        }

        self._account = account
        self._role = role
        self._received_date = received_date
        self._profile_picture = profile_picture

    @property
    def account(self):
        """
        Gets the account of this AccountInvitePending.
        pending account slug.

        :return: The account of this AccountInvitePending.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this AccountInvitePending.
        pending account slug.

        :param account: The account of this AccountInvitePending.
        :type: str
        """

        self._account = account

    @property
    def role(self):
        """
        Gets the role of this AccountInvitePending.
        role for which user is invited.

        :return: The role of this AccountInvitePending.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this AccountInvitePending.
        role for which user is invited.

        :param role: The role of this AccountInvitePending.
        :type: str
        """

        self._role = role

    @property
    def received_date(self):
        """
        Gets the received_date of this AccountInvitePending.
        received date of request.

        :return: The received_date of this AccountInvitePending.
        :rtype: datetime
        """
        return self._received_date

    @received_date.setter
    def received_date(self, received_date):
        """
        Sets the received_date of this AccountInvitePending.
        received date of request.

        :param received_date: The received_date of this AccountInvitePending.
        :type: datetime
        """

        self._received_date = received_date

    @property
    def profile_picture(self):
        """
        Gets the profile_picture of this AccountInvitePending.
        if profile picture available it will have url else null

        :return: The profile_picture of this AccountInvitePending.
        :rtype: str
        """
        return self._profile_picture

    @profile_picture.setter
    def profile_picture(self, profile_picture):
        """
        Sets the profile_picture of this AccountInvitePending.
        if profile picture available it will have url else null

        :param profile_picture: The profile_picture of this AccountInvitePending.
        :type: str
        """

        self._profile_picture = profile_picture

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
