# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class PackagesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def accept_acquisition(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to accept package.
        To share,transfer, get, buy, extend and clone a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.accept_acquisition(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: account slug used to uniquely identify a package. (required)
        :param str slug: package slug used to uniquely identify a package. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Body body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.accept_acquisition_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.accept_acquisition_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def accept_acquisition_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to accept package.
        To share,transfer, get, buy, extend and clone a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.accept_acquisition_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: account slug used to uniquely identify a package. (required)
        :param str slug: package slug used to uniquely identify a package. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Body body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_acquisition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `accept_acquisition`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `accept_acquisition`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `accept_acquisition`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `accept_acquisition`")

        resource_path = '/packages/{accountSlug}/{slug}/acquisitions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AcquisitionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def acquire_package(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        To share,transfer, get, buy, extend and clone a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.acquire_package(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Acquisition body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.acquire_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.acquire_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def acquire_package_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        To share,transfer, get, buy, extend and clone a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.acquire_package_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Acquisition body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acquire_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `acquire_package`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `acquire_package`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `acquire_package`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `acquire_package`")

        resource_path = '/packages/{accountSlug}/{slug}/acquisitions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AcquisitionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def add_license(self, account_slug, slug, label, sessionkey, body, **kwargs):
        """
        Add a license to package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_license(account_slug, slug, label, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddLicense body: request data used to add package license. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_license_with_http_info(account_slug, slug, label, sessionkey, body, **kwargs)
        else:
            (data) = self.add_license_with_http_info(account_slug, slug, label, sessionkey, body, **kwargs)
            return data

    def add_license_with_http_info(self, account_slug, slug, label, sessionkey, body, **kwargs):
        """
        Add a license to package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_license_with_http_info(account_slug, slug, label, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddLicense body: request data used to add package license. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `add_license`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `add_license`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `add_license`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `add_license`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_license`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/licenses/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def add_like(self, account_slug, slug, sessionkey, **kwargs):
        """
        Add a like to a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_like(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_like_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.add_like_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def add_like_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Add a like to a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_like_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_like" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `add_like`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `add_like`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `add_like`")

        resource_path = '/packages/{accountSlug}/{slug}/likes/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def add_rating(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Add a rating to a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_rating(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddRating body: request data used to add package rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_rating_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.add_rating_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def add_rating_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Add a rating to a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_rating_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddRating body: request data used to add package rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_rating" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `add_rating`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `add_rating`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `add_rating`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_rating`")

        resource_path = '/packages/{accountSlug}/{slug}/ratings/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def canonical_set(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Get package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.canonical_set(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accountSlug (required)
        :param str slug: package slug used to uniquely identify a package. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreateCanonical body: request data used to update package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.canonical_set_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.canonical_set_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def canonical_set_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Get package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.canonical_set_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accountSlug (required)
        :param str slug: package slug used to uniquely identify a package. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreateCanonical body: request data used to update package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method canonical_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `canonical_set`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `canonical_set`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `canonical_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `canonical_set`")

        resource_path = '/packages/{accountSlug}/{slug}/canonical/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_draft(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Create package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_draft(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateDraft body: request data used to create package draft. (required)
        :return: NewDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_draft_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.create_draft_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def create_draft_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Create package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_draft_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateDraft body: request data used to create package draft. (required)
        :return: NewDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_draft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `create_draft`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `create_draft`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `create_draft`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_draft`")

        resource_path = '/packages/{accountSlug}/{slug}/draft/documents/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NewDraft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_package(self, account_slug, sessionkey, body, **kwargs):
        """
        Create Package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package(account_slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreatePackage body: request data used to create package. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_package_with_http_info(account_slug, sessionkey, body, **kwargs)
        else:
            (data) = self.create_package_with_http_info(account_slug, sessionkey, body, **kwargs)
            return data

    def create_package_with_http_info(self, account_slug, sessionkey, body, **kwargs):
        """
        Create Package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package_with_http_info(account_slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreatePackage body: request data used to create package. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'sessionkey', 'body', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `create_package`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `create_package`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_package`")

        resource_path = '/packages/{accountSlug}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BlendedPackage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def download(self, account_slug, slug, label, **kwargs):
        """
        get version documents
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download(account_slug, slug, label, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: value used to uniquely identify version. (required)
        :param str sessionkey: value used to manage user session.
        :param str as_hashes: value used to return only hashes
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_with_http_info(account_slug, slug, label, **kwargs)
        else:
            (data) = self.download_with_http_info(account_slug, slug, label, **kwargs)
            return data

    def download_with_http_info(self, account_slug, slug, label, **kwargs):
        """
        get version documents
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_with_http_info(account_slug, slug, label, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: value used to uniquely identify version. (required)
        :param str sessionkey: value used to manage user session.
        :param str as_hashes: value used to return only hashes
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'sessionkey', 'as_hashes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `download`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `download`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `download`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/documents/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']

        query_params = {}
        if 'as_hashes' in params:
            query_params['as_hashes'] = params['as_hashes']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[object]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def download_canonical(self, account_slug, slug, **kwargs):
        """
        API used to Download a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_canonical(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_canonical_with_http_info(account_slug, slug, **kwargs)
        else:
            (data) = self.download_canonical_with_http_info(account_slug, slug, **kwargs)
            return data

    def download_canonical_with_http_info(self, account_slug, slug, **kwargs):
        """
        API used to Download a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_canonical_with_http_info(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_canonical" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `download_canonical`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `download_canonical`")

        resource_path = '/packages/{accountSlug}/{slug}/canonical/documents/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[object]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def download_draft(self, account_slug, slug, sessionkey, **kwargs):
        """
        Download package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_draft(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str as_hashes: value used to return only hashes
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_draft_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.download_draft_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def download_draft_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Download package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_draft_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str as_hashes: value used to return only hashes
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'as_hashes']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_draft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `download_draft`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `download_draft`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `download_draft`")

        resource_path = '/packages/{accountSlug}/{slug}/draft/documents/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'as_hashes' in params:
            query_params['as_hashes'] = params['as_hashes']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[object]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_acquired_package_account_list(self, account_slug, slug, sessionkey, **kwargs):
        """
        API to acquire package between accounts.
        To get list of account with whom package is shared with.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_acquired_package_account_list(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str share: value used to pass query parameter 'share' in the url.
        :return: SharedPackageAccountsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_acquired_package_account_list_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_acquired_package_account_list_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_acquired_package_account_list_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        API to acquire package between accounts.
        To get list of account with whom package is shared with.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_acquired_package_account_list_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str share: value used to pass query parameter 'share' in the url.
        :return: SharedPackageAccountsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'share']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_acquired_package_account_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_acquired_package_account_list`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_acquired_package_account_list`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_acquired_package_account_list`")

        resource_path = '/packages/{accountSlug}/{slug}/acquisitions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'share' in params:
            query_params['share'] = params['share']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SharedPackageAccountsList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_canonical(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get detail view of canonical version of a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_canonical(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: CanonicalVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_canonical_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_canonical_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_canonical_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get detail view of canonical version of a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_canonical_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: CanonicalVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_canonical" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_canonical`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_canonical`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_canonical`")

        resource_path = '/packages/{accountSlug}/{slug}/canonical/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CanonicalVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_dependencies(self, account_slug, slug, sessionkey, **kwargs):
        """
        Return package dependencies.
        Returns package dependencies.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dependencies(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: DependenciesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_dependencies_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_dependencies_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_dependencies_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Return package dependencies.
        Returns package dependencies.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dependencies_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: DependenciesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dependencies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_dependencies`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_dependencies`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_dependencies`")

        resource_path = '/packages/{accountSlug}/{slug}/dependencies/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependenciesList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_detail_document(self, account_slug, slug, name, sessionkey, **kwargs):
        """
        Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_detail_document(account_slug, slug, name, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str name: path of the directory. Ex. - meta/config.css (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_detail_document_with_http_info(account_slug, slug, name, sessionkey, **kwargs)
        else:
            (data) = self.get_detail_document_with_http_info(account_slug, slug, name, sessionkey, **kwargs)
            return data

    def get_detail_document_with_http_info(self, account_slug, slug, name, sessionkey, **kwargs):
        """
        Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_detail_document_with_http_info(account_slug, slug, name, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str name: path of the directory. Ex. - meta/config.css (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'name', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_detail_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_detail_document`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_detail_document`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_detail_document`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_detail_document`")

        resource_path = '/packages/{accountSlug}/{slug}/draft/documents/{name}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[object]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_draft(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_draft(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: HyperLinkDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_draft_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_draft_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_draft_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_draft_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: HyperLinkDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_draft`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_draft`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_draft`")

        resource_path = '/packages/{accountSlug}/{slug}/draft/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HyperLinkDraft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_licenses(self, account_slug, slug, label, sessionkey, **kwargs):
        """
        Get list of licenses associated with package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_licenses(account_slug, slug, label, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: HyperLinkLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_licenses_with_http_info(account_slug, slug, label, sessionkey, **kwargs)
        else:
            (data) = self.get_licenses_with_http_info(account_slug, slug, label, sessionkey, **kwargs)
            return data

    def get_licenses_with_http_info(self, account_slug, slug, label, sessionkey, **kwargs):
        """
        Get list of licenses associated with package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_licenses_with_http_info(account_slug, slug, label, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: HyperLinkLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_licenses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_licenses`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_licenses`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `get_licenses`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_licenses`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/licenses/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HyperLinkLicenses',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_package_details(self, account_slug, slug, sessionkey, **kwargs):
        """
        Package Detail view.
        Returns a single package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_details(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_package_details_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_package_details_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_package_details_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Package Detail view.
        Returns a single package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_details_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_package_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_package_details`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_package_details`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_package_details`")

        resource_path = '/packages/{accountSlug}/{slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BlendedPackage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_package_initial(self, **kwargs):
        """
        Packages initial 
        default packages for any user (public packages available at initial time)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_initial(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InitialPackages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_package_initial_with_http_info(**kwargs)
        else:
            (data) = self.get_package_initial_with_http_info(**kwargs)
            return data

    def get_package_initial_with_http_info(self, **kwargs):
        """
        Packages initial 
        default packages for any user (public packages available at initial time)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_initial_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InitialPackages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_package_initial" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/packages/initial/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InitialPackages',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_packages(self, account_slug, sessionkey, **kwargs):
        """
        Packages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_packages(account_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :param str share: parameter to provide list of packages that are shared with current account.
        :param str snapshot: parameter to provide list of packages that have snapshots with current account.
        :param str dependency: parameter to provide list of dependency packages of all packages of current account.
        :param str purchased: parameter to provide list of packages that are purchased (free or paid) in current account.
        :param str transfer_by_me: value used to pass query parameter 'transfer_by_me' in the url.
        :param str transfer_to_me: value used to pass query parameter 'transfer_to_me' in the url.
        :param str published: value used to pass query parameter 'published' in the url.
        :param str owned_by_account: owner of packages on which you too have acquisition.
        :param str org_packages: For getting packages of organizations
        :return: Packages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_packages_with_http_info(account_slug, sessionkey, **kwargs)
        else:
            (data) = self.get_packages_with_http_info(account_slug, sessionkey, **kwargs)
            return data

    def get_packages_with_http_info(self, account_slug, sessionkey, **kwargs):
        """
        Packages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_packages_with_http_info(account_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :param str share: parameter to provide list of packages that are shared with current account.
        :param str snapshot: parameter to provide list of packages that have snapshots with current account.
        :param str dependency: parameter to provide list of dependency packages of all packages of current account.
        :param str purchased: parameter to provide list of packages that are purchased (free or paid) in current account.
        :param str transfer_by_me: value used to pass query parameter 'transfer_by_me' in the url.
        :param str transfer_to_me: value used to pass query parameter 'transfer_to_me' in the url.
        :param str published: value used to pass query parameter 'published' in the url.
        :param str owned_by_account: owner of packages on which you too have acquisition.
        :param str org_packages: For getting packages of organizations
        :return: Packages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'sessionkey', 'verbose', 'share', 'snapshot', 'dependency', 'purchased', 'transfer_by_me', 'transfer_to_me', 'published', 'owned_by_account', 'org_packages']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_packages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_packages`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_packages`")

        resource_path = '/packages/{accountSlug}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']
        if 'share' in params:
            query_params['share'] = params['share']
        if 'snapshot' in params:
            query_params['snapshot'] = params['snapshot']
        if 'dependency' in params:
            query_params['dependency'] = params['dependency']
        if 'purchased' in params:
            query_params['purchased'] = params['purchased']
        if 'transfer_by_me' in params:
            query_params['transfer_by_me'] = params['transfer_by_me']
        if 'transfer_to_me' in params:
            query_params['transfer_to_me'] = params['transfer_to_me']
        if 'published' in params:
            query_params['published'] = params['published']
        if 'owned_by_account' in params:
            query_params['owned_by_account'] = params['owned_by_account']
        if 'org_packages' in params:
            query_params['org_packages'] = params['org_packages']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Packages',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_publication(self, account_slug, slug, **kwargs):
        """
        API used to get a package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_publication(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: Publications
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_publication_with_http_info(account_slug, slug, **kwargs)
        else:
            (data) = self.get_publication_with_http_info(account_slug, slug, **kwargs)
            return data

    def get_publication_with_http_info(self, account_slug, slug, **kwargs):
        """
        API used to get a package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_publication_with_http_info(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: Publications
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_publication" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_publication`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_publication`")

        resource_path = '/packages/{accountSlug}/{slug}/publications/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Publications',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_rating_details(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get Details of package rating submitted by any user.
        Returns package rating details.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rating_details(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Rating
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_rating_details_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_rating_details_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_rating_details_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Get Details of package rating submitted by any user.
        Returns package rating details.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rating_details_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Rating
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rating_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_rating_details`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_rating_details`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_rating_details`")

        resource_path = '/packages/{accountSlug}/{slug}/ratingdetails/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Rating',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_ratings(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns list of ratings submitted by users for a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ratings(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: HyperLinkRatings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_ratings_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_ratings_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_ratings_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns list of ratings submitted by users for a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ratings_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: HyperLinkRatings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ratings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_ratings`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_ratings`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_ratings`")

        resource_path = '/packages/{accountSlug}/{slug}/ratings/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HyperLinkRatings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_version_bundles(self, account_slug, slug, **kwargs):
        """
        API used to get a package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version_bundles(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: PublicationVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_version_bundles_with_http_info(account_slug, slug, **kwargs)
        else:
            (data) = self.get_version_bundles_with_http_info(account_slug, slug, **kwargs)
            return data

    def get_version_bundles_with_http_info(self, account_slug, slug, **kwargs):
        """
        API used to get a package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version_bundles_with_http_info(account_slug, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session.
        :return: PublicationVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version_bundles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_version_bundles`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_version_bundles`")

        resource_path = '/packages/{accountSlug}/{slug}/versionbundles/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PublicationVersions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_version_details(self, account_slug, slug, label, sessionkey, **kwargs):
        """
        get version data of a package in details.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version_details(account_slug, slug, label, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: value used to uniquely identify version. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_version_details_with_http_info(account_slug, slug, label, sessionkey, **kwargs)
        else:
            (data) = self.get_version_details_with_http_info(account_slug, slug, label, sessionkey, **kwargs)
            return data

    def get_version_details_with_http_info(self, account_slug, slug, label, sessionkey, **kwargs):
        """
        get version data of a package in details.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version_details_with_http_info(account_slug, slug, label, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: value used to uniquely identify version. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_version_details`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_version_details`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `get_version_details`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_version_details`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Version',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_versions(self, account_slug, slug, sessionkey, **kwargs):
        """
        return the list of package version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_versions(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Versions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_versions_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.get_versions_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def get_versions_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        return the list of package version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_versions_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Versions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `get_versions`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_versions`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_versions`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Versions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def getlike(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns like submitted by users for a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.getlike(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Like
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.getlike_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.getlike_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def getlike_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns like submitted by users for a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.getlike_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Like
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method getlike" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `getlike`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `getlike`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `getlike`")

        resource_path = '/packages/{accountSlug}/{slug}/likes/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Like',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def package_account_list(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns list of users.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.package_account_list(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.package_account_list_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.package_account_list_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def package_account_list_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        Returns list of users.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.package_account_list_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method package_account_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `package_account_list`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `package_account_list`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `package_account_list`")

        resource_path = '/packages/{accountSlug}/{slug}/accounts/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Users',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def reject_acquisition_invite(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        to resend email invite link for given acquisition type to other account

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reject_acquisition_invite(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param RejectAcquisitionPackage body: request data used to acquire package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reject_acquisition_invite_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.reject_acquisition_invite_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def reject_acquisition_invite_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        to resend email invite link for given acquisition type to other account

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reject_acquisition_invite_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param RejectAcquisitionPackage body: request data used to acquire package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_acquisition_invite" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `reject_acquisition_invite`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `reject_acquisition_invite`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `reject_acquisition_invite`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reject_acquisition_invite`")

        resource_path = '/packages/{accountSlug}/{slug}/reject/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_license(self, account_slug, slug, label, name, sessionkey, **kwargs):
        """
        delete a package license.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_license(account_slug, slug, label, name, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str name: name of the license (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_license_with_http_info(account_slug, slug, label, name, sessionkey, **kwargs)
        else:
            (data) = self.remove_license_with_http_info(account_slug, slug, label, name, sessionkey, **kwargs)
            return data

    def remove_license_with_http_info(self, account_slug, slug, label, name, sessionkey, **kwargs):
        """
        delete a package license.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_license_with_http_info(account_slug, slug, label, name, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str name: name of the license (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'name', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `remove_license`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_license`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `remove_license`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `remove_license`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_license`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_like(self, account_slug, slug, sessionkey, **kwargs):
        """
        delete a package like.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_like(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_like_with_http_info(account_slug, slug, sessionkey, **kwargs)
        else:
            (data) = self.remove_like_with_http_info(account_slug, slug, sessionkey, **kwargs)
            return data

    def remove_like_with_http_info(self, account_slug, slug, sessionkey, **kwargs):
        """
        delete a package like.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_like_with_http_info(account_slug, slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_like" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `remove_like`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_like`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_like`")

        resource_path = '/packages/{accountSlug}/{slug}/likes/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def resend_invite(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        to resend email invite link for given acquisition type to other account

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.resend_invite(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ResendInvite body: request data used to acquire package. (required)
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.resend_invite_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.resend_invite_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def resend_invite_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        to resend email invite link for given acquisition type to other account

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.resend_invite_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ResendInvite body: request data used to acquire package. (required)
        :return: BlendedPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_invite" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `resend_invite`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `resend_invite`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `resend_invite`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `resend_invite`")

        resource_path = '/packages/{accountSlug}/{slug}/resend/invite/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BlendedPackage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def revoke_acquired_package(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        To revoke share a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_acquired_package(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Acquisition body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.revoke_acquired_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.revoke_acquired_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def revoke_acquired_package_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        API to acquire package between accounts.
        To revoke share a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.revoke_acquired_package_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: accounts slug (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Acquisition body: request data used to acquire package. (required)
        :return: AcquisitionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_acquired_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `revoke_acquired_package`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `revoke_acquired_package`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `revoke_acquired_package`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `revoke_acquired_package`")

        resource_path = '/packages/{accountSlug}/{slug}/acquisitions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AcquisitionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def search(self, **kwargs):
        """
        Search Packages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_by: filter by parameters.
        :param str order_by: to order package display.
        :param int page: page to display.
        :param str pattern: search pattern string
        :return: SearchResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_with_http_info(**kwargs)
        else:
            (data) = self.search_with_http_info(**kwargs)
            return data

    def search_with_http_info(self, **kwargs):
        """
        Search Packages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter_by: filter by parameters.
        :param str order_by: to order package display.
        :param int page: page to display.
        :param str pattern: search pattern string
        :return: SearchResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter_by', 'order_by', 'page', 'pattern']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/search/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'filter_by' in params:
            query_params['filter_by'] = params['filter_by']
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'pattern' in params:
            query_params['pattern'] = params['pattern']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SearchResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def snapshot(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Create a snapshot of a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.snapshot(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreateVersion body: request data used to snapshot package. (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.snapshot_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.snapshot_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def snapshot_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Create a snapshot of a package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.snapshot_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param CreateVersion body: request data used to snapshot package. (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `snapshot`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `snapshot`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `snapshot`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `snapshot`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Version',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_draft(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_draft(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateDraft body: request data used to update package draft. (required)
        :return: NewDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_draft_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.update_draft_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def update_draft_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update package draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_draft_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateDraft body: request data used to update package draft. (required)
        :return: NewDraft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `update_draft`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_draft`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `update_draft`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_draft`")

        resource_path = '/packages/{accountSlug}/{slug}/draft/documents/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NewDraft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_license(self, account_slug, slug, label, name, sessionkey, body, **kwargs):
        """
        Update price of package license.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_license(account_slug, slug, label, name, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str name: name of the license (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateLicense body: request data used to update license price. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_license_with_http_info(account_slug, slug, label, name, sessionkey, body, **kwargs)
        else:
            (data) = self.update_license_with_http_info(account_slug, slug, label, name, sessionkey, body, **kwargs)
            return data

    def update_license_with_http_info(self, account_slug, slug, label, name, sessionkey, body, **kwargs):
        """
        Update price of package license.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_license_with_http_info(account_slug, slug, label, name, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str label: label for the version (required)
        :param str name: name of the license (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdateLicense body: request data used to update license price. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'label', 'name', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `update_license`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_license`")
        # verify the required parameter 'label' is set
        if ('label' not in params) or (params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `update_license`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `update_license`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `update_license`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_license`")

        resource_path = '/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'label' in params:
            path_params['label'] = params['label']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_package(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update Package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdatePackage body: request data used to update package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.update_package_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def update_package_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update Package.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param UpdatePackage body: request data used to update package. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `update_package`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_package`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `update_package`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_package`")

        resource_path = '/packages/{accountSlug}/{slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_publication(self, account_slug, slug, body, **kwargs):
        """
        API used to update package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_publication(account_slug, slug, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param UpdatePublication body: request data used to update package. (required)
        :param str sessionkey: value used to manage user session.
        :param str commit: passing '0' will just validated not update the publication while '1' will update the data too.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_publication_with_http_info(account_slug, slug, body, **kwargs)
        else:
            (data) = self.update_publication_with_http_info(account_slug, slug, body, **kwargs)
            return data

    def update_publication_with_http_info(self, account_slug, slug, body, **kwargs):
        """
        API used to update package publication.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_publication_with_http_info(account_slug, slug, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param UpdatePublication body: request data used to update package. (required)
        :param str sessionkey: value used to manage user session.
        :param str commit: passing '0' will just validated not update the publication while '1' will update the data too.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'body', 'sessionkey', 'commit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_publication" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `update_publication`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_publication`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_publication`")

        resource_path = '/packages/{accountSlug}/{slug}/publications/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'commit' in params:
            query_params['commit'] = params['commit']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_rating(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update rating of package.
        API for user to update rating score.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_rating(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddRating body: request data used to update rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_rating_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.update_rating_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def update_rating_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Update rating of package.
        API for user to update rating score.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_rating_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddRating body: request data used to update rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_rating" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `update_rating`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_rating`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `update_rating`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_rating`")

        resource_path = '/packages/{accountSlug}/{slug}/ratingdetails/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def upload_media(self, account_slug, slug, sessionkey, hash_value, **kwargs):
        """
        Upload a media file to package's draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_media(account_slug, slug, sessionkey, hash_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str hash_value:  (required)
        :param str name: 
        :param str token: 
        :param file image: media file
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upload_media_with_http_info(account_slug, slug, sessionkey, hash_value, **kwargs)
        else:
            (data) = self.upload_media_with_http_info(account_slug, slug, sessionkey, hash_value, **kwargs)
            return data

    def upload_media_with_http_info(self, account_slug, slug, sessionkey, hash_value, **kwargs):
        """
        Upload a media file to package's draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_media_with_http_info(account_slug, slug, sessionkey, hash_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str hash_value:  (required)
        :param str name: 
        :param str token: 
        :param file image: media file
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'hash_value', 'name', 'token', 'image']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_media" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `upload_media`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `upload_media`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `upload_media`")
        # verify the required parameter 'hash_value' is set
        if ('hash_value' not in params) or (params['hash_value'] is None):
            raise ValueError("Missing the required parameter `hash_value` when calling `upload_media`")

        resource_path = '/packages/{accountSlug}/{slug}/media/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}
        if 'hash_value' in params:
            form_params.append(('hash_value', params['hash_value']))
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'token' in params:
            form_params.append(('token', params['token']))
        if 'image' in params:
            local_var_files['image'] = params['image']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def validate_publication(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Validate publication object 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_publication(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Body1 body: request data used to add package rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.validate_publication_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
        else:
            (data) = self.validate_publication_with_http_info(account_slug, slug, sessionkey, body, **kwargs)
            return data

    def validate_publication_with_http_info(self, account_slug, slug, sessionkey, body, **kwargs):
        """
        Validate publication object 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_publication_with_http_info(account_slug, slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_slug: slug of account (required)
        :param str slug: slug of package to return. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param Body1 body: request data used to add package rating. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_slug', 'slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_publication" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `validate_publication`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `validate_publication`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `validate_publication`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validate_publication`")

        resource_path = '/packages/{accountSlug}/{slug}/publicationvalidations/'.replace('{format}', 'json')
        path_params = {}
        if 'account_slug' in params:
            path_params['accountSlug'] = params['account_slug']
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
