# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AccountsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_account_admin(self, slug, sessionkey, body, **kwargs):
        """
        Add a admin user into account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_account_admin(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddAdmin body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_account_admin_with_http_info(slug, sessionkey, body, **kwargs)
        else:
            (data) = self.add_account_admin_with_http_info(slug, sessionkey, body, **kwargs)
            return data

    def add_account_admin_with_http_info(self, slug, sessionkey, body, **kwargs):
        """
        Add a admin user into account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_account_admin_with_http_info(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddAdmin body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_account_admin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `add_account_admin`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `add_account_admin`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_account_admin`")

        resource_path = '/accounts/{slug}/admins/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def add_account_user(self, slug, sessionkey, body, **kwargs):
        """
        Add a regular user into account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_account_user(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddAdmin body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_account_user_with_http_info(slug, sessionkey, body, **kwargs)
        else:
            (data) = self.add_account_user_with_http_info(slug, sessionkey, body, **kwargs)
            return data

    def add_account_user_with_http_info(self, slug, sessionkey, body, **kwargs):
        """
        Add a regular user into account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_account_user_with_http_info(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param AddAdmin body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_account_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `add_account_user`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `add_account_user`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_account_user`")

        resource_path = '/accounts/{slug}/users/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def change_account_user_privilege(self, slug, user_slug, sessionkey, body, **kwargs):
        """
        account Regular user.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.change_account_user_privilege(slug, user_slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str user_slug: user account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ChangePrivilege body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.change_account_user_privilege_with_http_info(slug, user_slug, sessionkey, body, **kwargs)
        else:
            (data) = self.change_account_user_privilege_with_http_info(slug, user_slug, sessionkey, body, **kwargs)
            return data

    def change_account_user_privilege_with_http_info(self, slug, user_slug, sessionkey, body, **kwargs):
        """
        account Regular user.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.change_account_user_privilege_with_http_info(slug, user_slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str user_slug: user account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ChangePrivilege body: the content of the request used to add admin into account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'user_slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_account_user_privilege" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `change_account_user_privilege`")
        # verify the required parameter 'user_slug' is set
        if ('user_slug' not in params) or (params['user_slug'] is None):
            raise ValueError("Missing the required parameter `user_slug` when calling `change_account_user_privilege`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `change_account_user_privilege`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_account_user_privilege`")

        resource_path = '/accounts/{slug}/users/{user_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'user_slug' in params:
            path_params['user_slug'] = params['user_slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_account(self, body, **kwargs):
        """
        Create a new user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_account(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAccount body: the content of the request used to create user account. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_account_with_http_info(body, **kwargs)
        else:
            (data) = self.create_account_with_http_info(body, **kwargs)
            return data

    def create_account_with_http_info(self, body, **kwargs):
        """
        Create a new user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_account_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateAccount body: the content of the request used to create user account. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_account`")

        resource_path = '/accounts/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_admin(self, slug, admin_slug, sessionkey, **kwargs):
        """
        Get account Admin.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_admin(slug, admin_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str admin_slug: admin account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_admin_with_http_info(slug, admin_slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_admin_with_http_info(slug, admin_slug, sessionkey, **kwargs)
            return data

    def get_account_admin_with_http_info(self, slug, admin_slug, sessionkey, **kwargs):
        """
        Get account Admin.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_admin_with_http_info(slug, admin_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str admin_slug: admin account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'admin_slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_admin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_admin`")
        # verify the required parameter 'admin_slug' is set
        if ('admin_slug' not in params) or (params['admin_slug'] is None):
            raise ValueError("Missing the required parameter `admin_slug` when calling `get_account_admin`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_admin`")

        resource_path = '/accounts/{slug}/admins/{admin_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'admin_slug' in params:
            path_params['admin_slug'] = params['admin_slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_admins(self, slug, sessionkey, **kwargs):
        """
        get admin users of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_admins(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_admins_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_admins_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_account_admins_with_http_info(self, slug, sessionkey, **kwargs):
        """
        get admin users of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_admins_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_admins" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_admins`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_admins`")

        resource_path = '/accounts/{slug}/admins/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Users',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_details(self, slug, sessionkey, **kwargs):
        """
        Detail View of user account.
        user should be logged in to see detail view of account.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_details(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: account session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_details_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_details_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_account_details_with_http_info(self, slug, sessionkey, **kwargs):
        """
        Detail View of user account.
        user should be logged in to see detail view of account.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_details_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: account session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_details`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_details`")

        resource_path = '/accounts/{slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_invites_pending_list(self, slug, sessionkey, **kwargs):
        """
        To get the List of all accounts who invite the user and request is pending to accept or reject.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_invites_pending_list(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: AccountInvitesPendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_invites_pending_list_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_invites_pending_list_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_account_invites_pending_list_with_http_info(self, slug, sessionkey, **kwargs):
        """
        To get the List of all accounts who invite the user and request is pending to accept or reject.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_invites_pending_list_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: AccountInvitesPendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_invites_pending_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_invites_pending_list`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_invites_pending_list`")

        resource_path = '/accounts/{slug}/accountpendings/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AccountInvitesPendingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_list(self, sessionkey, slug, **kwargs):
        """
        Returns all accounts from the system that the user has access to.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_list(sessionkey, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: value used to manage user session. (required)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Accounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_list_with_http_info(sessionkey, slug, **kwargs)
        else:
            (data) = self.get_account_list_with_http_info(sessionkey, slug, **kwargs)
            return data

    def get_account_list_with_http_info(self, sessionkey, slug, **kwargs):
        """
        Returns all accounts from the system that the user has access to.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_list_with_http_info(sessionkey, slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: value used to manage user session. (required)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Accounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sessionkey', 'slug', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_list`")
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_list`")

        resource_path = '/accounts/{slug}/accounts/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Accounts',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_user(self, slug, user_slug, sessionkey, **kwargs):
        """
        account Regular user.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_user(slug, user_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str user_slug: user account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_user_with_http_info(slug, user_slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_user_with_http_info(slug, user_slug, sessionkey, **kwargs)
            return data

    def get_account_user_with_http_info(self, slug, user_slug, sessionkey, **kwargs):
        """
        account Regular user.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_user_with_http_info(slug, user_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str user_slug: user account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'user_slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_user`")
        # verify the required parameter 'user_slug' is set
        if ('user_slug' not in params) or (params['user_slug'] is None):
            raise ValueError("Missing the required parameter `user_slug` when calling `get_account_user`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_user`")

        resource_path = '/accounts/{slug}/users/{user_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'user_slug' in params:
            path_params['user_slug'] = params['user_slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_account_users(self, slug, sessionkey, **kwargs):
        """
        get Regular Users of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_users(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_account_users_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_account_users_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_account_users_with_http_info(self, slug, sessionkey, **kwargs):
        """
        get Regular Users of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_account_users_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_account_users`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_account_users`")

        resource_path = '/accounts/{slug}/users/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Users',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_current_account(self, slug, sessionkey, **kwargs):
        """
        Get current user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_current_account(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_current_account_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_current_account_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_current_account_with_http_info(self, slug, sessionkey, **kwargs):
        """
        Get current user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_current_account_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_current_account`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_current_account`")

        resource_path = '/accounts/{slug}/current/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Account',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_pending_users(self, slug, sessionkey, **kwargs):
        """
        Get list of user's account pending users.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pending_users(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: PendingUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pending_users_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.get_pending_users_with_http_info(slug, sessionkey, **kwargs)
            return data

    def get_pending_users_with_http_info(self, slug, sessionkey, **kwargs):
        """
        Get list of user's account pending users.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pending_users_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: PendingUsers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pending_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `get_pending_users`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `get_pending_users`")

        resource_path = '/accounts/{slug}/pendings/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PendingUsers',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def invite_user(self, slug, sessionkey, body, **kwargs):
        """
        Invite user to join account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invite_user(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param AddPending body: the content of the request used to add admin into user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.invite_user_with_http_info(slug, sessionkey, body, **kwargs)
        else:
            (data) = self.invite_user_with_http_info(slug, sessionkey, body, **kwargs)
            return data

    def invite_user_with_http_info(self, slug, sessionkey, body, **kwargs):
        """
        Invite user to join account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invite_user_with_http_info(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param AddPending body: the content of the request used to add admin into user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `invite_user`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `invite_user`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invite_user`")

        resource_path = '/accounts/{slug}/pendings/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def leave_account(self, slug, sessionkey, **kwargs):
        """
        Returns all accounts from the system that the user has access to.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.leave_account(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value account slug which user wants to leave. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.leave_account_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.leave_account_with_http_info(slug, sessionkey, **kwargs)
            return data

    def leave_account_with_http_info(self, slug, sessionkey, **kwargs):
        """
        Returns all accounts from the system that the user has access to.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.leave_account_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value account slug which user wants to leave. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method leave_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `leave_account`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `leave_account`")

        resource_path = '/accounts/{slug}/accounts/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def login(self, body, **kwargs):
        """
        Logs user account into the system.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.login(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Login body: The request data used to login. (required)
        :return: SessionData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.login_with_http_info(body, **kwargs)
        else:
            (data) = self.login_with_http_info(body, **kwargs)
            return data

    def login_with_http_info(self, body, **kwargs):
        """
        Logs user account into the system.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.login_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Login body: The request data used to login. (required)
        :return: SessionData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `login`")

        resource_path = '/login/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SessionData',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def logout(self, body, **kwargs):
        """
        Logs out current logged in user account session.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.logout(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Logout body: The request data used to logout. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.logout_with_http_info(body, **kwargs)
        else:
            (data) = self.logout_with_http_info(body, **kwargs)
            return data

    def logout_with_http_info(self, body, **kwargs):
        """
        Logs out current logged in user account session.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.logout_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Logout body: The request data used to logout. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method logout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `logout`")

        resource_path = '/logout/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def reject_user_invite(self, slug, sessionkey, **kwargs):
        """
        Reject User invitation of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reject_user_invite(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier from which logged in user got the invitation. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reject_user_invite_with_http_info(slug, sessionkey, **kwargs)
        else:
            (data) = self.reject_user_invite_with_http_info(slug, sessionkey, **kwargs)
            return data

    def reject_user_invite_with_http_info(self, slug, sessionkey, **kwargs):
        """
        Reject User invitation of account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reject_user_invite_with_http_info(slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier from which logged in user got the invitation. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param str verbose: parameter to provide detail view of hyperlink objects.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'verbose']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_user_invite" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `reject_user_invite`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `reject_user_invite`")

        resource_path = '/accounts/{slug}/users/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'verbose' in params:
            query_params['verbose'] = params['verbose']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_account(self, slug, account_slug, sessionkey, **kwargs):
        """
        Remove user Account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account(slug, account_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str account_slug: specific account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_account_with_http_info(slug, account_slug, sessionkey, **kwargs)
        else:
            (data) = self.remove_account_with_http_info(slug, account_slug, sessionkey, **kwargs)
            return data

    def remove_account_with_http_info(self, slug, account_slug, sessionkey, **kwargs):
        """
        Remove user Account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account_with_http_info(slug, account_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str account_slug: specific account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'account_slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_account`")
        # verify the required parameter 'account_slug' is set
        if ('account_slug' not in params) or (params['account_slug'] is None):
            raise ValueError("Missing the required parameter `account_slug` when calling `remove_account`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_account`")

        resource_path = '/accounts/{slug}/accounts/{account_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'account_slug' in params:
            path_params['account_slug'] = params['account_slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_account_admin(self, slug, admin_slug, sessionkey, **kwargs):
        """
        deletes a admin user from account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account_admin(slug, admin_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str admin_slug: admin account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_account_admin_with_http_info(slug, admin_slug, sessionkey, **kwargs)
        else:
            (data) = self.remove_account_admin_with_http_info(slug, admin_slug, sessionkey, **kwargs)
            return data

    def remove_account_admin_with_http_info(self, slug, admin_slug, sessionkey, **kwargs):
        """
        deletes a admin user from account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account_admin_with_http_info(slug, admin_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str admin_slug: admin account unique indentifier. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'admin_slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_account_admin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_account_admin`")
        # verify the required parameter 'admin_slug' is set
        if ('admin_slug' not in params) or (params['admin_slug'] is None):
            raise ValueError("Missing the required parameter `admin_slug` when calling `remove_account_admin`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_account_admin`")

        resource_path = '/accounts/{slug}/admins/{admin_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'admin_slug' in params:
            path_params['admin_slug'] = params['admin_slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_account_user(self, slug, user_slug, sessionkey, **kwargs):
        """
        Delete a regular user from account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account_user(slug, user_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier of account from which user needs to be removed. (required)
        :param str user_slug: user account unique indentifier of user which needs to be removed. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_account_user_with_http_info(slug, user_slug, sessionkey, **kwargs)
        else:
            (data) = self.remove_account_user_with_http_info(slug, user_slug, sessionkey, **kwargs)
            return data

    def remove_account_user_with_http_info(self, slug, user_slug, sessionkey, **kwargs):
        """
        Delete a regular user from account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_account_user_with_http_info(slug, user_slug, sessionkey, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier of account from which user needs to be removed. (required)
        :param str user_slug: user account unique indentifier of user which needs to be removed. (required)
        :param str sessionkey: value used to manage user session. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'user_slug', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_account_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_account_user`")
        # verify the required parameter 'user_slug' is set
        if ('user_slug' not in params) or (params['user_slug'] is None):
            raise ValueError("Missing the required parameter `user_slug` when calling `remove_account_user`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_account_user`")

        resource_path = '/accounts/{slug}/users/{user_slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']
        if 'user_slug' in params:
            path_params['user_slug'] = params['user_slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def remove_pending_invited_user(self, slug, sessionkey, body, **kwargs):
        """
        Invite user to join account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_pending_invited_user(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param RemovePending body: the content of the request used to add admin into user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_pending_invited_user_with_http_info(slug, sessionkey, body, **kwargs)
        else:
            (data) = self.remove_pending_invited_user_with_http_info(slug, sessionkey, body, **kwargs)
            return data

    def remove_pending_invited_user_with_http_info(self, slug, sessionkey, body, **kwargs):
        """
        Invite user to join account.
        This can only be done by the logged in user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_pending_invited_user_with_http_info(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: account unique indentifier. (required)
        :param str sessionkey: user session. (required)
        :param RemovePending body: the content of the request used to add admin into user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_pending_invited_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `remove_pending_invited_user`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `remove_pending_invited_user`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_pending_invited_user`")

        resource_path = '/accounts/{slug}/pendings/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def resend_account_verification_email(self, sessionkey, body, **kwargs):
        """
        Resend Email Verification link to verifiy account if already not verified.
        user should be logged in to resend the verification link.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.resend_account_verification_email(sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: account session. (required)
        :param ResendAccountVerificationLink body: request data used to resend link to user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.resend_account_verification_email_with_http_info(sessionkey, body, **kwargs)
        else:
            (data) = self.resend_account_verification_email_with_http_info(sessionkey, body, **kwargs)
            return data

    def resend_account_verification_email_with_http_info(self, sessionkey, body, **kwargs):
        """
        Resend Email Verification link to verifiy account if already not verified.
        user should be logged in to resend the verification link.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.resend_account_verification_email_with_http_info(sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: account session. (required)
        :param ResendAccountVerificationLink body: request data used to resend link to user account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_account_verification_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `resend_account_verification_email`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `resend_account_verification_email`")

        resource_path = '/accounts/resend/emailverification/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def reset_password(self, body, **kwargs):
        """
        Reset password of user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_password(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ResetPassword body: The request data used to reset user account password. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reset_password_with_http_info(body, **kwargs)
        else:
            (data) = self.reset_password_with_http_info(body, **kwargs)
            return data

    def reset_password_with_http_info(self, body, **kwargs):
        """
        Reset password of user account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_password_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ResetPassword body: The request data used to reset user account password. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_password" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reset_password`")

        resource_path = '/reset/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def search_accounts(self, sessionkey, pattern, **kwargs):
        """
        Search accounts by starting keywords of account name .
        user should be logged in to search accounts.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_accounts(sessionkey, pattern, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: account session. (required)
        :param str pattern: parameter to provide search accounts with passed starting keywords. (required)
        :param int account: Needs to send 1 if you want matching accounts list. Default will be 0.
        :param int organization: organization=1 for organization only, organization=0 for ~organization. Default will include all
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_accounts_with_http_info(sessionkey, pattern, **kwargs)
        else:
            (data) = self.search_accounts_with_http_info(sessionkey, pattern, **kwargs)
            return data

    def search_accounts_with_http_info(self, sessionkey, pattern, **kwargs):
        """
        Search accounts by starting keywords of account name .
        user should be logged in to search accounts.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_accounts_with_http_info(sessionkey, pattern, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sessionkey: account session. (required)
        :param str pattern: parameter to provide search accounts with passed starting keywords. (required)
        :param int account: Needs to send 1 if you want matching accounts list. Default will be 0.
        :param int organization: organization=1 for organization only, organization=0 for ~organization. Default will include all
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sessionkey', 'pattern', 'account', 'organization']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `search_accounts`")
        # verify the required parameter 'pattern' is set
        if ('pattern' not in params) or (params['pattern'] is None):
            raise ValueError("Missing the required parameter `pattern` when calling `search_accounts`")

        resource_path = '/accounts/search/{pattern}/'.replace('{format}', 'json')
        path_params = {}
        if 'pattern' in params:
            path_params['pattern'] = params['pattern']

        query_params = {}
        if 'account' in params:
            query_params['account'] = params['account']
        if 'organization' in params:
            query_params['organization'] = params['organization']

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Users',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def set_current_account(self, slug, sessionkey, body, **kwargs):
        """
        Set user current account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_current_account(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ChangeCurrentAccount body: request data used to change current account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.set_current_account_with_http_info(slug, sessionkey, body, **kwargs)
        else:
            (data) = self.set_current_account_with_http_info(slug, sessionkey, body, **kwargs)
            return data

    def set_current_account_with_http_info(self, slug, sessionkey, body, **kwargs):
        """
        Set user current account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_current_account_with_http_info(slug, sessionkey, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param str sessionkey: value used to manage user session. (required)
        :param ChangeCurrentAccount body: request data used to change current account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'sessionkey', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_current_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `set_current_account`")
        # verify the required parameter 'sessionkey' is set
        if ('sessionkey' not in params) or (params['sessionkey'] is None):
            raise ValueError("Missing the required parameter `sessionkey` when calling `set_current_account`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_current_account`")

        resource_path = '/accounts/{slug}/current/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_account(self, slug, body, **kwargs):
        """
        Update User Account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_account(slug, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param UpdateAccount body: request data used to update user account. (required)
        :param str sessionkey: user session.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_account_with_http_info(slug, body, **kwargs)
        else:
            (data) = self.update_account_with_http_info(slug, body, **kwargs)
            return data

    def update_account_with_http_info(self, slug, body, **kwargs):
        """
        Update User Account.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_account_with_http_info(slug, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: unique value which will be used to fetch user account details. (required)
        :param UpdateAccount body: request data used to update user account. (required)
        :param str sessionkey: user session.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'body', 'sessionkey']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_account`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_account`")

        resource_path = '/accounts/{slug}/'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}

        header_params = {}
        if 'sessionkey' in params:
            header_params['sessionkey'] = params['sessionkey']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
