from os import path

import todoist
from gi.repository import Gtk

CONFIG = path.expanduser("~/.config/todoist")


class Prompt(Gtk.Dialog):
    def __init__(self, message):
        super().__init__()
        self.set_decorated(False)
        box = self.get_content_area()
        self.entry = Gtk.Entry()
        self.entry.set_text(message)

        self.entry.connect("destroy", Gtk.main_quit)

        self.entry.grab_focus()
        box.add(self.entry)


class APITokenPrompt(Prompt):
    def __init__(self, reason=""):
        super().__init__("API Token")
        self.entry.connect("activate", self.save_api)

        label = Gtk.Label()
        if reason != "":
            reason += ". "

        label.set_markup(
            "{}<a href='https://todoist.com/prefs/integrations'>Get your API token here</a>".format(
                reason
            )
        )
        box = self.get_content_area()
        box.add(label)

    def save_api(self, *args):
        with open(CONFIG, "w") as stream:
            stream.write(self.entry.get_text())
        self.destroy()


class NewTaskWindow(Prompt):
    def __init__(self):
        super().__init__("New Task")
        self.entry.connect("activate", self.create_task)

    def create_task(self, *args):
        task = self.entry.get_text()
        create_new_task(task)
        self.destroy()


def show_prompt(prompt):
    prompt.show_all()
    Gtk.main()


def create_new_task(task):
    with open(CONFIG) as stream:
        api = todoist.TodoistAPI(stream.read())
        res = api.add_item(task)

        if res.get("error_tag") == "AUTH_INVALID_TOKEN":
            show_prompt(APITokenPrompt("Invalid token"))


def add_todoist_task():
    if not path.exists(CONFIG):
        show_prompt(APITokenPrompt("Missing token"))
    show_prompt(NewTaskWindow())
