# ⏰ timenow

[![PyPI version](https://img.shields.io/pypi/v/timenow.svg)](https://pypi.org/project/timenow)
[![Python Version](https://img.shields.io/pypi/pyversions/timenow.svg)](https://www.python.org/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)

`timenow` is a lightweight and fast **command-line tool** by **Ninza Panda** that instantly shows the current date and time — right in your terminal.  
Perfect for quick time checks or as part of your scripts.

---

## 🚀 Features

- 📅 **Displays the current local date and time**
- 🌍 Optional **UTC time output**
- 💡 Zero configuration — just run the command
- 🖥 Works on **Windows, macOS, and Linux**
- ⚡ Global command after installation

---

## 📦 Installation

> **Prerequisite**: Python **3.7+** installed and `pip` available.

Install from **PyPI**:

pip install timenow


Upgrading to the latest version:

pip install –upgrade timenow


---

## 💻 Usage

Once installed, simply run:

timenow -tokyo


Example output:
╔══════════════════════════════════════════════════════════╗
║                    🌍 WORLD TIME CLI 🕐                  ║
╚══════════════════════════════════════════════════════════╝

⏳ Searching for location: tokyo...
✅ Found: 東京都, 日本
────────────────────────────────────────────────────────────
⏳ Fetching current time...

╭─────────────────────────────────────────────────────────────╮
│  📍 Location: 東京都, 日本         │
│                                                             │
│  🕐 Current Time:                                        │
│       07:16:23 PM                                 │
│                                                             │
│  🌐 Timezone: Asia/Tokyo                                   │
╰─────────────────────────────────────────────────────────────╯



---

## 📜 License

This project is licensed under the **MIT License** – see the [LICENSE](LICENSE) file for details.

MIT License
Copyright (c) 2025 Ninza Panda

---

## 👤 Author

**Ninza Panda**  
💌 Email: ninzaapanda.com  
🌐 Website: https://ninzapanda.com  

---

⭐ If you like `timenow`, consider giving it a **star** on GitHub and sharing it with your friends!

