/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting clustering.")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011A\u0003\u0013\u001aP\u00072,8\u000f^3sS:<W*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003\u001diW\r\u001e:jGNT!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003%\u0019\b/\u0019:lY&twM\u0003\u0002\n\u0015\u0005\u0019\u0001NM8\u000b\u0003-\t!!Y5\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001\u0003\u0013\u001aP\u0007>lWn\u001c8NKR\u0014\u0018nY:\t\u0011M\u0001!Q1A\u0005BQ\t1!^5e+\u0005)\u0002C\u0001\f\u001d\u001d\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011QD\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mA\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\tULG\r\t\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0011*\u0003CA\b\u0001\u0011\u0015\u0019\u0012\u00051\u0001\u0016\u0011\u0015\u0011\u0003\u0001\"\u0001()\u0005!\u0003bB\u0015\u0001\u0005\u0004%\tBK\u0001\fi>$x+\u001b;iS:\u001c8/F\u0001,!\tac'D\u0001.\u0015\tqs&A\u0003qCJ\fWN\u0003\u0002\u0006a)\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028[\tYAi\\;cY\u0016\u0004\u0016M]1n\u0011\u0019I\u0004\u0001)A\u0005W\u0005aAo\u001c;XSRD\u0017N\\:tA!91\b\u0001b\u0001\n#Q\u0013!\u0002;piN\u001c\bBB\u001f\u0001A\u0003%1&\u0001\u0004u_R\u001c8\u000f\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u0005+\u0003%\u0011W\r^<fK:\u001c8\u000f\u0003\u0004B\u0001\u0001\u0006IaK\u0001\u000bE\u0016$x/Z3ogN\u0004\u0003bB\"\u0001\u0005\u0004%\t\u0002R\u0001\u000eG\u0016tGO]8jIN#\u0018\r^:\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0003\u0002\rA\f'/Y7t\u0013\tQuI\u0001\fOk2d\u0017M\u00197f\t\u0006$\u0018M\u0012:b[\u0016\u0004\u0016M]1n\u0011\u0019a\u0005\u0001)A\u0005\u000b\u0006q1-\u001a8ue>LGm\u0015;biN\u0004\u0003\"\u0002(\u0001\t\u0003y\u0015AD4fiR{GoV5uQ&t7o\u001d\u000b\u0002!B\u0011q#U\u0005\u0003%b\u0011a\u0001R8vE2,\u0007\"\u0002+\u0001\t\u0003y\u0015\u0001C4fiR{Go]:\t\u000bY\u0003A\u0011A(\u0002\u0019\u001d,GOQ3uo\u0016,gn]:\t\u000ba\u0003A\u0011A-\u0002!\u001d,GoQ3oiJ|\u0017\u000eZ*uCR\u001cH#\u0001.\u0011\u0005m[gB\u0001/i\u001d\tifM\u0004\u0002_K:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003E2\ta\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005M\"\u0014BA\u00193\u0013\t9\u0007'A\u0002tc2L!!\u001b6\u0002\u000fA\f7m[1hK*\u0011q\rM\u0005\u0003Y6\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005%T\u0007\"B8\u0001\t\u0003\u0002\u0018AC:fi6+GO]5dgR!\u0011\u000f^A\u0001!\t9\"/\u0003\u0002t1\t!QK\\5u\u0011\u0015)h\u000e1\u0001w\u0003\u0011Q7o\u001c8\u0011\u0005]tX\"\u0001=\u000b\u0005eT\u0018\u0001B4t_:T!a\u001f?\u0002\r\u001d|wn\u001a7f\u0015\u0005i\u0018aA2p[&\u0011q\u0010\u001f\u0002\u000b\u0015N|gn\u00142kK\u000e$\bBBA\u0002]\u0002\u0007Q#A\u0004d_:$X\r\u001f;\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005!1m\u001c9z)\u0011\tY!!\u0004\u000e\u0003\u0001A\u0001\"a\u0004\u0002\u0006\u0001\u0007\u0011\u0011C\u0001\u0006Kb$(/\u0019\t\u0004Y\u0005M\u0011bAA\u000b[\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0004\u0001\u00033\ty\"!\t\u0011\u0007=\tY\"C\u0002\u0002\u001e\t\u0011!#T3ue&\u001c7\u000fR3tGJL\u0007\u000f^5p]\u0006YA-Z:de&\u0004H/[8oC\t\t\u0019#\u00010UQ\u0016\u00043\r\\1tg\u0002j\u0017m[3tA\u00054\u0018-\u001b7bE2,\u0007%\u00197mA5,GO]5dg\u0002\"\b.\u0019;!g\"\f'/\u001a3!C\u000e\u0014xn]:!C2d\u0007%\u00197h_JLG\u000f[7tAM,\b\u000f]8si&tw\rI2mkN$XM]5oO:\u0002")
public class H2OClusteringMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam totWithinss;
    private final DoubleParam totss;
    private final DoubleParam betweenss;
    private final NullableDataFrameParam centroidStats;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam totWithinss() {
        return this.totWithinss;
    }

    public DoubleParam totss() {
        return this.totss;
    }

    public DoubleParam betweenss() {
        return this.betweenss;
    }

    public NullableDataFrameParam centroidStats() {
        return this.centroidStats;
    }

    public double getTotWithinss() {
        return BoxesRunTime.unboxToDouble(this.$(this.totWithinss()));
    }

    public double getTotss() {
        return BoxesRunTime.unboxToDouble(this.$(this.totss()));
    }

    public double getBetweenss() {
        return BoxesRunTime.unboxToDouble(this.$(this.betweenss()));
    }

    public Dataset<Row> getCentroidStats() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.centroidStats()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        super.setMetrics(json, context);
        if (json.has("tot_withinss")) {
            try {
                params3 = this.set("totWithinss", BoxesRunTime.boxToDouble((double)json.get("tot_withinss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'tot_withinss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'tot_withinss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("totss")) {
            try {
                params2 = this.set("totss", BoxesRunTime.boxToDouble((double)json.get("totss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'totss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'totss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("betweenss")) {
            try {
                params = this.set("betweenss", BoxesRunTime.boxToDouble((double)json.get("betweenss").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'betweenss' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'betweenss' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("centroid_stats")) {
            try {
                this.set("centroidStats", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "centroid_stats")));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'centroid_stats' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'centroid_stats' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            return;
        }
    }

    @Override
    public H2OClusteringMetrics copy(ParamMap extra) {
        return (H2OClusteringMetrics)this.defaultCopy(extra);
    }

    public H2OClusteringMetrics(String uid) {
        this.uid = uid;
        this.totWithinss = this.doubleParam("totWithinss", "Within Cluster Sum of Square Error.");
        this.totss = this.doubleParam("totss", "Total Sum of Square Error to Grand Mean.");
        this.betweenss = this.doubleParam("betweenss", "Between Cluster Sum of Square Error.");
        this.centroidStats = this.nullableDataFrameParam("centroidStats", "Centroid Statistics.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.totWithinss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.totss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.betweenss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.centroidStats().$minus$greater(null)}));
    }

    public H2OClusteringMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OClusteringMetrics"));
    }
}

