# coding: utf-8

"""
    Mock Server API

    MockServer enables easy mocking of any system you integrate with via HTTP or HTTPS with clients written in Java, JavaScript and Ruby and a simple REST API (as shown below).  MockServer Proxy is a proxy that introspects all proxied traffic including encrypted SSL traffic and supports Port Forwarding, Web Proxying (i.e. HTTP proxy), HTTPS Tunneling Proxying (using HTTP CONNECT) and SOCKS Proxying (i.e. dynamic port forwarding).  Both MockServer and the MockServer Proxy record all received requests so that it is possible to verify exactly what requests have been sent by the system under test.  # noqa: E501

    OpenAPI spec version: 5.3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class HttpResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'body': 'BodyWithContentType',
        'delay': 'Delay',
        'cookies': 'KeyToValue',
        'connection_options': 'ConnectionOptions',
        'headers': 'KeyToMultiValue',
        'status_code': 'int',
        'reason_phrase': 'str'
    }

    attribute_map = {
        'body': 'body',
        'delay': 'delay',
        'cookies': 'cookies',
        'connection_options': 'connectionOptions',
        'headers': 'headers',
        'status_code': 'statusCode',
        'reason_phrase': 'reasonPhrase'
    }

    def __init__(self, body=None, delay=None, cookies=None, connection_options=None, headers=None, status_code=None, reason_phrase=None):  # noqa: E501
        """HttpResponse - a model defined in OpenAPI"""  # noqa: E501

        self._body = None
        self._delay = None
        self._cookies = None
        self._connection_options = None
        self._headers = None
        self._status_code = None
        self._reason_phrase = None
        self.discriminator = None

        if body is not None:
            self.body = body
        if delay is not None:
            self.delay = delay
        if cookies is not None:
            self.cookies = cookies
        if connection_options is not None:
            self.connection_options = connection_options
        if headers is not None:
            self.headers = headers
        if status_code is not None:
            self.status_code = status_code
        if reason_phrase is not None:
            self.reason_phrase = reason_phrase

    @property
    def body(self):
        """Gets the body of this HttpResponse.  # noqa: E501


        :return: The body of this HttpResponse.  # noqa: E501
        :rtype: BodyWithContentType
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this HttpResponse.


        :param body: The body of this HttpResponse.  # noqa: E501
        :type: BodyWithContentType
        """

        self._body = body

    @property
    def delay(self):
        """Gets the delay of this HttpResponse.  # noqa: E501


        :return: The delay of this HttpResponse.  # noqa: E501
        :rtype: Delay
        """
        return self._delay

    @delay.setter
    def delay(self, delay):
        """Sets the delay of this HttpResponse.


        :param delay: The delay of this HttpResponse.  # noqa: E501
        :type: Delay
        """

        self._delay = delay

    @property
    def cookies(self):
        """Gets the cookies of this HttpResponse.  # noqa: E501


        :return: The cookies of this HttpResponse.  # noqa: E501
        :rtype: KeyToValue
        """
        return self._cookies

    @cookies.setter
    def cookies(self, cookies):
        """Sets the cookies of this HttpResponse.


        :param cookies: The cookies of this HttpResponse.  # noqa: E501
        :type: KeyToValue
        """

        self._cookies = cookies

    @property
    def connection_options(self):
        """Gets the connection_options of this HttpResponse.  # noqa: E501


        :return: The connection_options of this HttpResponse.  # noqa: E501
        :rtype: ConnectionOptions
        """
        return self._connection_options

    @connection_options.setter
    def connection_options(self, connection_options):
        """Sets the connection_options of this HttpResponse.


        :param connection_options: The connection_options of this HttpResponse.  # noqa: E501
        :type: ConnectionOptions
        """

        self._connection_options = connection_options

    @property
    def headers(self):
        """Gets the headers of this HttpResponse.  # noqa: E501


        :return: The headers of this HttpResponse.  # noqa: E501
        :rtype: KeyToMultiValue
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """Sets the headers of this HttpResponse.


        :param headers: The headers of this HttpResponse.  # noqa: E501
        :type: KeyToMultiValue
        """

        self._headers = headers

    @property
    def status_code(self):
        """Gets the status_code of this HttpResponse.  # noqa: E501


        :return: The status_code of this HttpResponse.  # noqa: E501
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this HttpResponse.


        :param status_code: The status_code of this HttpResponse.  # noqa: E501
        :type: int
        """

        self._status_code = status_code

    @property
    def reason_phrase(self):
        """Gets the reason_phrase of this HttpResponse.  # noqa: E501


        :return: The reason_phrase of this HttpResponse.  # noqa: E501
        :rtype: str
        """
        return self._reason_phrase

    @reason_phrase.setter
    def reason_phrase(self, reason_phrase):
        """Sets the reason_phrase of this HttpResponse.


        :param reason_phrase: The reason_phrase of this HttpResponse.  # noqa: E501
        :type: str
        """

        self._reason_phrase = reason_phrase

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HttpResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
