# coding: utf-8

"""
    Mock Server API

    MockServer enables easy mocking of any system you integrate with via HTTP or HTTPS with clients written in Java, JavaScript and Ruby and a simple REST API (as shown below).  MockServer Proxy is a proxy that introspects all proxied traffic including encrypted SSL traffic and supports Port Forwarding, Web Proxying (i.e. HTTP proxy), HTTPS Tunneling Proxying (using HTTP CONNECT) and SOCKS Proxying (i.e. dynamic port forwarding).  Both MockServer and the MockServer Proxy record all received requests so that it is possible to verify exactly what requests have been sent by the system under test.  # noqa: E501

    OpenAPI spec version: 5.3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class HttpRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'body': 'Body',
        'headers': 'KeyToMultiValue',
        'cookies': 'KeyToValue',
        'query_string_parameters': 'KeyToMultiValue',
        'path': 'str',
        'method': 'str',
        'secure': 'bool',
        'keep_alive': 'bool'
    }

    attribute_map = {
        'body': 'body',
        'headers': 'headers',
        'cookies': 'cookies',
        'query_string_parameters': 'queryStringParameters',
        'path': 'path',
        'method': 'method',
        'secure': 'secure',
        'keep_alive': 'keepAlive'
    }

    def __init__(self, body=None, headers=None, cookies=None, query_string_parameters=None, path=None, method=None, secure=None, keep_alive=None):  # noqa: E501
        """HttpRequest - a model defined in OpenAPI"""  # noqa: E501

        self._body = None
        self._headers = None
        self._cookies = None
        self._query_string_parameters = None
        self._path = None
        self._method = None
        self._secure = None
        self._keep_alive = None
        self.discriminator = None

        if body is not None:
            self.body = body
        if headers is not None:
            self.headers = headers
        if cookies is not None:
            self.cookies = cookies
        if query_string_parameters is not None:
            self.query_string_parameters = query_string_parameters
        if path is not None:
            self.path = path
        if method is not None:
            self.method = method
        if secure is not None:
            self.secure = secure
        if keep_alive is not None:
            self.keep_alive = keep_alive

    @property
    def body(self):
        """Gets the body of this HttpRequest.  # noqa: E501


        :return: The body of this HttpRequest.  # noqa: E501
        :rtype: Body
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this HttpRequest.


        :param body: The body of this HttpRequest.  # noqa: E501
        :type: Body
        """

        self._body = body

    @property
    def headers(self):
        """Gets the headers of this HttpRequest.  # noqa: E501


        :return: The headers of this HttpRequest.  # noqa: E501
        :rtype: KeyToMultiValue
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """Sets the headers of this HttpRequest.


        :param headers: The headers of this HttpRequest.  # noqa: E501
        :type: KeyToMultiValue
        """

        self._headers = headers

    @property
    def cookies(self):
        """Gets the cookies of this HttpRequest.  # noqa: E501


        :return: The cookies of this HttpRequest.  # noqa: E501
        :rtype: KeyToValue
        """
        return self._cookies

    @cookies.setter
    def cookies(self, cookies):
        """Sets the cookies of this HttpRequest.


        :param cookies: The cookies of this HttpRequest.  # noqa: E501
        :type: KeyToValue
        """

        self._cookies = cookies

    @property
    def query_string_parameters(self):
        """Gets the query_string_parameters of this HttpRequest.  # noqa: E501


        :return: The query_string_parameters of this HttpRequest.  # noqa: E501
        :rtype: KeyToMultiValue
        """
        return self._query_string_parameters

    @query_string_parameters.setter
    def query_string_parameters(self, query_string_parameters):
        """Sets the query_string_parameters of this HttpRequest.


        :param query_string_parameters: The query_string_parameters of this HttpRequest.  # noqa: E501
        :type: KeyToMultiValue
        """

        self._query_string_parameters = query_string_parameters

    @property
    def path(self):
        """Gets the path of this HttpRequest.  # noqa: E501


        :return: The path of this HttpRequest.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this HttpRequest.


        :param path: The path of this HttpRequest.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def method(self):
        """Gets the method of this HttpRequest.  # noqa: E501


        :return: The method of this HttpRequest.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this HttpRequest.


        :param method: The method of this HttpRequest.  # noqa: E501
        :type: str
        """

        self._method = method

    @property
    def secure(self):
        """Gets the secure of this HttpRequest.  # noqa: E501


        :return: The secure of this HttpRequest.  # noqa: E501
        :rtype: bool
        """
        return self._secure

    @secure.setter
    def secure(self, secure):
        """Sets the secure of this HttpRequest.


        :param secure: The secure of this HttpRequest.  # noqa: E501
        :type: bool
        """

        self._secure = secure

    @property
    def keep_alive(self):
        """Gets the keep_alive of this HttpRequest.  # noqa: E501


        :return: The keep_alive of this HttpRequest.  # noqa: E501
        :rtype: bool
        """
        return self._keep_alive

    @keep_alive.setter
    def keep_alive(self, keep_alive):
        """Sets the keep_alive of this HttpRequest.


        :param keep_alive: The keep_alive of this HttpRequest.  # noqa: E501
        :type: bool
        """

        self._keep_alive = keep_alive

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HttpRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
