# coding: utf-8

"""
    Mock Server API

    MockServer enables easy mocking of any system you integrate with via HTTP or HTTPS with clients written in Java, JavaScript and Ruby and a simple REST API (as shown below).  MockServer Proxy is a proxy that introspects all proxied traffic including encrypted SSL traffic and supports Port Forwarding, Web Proxying (i.e. HTTP proxy), HTTPS Tunneling Proxying (using HTTP CONNECT) and SOCKS Proxying (i.e. dynamic port forwarding).  Both MockServer and the MockServer Proxy record all received requests so that it is possible to verify exactly what requests have been sent by the system under test.  # noqa: E501

    OpenAPI spec version: 5.3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class HttpError(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'delay': 'Delay',
        'drop_connection': 'bool',
        'response_bytes': 'str'
    }

    attribute_map = {
        'delay': 'delay',
        'drop_connection': 'dropConnection',
        'response_bytes': 'responseBytes'
    }

    def __init__(self, delay=None, drop_connection=None, response_bytes=None):  # noqa: E501
        """HttpError - a model defined in OpenAPI"""  # noqa: E501

        self._delay = None
        self._drop_connection = None
        self._response_bytes = None
        self.discriminator = None

        if delay is not None:
            self.delay = delay
        if drop_connection is not None:
            self.drop_connection = drop_connection
        if response_bytes is not None:
            self.response_bytes = response_bytes

    @property
    def delay(self):
        """Gets the delay of this HttpError.  # noqa: E501


        :return: The delay of this HttpError.  # noqa: E501
        :rtype: Delay
        """
        return self._delay

    @delay.setter
    def delay(self, delay):
        """Sets the delay of this HttpError.


        :param delay: The delay of this HttpError.  # noqa: E501
        :type: Delay
        """

        self._delay = delay

    @property
    def drop_connection(self):
        """Gets the drop_connection of this HttpError.  # noqa: E501


        :return: The drop_connection of this HttpError.  # noqa: E501
        :rtype: bool
        """
        return self._drop_connection

    @drop_connection.setter
    def drop_connection(self, drop_connection):
        """Sets the drop_connection of this HttpError.


        :param drop_connection: The drop_connection of this HttpError.  # noqa: E501
        :type: bool
        """

        self._drop_connection = drop_connection

    @property
    def response_bytes(self):
        """Gets the response_bytes of this HttpError.  # noqa: E501


        :return: The response_bytes of this HttpError.  # noqa: E501
        :rtype: str
        """
        return self._response_bytes

    @response_bytes.setter
    def response_bytes(self, response_bytes):
        """Sets the response_bytes of this HttpError.


        :param response_bytes: The response_bytes of this HttpError.  # noqa: E501
        :type: str
        """

        self._response_bytes = response_bytes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HttpError):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
