# coding: utf-8

"""
    Mock Server API

    MockServer enables easy mocking of any system you integrate with via HTTP or HTTPS with clients written in Java, JavaScript and Ruby and a simple REST API (as shown below).  MockServer Proxy is a proxy that introspects all proxied traffic including encrypted SSL traffic and supports Port Forwarding, Web Proxying (i.e. HTTP proxy), HTTPS Tunneling Proxying (using HTTP CONNECT) and SOCKS Proxying (i.e. dynamic port forwarding).  Both MockServer and the MockServer Proxy record all received requests so that it is possible to verify exactly what requests have been sent by the system under test.  # noqa: E501

    OpenAPI spec version: 5.3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ConnectionOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'close_socket': 'bool',
        'content_length_header_override': 'int',
        'suppress_content_length_header': 'bool',
        'suppress_connection_header': 'bool',
        'keep_alive_override': 'bool'
    }

    attribute_map = {
        'close_socket': 'closeSocket',
        'content_length_header_override': 'contentLengthHeaderOverride',
        'suppress_content_length_header': 'suppressContentLengthHeader',
        'suppress_connection_header': 'suppressConnectionHeader',
        'keep_alive_override': 'keepAliveOverride'
    }

    def __init__(self, close_socket=None, content_length_header_override=None, suppress_content_length_header=None, suppress_connection_header=None, keep_alive_override=None):  # noqa: E501
        """ConnectionOptions - a model defined in OpenAPI"""  # noqa: E501

        self._close_socket = None
        self._content_length_header_override = None
        self._suppress_content_length_header = None
        self._suppress_connection_header = None
        self._keep_alive_override = None
        self.discriminator = None

        if close_socket is not None:
            self.close_socket = close_socket
        if content_length_header_override is not None:
            self.content_length_header_override = content_length_header_override
        if suppress_content_length_header is not None:
            self.suppress_content_length_header = suppress_content_length_header
        if suppress_connection_header is not None:
            self.suppress_connection_header = suppress_connection_header
        if keep_alive_override is not None:
            self.keep_alive_override = keep_alive_override

    @property
    def close_socket(self):
        """Gets the close_socket of this ConnectionOptions.  # noqa: E501


        :return: The close_socket of this ConnectionOptions.  # noqa: E501
        :rtype: bool
        """
        return self._close_socket

    @close_socket.setter
    def close_socket(self, close_socket):
        """Sets the close_socket of this ConnectionOptions.


        :param close_socket: The close_socket of this ConnectionOptions.  # noqa: E501
        :type: bool
        """

        self._close_socket = close_socket

    @property
    def content_length_header_override(self):
        """Gets the content_length_header_override of this ConnectionOptions.  # noqa: E501


        :return: The content_length_header_override of this ConnectionOptions.  # noqa: E501
        :rtype: int
        """
        return self._content_length_header_override

    @content_length_header_override.setter
    def content_length_header_override(self, content_length_header_override):
        """Sets the content_length_header_override of this ConnectionOptions.


        :param content_length_header_override: The content_length_header_override of this ConnectionOptions.  # noqa: E501
        :type: int
        """

        self._content_length_header_override = content_length_header_override

    @property
    def suppress_content_length_header(self):
        """Gets the suppress_content_length_header of this ConnectionOptions.  # noqa: E501


        :return: The suppress_content_length_header of this ConnectionOptions.  # noqa: E501
        :rtype: bool
        """
        return self._suppress_content_length_header

    @suppress_content_length_header.setter
    def suppress_content_length_header(self, suppress_content_length_header):
        """Sets the suppress_content_length_header of this ConnectionOptions.


        :param suppress_content_length_header: The suppress_content_length_header of this ConnectionOptions.  # noqa: E501
        :type: bool
        """

        self._suppress_content_length_header = suppress_content_length_header

    @property
    def suppress_connection_header(self):
        """Gets the suppress_connection_header of this ConnectionOptions.  # noqa: E501


        :return: The suppress_connection_header of this ConnectionOptions.  # noqa: E501
        :rtype: bool
        """
        return self._suppress_connection_header

    @suppress_connection_header.setter
    def suppress_connection_header(self, suppress_connection_header):
        """Sets the suppress_connection_header of this ConnectionOptions.


        :param suppress_connection_header: The suppress_connection_header of this ConnectionOptions.  # noqa: E501
        :type: bool
        """

        self._suppress_connection_header = suppress_connection_header

    @property
    def keep_alive_override(self):
        """Gets the keep_alive_override of this ConnectionOptions.  # noqa: E501


        :return: The keep_alive_override of this ConnectionOptions.  # noqa: E501
        :rtype: bool
        """
        return self._keep_alive_override

    @keep_alive_override.setter
    def keep_alive_override(self, keep_alive_override):
        """Sets the keep_alive_override of this ConnectionOptions.


        :param keep_alive_override: The keep_alive_override of this ConnectionOptions.  # noqa: E501
        :type: bool
        """

        self._keep_alive_override = keep_alive_override

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConnectionOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
