# mockserver-client
MockServer enables easy mocking of any system you integrate with via HTTP or HTTPS with clients written in Java, JavaScript and Ruby and a simple REST API (as shown below).  MockServer Proxy is a proxy that introspects all proxied traffic including encrypted SSL traffic and supports Port Forwarding, Web Proxying (i.e. HTTP proxy), HTTPS Tunneling Proxying (using HTTP CONNECT) and SOCKS Proxying (i.e. dynamic port forwarding).  Both MockServer and the MockServer Proxy record all received requests so that it is possible to verify exactly what requests have been sent by the system under test.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 5.3.0
- Package version: 5.3.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import mockserver 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mockserver
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import mockserver
from mockserver.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = mockserver.ControlApi(mockserver.ApiClient(configuration))
ports = mockserver.Ports() # Ports | list of ports to bind to, where 0 indicates dynamically bind to any available port

try:
    # bind additional listening ports
    api_response = api_instance.bind_put(ports)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ControlApi->bind_put: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:1080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ControlApi* | [**bind_put**](docs/ControlApi.md#bind_put) | **PUT** /bind | bind additional listening ports
*ControlApi* | [**clear_put**](docs/ControlApi.md#clear_put) | **PUT** /clear | clears expectations and recorded requests that match the request matcher
*ControlApi* | [**reset_put**](docs/ControlApi.md#reset_put) | **PUT** /reset | clears all expectations and recorded requests
*ControlApi* | [**retrieve_put**](docs/ControlApi.md#retrieve_put) | **PUT** /retrieve | retrieve recorded requests, active expectations, recorded expectations or log messages
*ControlApi* | [**status_put**](docs/ControlApi.md#status_put) | **PUT** /status | return listening ports
*ControlApi* | [**stop_put**](docs/ControlApi.md#stop_put) | **PUT** /stop | stop running process
*ExpectationApi* | [**expectation_put**](docs/ExpectationApi.md#expectation_put) | **PUT** /expectation | create expectation
*VerifyApi* | [**verify_put**](docs/VerifyApi.md#verify_put) | **PUT** /verify | verify a request has been received a specific number of times
*VerifyApi* | [**verify_sequence_put**](docs/VerifyApi.md#verify_sequence_put) | **PUT** /verifySequence | verify a sequence of request has been received in the specific order


## Documentation For Models

 - [Body](docs/Body.md)
 - [BodyWithContentType](docs/BodyWithContentType.md)
 - [ConnectionOptions](docs/ConnectionOptions.md)
 - [Delay](docs/Delay.md)
 - [Expectation](docs/Expectation.md)
 - [Expectations](docs/Expectations.md)
 - [HttpClassCallback](docs/HttpClassCallback.md)
 - [HttpError](docs/HttpError.md)
 - [HttpForward](docs/HttpForward.md)
 - [HttpObjectCallback](docs/HttpObjectCallback.md)
 - [HttpOverrideForwardedRequest](docs/HttpOverrideForwardedRequest.md)
 - [HttpRequest](docs/HttpRequest.md)
 - [HttpResponse](docs/HttpResponse.md)
 - [HttpTemplate](docs/HttpTemplate.md)
 - [KeyToMultiValue](docs/KeyToMultiValue.md)
 - [KeyToValue](docs/KeyToValue.md)
 - [Ports](docs/Ports.md)
 - [TimeToLive](docs/TimeToLive.md)
 - [Times](docs/Times.md)
 - [Verification](docs/Verification.md)
 - [VerificationSequence](docs/VerificationSequence.md)
 - [VerificationTimes](docs/VerificationTimes.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author




