"""
    jupylet/__init__.py
    
    Copyright (c) 2020, Nir Aides - nir@winpdb.org

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""


import platform
import sys
import os

from .env import is_remote, has_display, is_numpy_openblas


VERSION = '0.8.3'


if platform.system() == 'Linux' and not has_display():
    setattr(sys, 'is_pyglet_doc_run', True)
    

#
# Workaround segmentation fault when calling np.linalg.inv() in 
# mutlithreaded app.
#
if platform.system() == 'Darwin':
   if 'numpy' in sys.modules and is_numpy_openblas():
      sys.stderr.write(
         'WARNING: numpy was imported before jupylet. ' + 
         'On Mac OS X you should import jupylet first to let it work around ' +
         'a bug in the algebra libraries used by numpy that may cause the ' +
         'program to exit.' + '\n'
      )

   os.environ['OPENBLAS_NUM_THREADS'] = '1'


#
# Work around problem in pip install jupyter in python 3.8 as described in:
# https://github.com/jupyter/notebook/issues/4980#issuecomment-600992296
#
if platform.system() == 'Windows' and sys.version_info >= (3, 8) and sys.argv:
   if sys.argv[-1] == 'postinstall':
      os.system('python %s\Scripts\pywin32_postinstall.py -install' % os.__file__.rsplit('\\', 2)[0])
      sys.exit(0)

