# Project name here
> Summary description here.


This file will become your README and also the index of your documentation.

## Install

`pip install villaInvDatabase`

## How to use

interact with a database hosted in dynamodb

```python
import os
os.environ['DATABASE_TABLE_NAME'] = 'inventory-database-dev-manual'
os.environ['REGION'] = 'ap-southeast-1'
os.environ['INVENTORY_BUCKET_NAME'] = 'inventory-bucket-dev-manual'
os.environ['INPUT_BUCKET_NAME'] = 'input-bucket-dev-manual'
# os.environ['DAX_ENDPOINT'] = None
REGION = 'ap-southeast-1'
INVENTORY_BUCKET_NAME = os.environ['INVENTORY_BUCKET_NAME']
INPUT_BUCKET_NAME = os.environ['INPUT_BUCKET_NAME']
```

```python
from villaInvDatabase.database import Database
```

    dax endpoint missing


```python
sampleInput = [ 
  { 'ib_prcode': '0000009', 'ib_brcode': '1000', 'ib_cf_qty': '50', 'new_ib_vs_stock_cv': '27' },
  { 'ib_prcode': '0000002', 'ib_brcode': '1000', 'ib_cf_qty': '35', 'new_ib_vs_stock_cv': '33' }
              ]
```

```python
%%time
#update
Database.dumpToS3(user=USER, pw = PW)
```

    CPU times: user 44.5 ms, sys: 18.4 ms, total: 62.9 ms
    Wall time: 296 ms





    {'newDataSaved': False,
     'numberOfProducts': 0,
     'message': 'no changes to database'}



```python
%%time
Database.splitBranches(bucket = INVENTORY_BUCKET_NAME, user=USER, pw=PW)
```

    CPU times: user 15.2 s, sys: 405 ms, total: 15.6 s
    Wall time: 26.9 s





    {'success': 32, 'failure': 0, 'errorMessage': []}



# Save using Standard

```python
Database.updateLambdaInput(sampleInput)
```




    {'success': 0, 'failure': 0, 'failureMessage': []}



## Save using s3

```python
inputKeyName = 'input-data-name'
saveResult = S3.save(key=inputKeyName, 
                     objectToSave = sampleInput , 
                     bucket = INPUT_BUCKET_NAME,
                     user = USER,
                     pw = PW,
                     accelerate = False)
logging.info('test input data saved to s3')
updateResult = Database.updateS3Input(
  inputBucketName=INPUT_BUCKET_NAME, key= inputKeyName,
  user = USER, pw = PW)

logging.info(f's3 save result is {saveResult} update result is {updateResult}')
```

## Query test

#### Product Query

```python
sampleQueryInput = {
    'ib_prcode': '0000002'
}  
```

```python
Database.singleProductQuery(sampleQueryInput)
```




    {"ib_prcode": "0000002", "1000": {"ib_cf_qty": 35, "new_ib_bs_stock_cv": 33, "lastUpdate": 1601530923.436074}, "lastUpdate": 1601530923.436074}



### Branch Query

```python
from s3bz.s3bz import Requests
branchURL = Database.branchQuery('1000', bucket = INVENTORY_BUCKET_NAME, user=USER, pw=PW)
print(branchURL)
next(iter(Requests.getContentFromUrl(branchURL).items()))
```

    https://inventory-bucket-dev-manual.s3-accelerate.amazonaws.com/1000?AWSAccessKeyId=AKIAVX4Z5TKDVOBZ6C54&Signature=JAyklUViFbIzm%2FHZe0HvjEZDwCA%3D&Expires=1602489345





    ('0000009',
     {'ib_cf_qty': 50, 'new_ib_bs_stock_cv': 27, 'lastUpdate': 1602338504.869655})



### AllQuery

```python
from s3bz.s3bz import Requests
branchURL = Database.allQuery(bucket = INVENTORY_BUCKET_NAME, user=USER, pw=PW)
print(branchURL)
next(iter(Requests.getContentFromUrl(branchURL).items()))
```

    https://inventory-bucket-dev-manual.s3-accelerate.amazonaws.com/allData?AWSAccessKeyId=AKIAVX4Z5TKDVOBZ6C54&Signature=QqfqWUnB641lTOsGi5QKZCrRDrM%3D&Expires=1602489345





    ('0000009',
     {'ib_prcode': '0000009',
      '1000': {'ib_cf_qty': 50,
       'new_ib_bs_stock_cv': 27,
       'lastUpdate': 1602338504.869655},
      'lastUpdate': 1602338504.869655})



```python
costPer100ms = 0.0000016667
costPerMs = costPer100ms / 100
timePerCallS = 40
timePerCallMs = timePerCallS * 1000
costPerCall = costPerMs * timePerCallMs
callsPerDay = 60 * 24 /10
costPerDay = callsPerDay * costPerCall
```

```python
costPerDay * 33
```




    3.16806336


