from dataclasses import dataclass, field
from typing import Optional

from ...._client_utilities import ClientTargetable
from ..api_object import TelegramBotsObject

from .photo_size import PhotoSize


@dataclass(init=True, repr=True, slots=True)
class Audio(TelegramBotsObject, ClientTargetable):
    # --- description here ---
    """This object represents an audio file to be treated as music by the Telegram clients.
    
    More info at: https://core.telegram.org/bots/api/#audio
    """

    # --- properties here ---
    file_id: str = field(metadata={"ac_type": [str], "ac_name": "file_id"})
    """Identifier for this file, which can be used to download or reuse the file
    """

    file_unique_id: str = field(metadata={"ac_type": [str], "ac_name": "file_unique_id"})
    """Unique identifier for this file, which is supposed to be the same over time and for different bots. Can't be used to download or reuse the file.
    """

    duration: int = field(metadata={"ac_type": [int], "ac_name": "duration"})
    """Duration of the audio in seconds as defined by sender
    """

    performer: Optional[str] = field(default=None, metadata={"ac_type": [str], "ac_name": "performer"})
    """*Optional*. Performer of the audio as defined by sender or by audio tags
    """

    title: Optional[str] = field(default=None, metadata={"ac_type": [str], "ac_name": "title"})
    """*Optional*. Title of the audio as defined by sender or by audio tags
    """

    file_name: Optional[str] = field(default=None, metadata={"ac_type": [str], "ac_name": "file_name"})
    """*Optional*. Original filename as defined by sender
    """

    mime_type: Optional[str] = field(default=None, metadata={"ac_type": [str], "ac_name": "mime_type"})
    """*Optional*. MIME type of the file as defined by sender
    """

    file_size: Optional[int] = field(default=None, metadata={"ac_type": [int], "ac_name": "file_size"})
    """*Optional*. File size in bytes
    """

    thumb: Optional[PhotoSize] = field(default=None, metadata={"ac_type": [PhotoSize], "ac_name": "thumb"})
    """*Optional*. Thumbnail of the album cover to which the music file belongs
    """

