![TBlock Logo](assets/banner.png)

## Summary

- [About](#about)
- [Features](#features)
- [Installation](#installation)
- [Post-installation](#post-installation)
- [Usage](#usage)
- [Copyright](#copyright)
- [Libraries used](#libraries-used)
- [Contact](#contact)

## About

TBlock is a free and open-source ad-blocker, written in Python. It uses the [hosts file](https://tblock.codeberg.page/faq/#hosts-file) to block advertising and tracking domains, which means it protects your whole system against these domains. TBlock is compatible [with most of filter formats](docs/FILTER_SYNTAX_SUPPORTED.md), and also has [a built-in filter converter](https://tblock.codeberg.page/wiki/usage/converter/), to help you share your custom filters with people that are using different ad-blockers. 

## Features

+ Free and open-source software
+ Easy to install
+ Does not cost any money
+ Does not track your personal data
+ Does not make you fingerprintable, unlike some ad-blocking browser extensions
+ Fast rules parsing
+ Blocks ads for your whole operating system
+ Compatible with most filter formats
+ Has an [online filter repository](https://tblock.codeberg.page/wiki/filters/remote-repository) to help you find and subscribe to filters in an easier way
+ Has a built-in filter converter

## Installation

There are various methods to install TBlock. You need to install TBlock as root, since superuser privileges are required to edit the hosts file. More installation methods can be found [on the website](https://tblock.codeberg.page/install/).

### With python

This is the fastest and easiest way to install TBlock on your machine. Simply run the following command:
```shell
$ sudo pip install tblock
```

### Manually

If you prefer doing everything yourself, you can also build and install TBlock manually, by following the few steps below:

1. Clone the Git repository into a local directory
```shell
$ git clone --depth 1 https://codeberg.org/tblock/tblock.git tblock
```
2. Enter the directory
```shell
$ cd tblock
```
3. Build TBlock
```shell
$ make
```
4. Install
```shell
$ sudo make install
```

### Download the package or the binaries

Packages for GNU/Linux distributions, such as Debian/Ubuntu or Fedora/CentOS are available on [the release page](https://codeberg.org/tblock/tblock/releases), as well as pre-compiled binaries for TBlock and its converter. If you download a package or a binary, **never forget to [verify its digital signature](https://tblock.codeberg.page/faq/#verify)**.


### On Arch Linux

If you are an Arch Linux user, you can [find TBlock on the AUR](https://aur.archlinux.org/packages/tblock). Therefore, you can install it with your favorite AUR helper (for example `yay`).
```shell
$ yay -S tblock
```

## Post-installation

After the installation and after each update of TBlock, you should update your local version of the remote filter repository, by running:
```shell
$ sudo tblock -Y
```

## Usage

![Blocking a domain with TBlock](assets/usage-block.gif)

To show the help page of TBlock, simply run:
```shell
$ tblock -h
```
To show the help page of the built-in converter, simply run:
```shell
$ tblockc -h
```

You can find more help about usage on [TBlock's wiki](https://tblock.codeberg.page/wiki/usage/).

## Copyright

TBlock and its converter are released under [GPLv3](LICENSE).

## Libraries used

TBlock uses the external libraries:

| Name | Author | License | Homepage |
| --- | --- | --- | --- |
| colorama | [Jonathan Hartley](mailto:tartley@tartley.com) | BSD | https://github.com/tartley/colorama |
| requests | [Kenneth Reitz](mailto:me@kennethreitz.org) | Apache 2.0 | https://requests.readthedocs.io |
| urllib3 | [Andrey Petrov](mailto:andrey.petrov@shazow.net) | MIT | https://urllib3.readthedocs.io/ |

## Contact

- Email: twann@ctemplar.com [[PGP key](https://tblock.codeberg.page/uploads/keys/twann.asc)]
- Mastodon: [@tblock@fosstodon.org](https://fosstodon.org/@tblock)
- Matrix: [#tblock:privacytools.io](https://matrix.to/#/#tblock:privacytools.io)
- Telegram: https://t.me/tblock
- Website: https://tblock.codeberg.page/
