/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import ai.h2o.org.eclipse.jetty.server.Handler;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.server.Server;
import ai.h2o.org.eclipse.jetty.server.handler.AbstractHandler;
import ai.h2o.org.eclipse.jetty.server.handler.HandlerCollection;
import ai.h2o.org.eclipse.jetty.server.handler.HandlerWrapper;
import ai.h2o.org.eclipse.jetty.servlet.ServletContextHandler;
import ai.h2o.org.eclipse.jetty.servlet.ServletHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.RequestAuthExtension;
import water.webserver.iface.WebServer;
import water.webserver.jetty9.Jetty9Helper;
import water.webserver.jetty9.Jetty9WebsocketServlet;

class Jetty9ServerAdapter
implements WebServer {
    private final Jetty9Helper helper;
    private final H2OHttpView h2oHttpView;
    private Server jettyServer;

    private Jetty9ServerAdapter(Jetty9Helper helper, H2OHttpView h2oHttpView) {
        this.helper = helper;
        this.h2oHttpView = h2oHttpView;
    }

    static WebServer create(H2OHttpView h2oHttpView) {
        Jetty9Helper helper = new Jetty9Helper(h2oHttpView);
        return new Jetty9ServerAdapter(helper, h2oHttpView);
    }

    @Override
    public void start(String ip, int port) throws IOException {
        this.jettyServer = this.helper.createJettyServer(ip, port);
        HandlerWrapper handlerWrapper = this.helper.authWrapper(this.jettyServer);
        ServletContextHandler context = this.helper.createServletContextHandler();
        this.registerHandlers(handlerWrapper, context);
        try {
            this.jettyServer.start();
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IOException(e3);
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new IOException(e3);
            }
        }
    }

    private void registerHandlers(HandlerWrapper handlerWrapper, ServletContextHandler context) {
        for (Map.Entry<String, Class<? extends HttpServlet>> entry : this.h2oHttpView.getServlets().entrySet()) {
            context.addServlet(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Class<Object>> entry : this.h2oHttpView.getWebsockets().entrySet()) {
            try {
                Jetty9WebsocketServlet servlet = new Jetty9WebsocketServlet((H2OWebsocketServlet)entry.getValue().newInstance());
                context.addServlet(new ServletHolder(entry.getValue().getName(), servlet), entry.getKey());
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new RuntimeException("Failed to instantiate websocket servlet object", e2);
            }
        }
        ArrayList<Handler> extHandlers = new ArrayList<Handler>();
        extHandlers.add(this.helper.authenticationHandler());
        Collection<RequestAuthExtension> collection = this.h2oHttpView.getAuthExtensions();
        for (final RequestAuthExtension requestAuthExtension : collection) {
            extHandlers.add(new AbstractHandler(){

                @Override
                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (requestAuthExtension.handle(target, request, response)) {
                        baseRequest.setHandled(true);
                    }
                }
            });
        }
        extHandlers.add(context);
        HandlerCollection authHandlers = new HandlerCollection();
        authHandlers.setHandlers(extHandlers.toArray(new Handler[0]));
        LoginHandler loginHandler = new LoginHandler();
        loginHandler.setHandler(authHandlers);
        HandlerCollection hc = new HandlerCollection();
        hc.setHandlers(new Handler[]{new GateHandler(), loginHandler});
        handlerWrapper.setHandler(hc);
    }

    private class GateHandler
    extends AbstractHandler {
        private GateHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            if (Jetty9ServerAdapter.this.h2oHttpView.gateHandler(request, response)) {
                baseRequest.setHandled(true);
            }
        }
    }

    private class LoginHandler
    extends HandlerWrapper {
        private LoginHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            boolean handled = Jetty9ServerAdapter.this.h2oHttpView.loginHandler(target, request, response);
            if (handled) {
                baseRequest.setHandled(true);
            } else {
                super.handle(target, baseRequest, request, response);
            }
        }
    }
}

