/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import ai.h2o.org.eclipse.jetty.security.Authenticator;
import ai.h2o.org.eclipse.jetty.security.ServerAuthException;
import ai.h2o.org.eclipse.jetty.security.authentication.FormAuthenticator;
import ai.h2o.org.eclipse.jetty.server.Authentication;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

class Jetty9DelegatingAuthenticator
implements Authenticator {
    private Authenticator _primaryAuth;
    private FormAuthenticator _formAuth;

    Jetty9DelegatingAuthenticator(Authenticator primaryAuth, FormAuthenticator formAuth) {
        this._primaryAuth = primaryAuth;
        this._formAuth = formAuth;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._primaryAuth.setConfiguration(configuration);
        this._formAuth.setConfiguration(configuration);
    }

    @Override
    public String getAuthMethod() {
        return "FORM_PREFERRED";
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (Jetty9DelegatingAuthenticator.isBrowserAgent((HttpServletRequest)request)) {
            return this._formAuth.validateRequest(request, response, mandatory);
        }
        return this._primaryAuth.validateRequest(request, response, mandatory);
    }

    private static boolean isBrowserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && (userAgent.startsWith("Mozilla/") || userAgent.startsWith("Opera/"));
    }

    @Override
    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }
}

