/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import water.util.LogArchiveWriter;

class ZipLogArchiveWriter
extends LogArchiveWriter {
    private final ZipOutputStream _zos;

    ZipLogArchiveWriter(OutputStream os2) {
        this(new ZipOutputStream(os2));
    }

    private ZipLogArchiveWriter(ZipOutputStream zos) {
        super(zos);
        this._zos = zos;
    }

    @Override
    public void putNextEntry(LogArchiveWriter.ArchiveEntry entry) throws IOException {
        ZipEntry ze = new ZipEntry(entry._name);
        ze.setTime(entry._time);
        this._zos.putNextEntry(ze);
    }

    @Override
    public void closeEntry() throws IOException {
        this._zos.closeEntry();
    }
}

