/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.util.PrettyPrint;

public class Timer {
    private static final DateTimeFormatter longFormat = DateTimeFormat.forPattern("dd-MMM HH:mm:ss.SSS");
    private static final DateTimeFormatter shortFormat = DateTimeFormat.forPattern("HH:mm:ss.SSS");
    final long _start = System.currentTimeMillis();
    final long _nanos = System.nanoTime();

    public long time() {
        return System.currentTimeMillis() - this._start;
    }

    public long nanos() {
        return System.nanoTime() - this._nanos;
    }

    public String toString() {
        long now = System.currentTimeMillis();
        return PrettyPrint.msecs(now - this._start, false) + " (Wall: " + longFormat.print(now) + ") ";
    }

    String startAsString() {
        return longFormat.print(this._start);
    }

    String startAsShortString() {
        return shortFormat.print(this._start);
    }
}

