/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;
import water.fvec.C1SChunk;
import water.fvec.C2SChunk;
import water.fvec.C4SChunk;
import water.fvec.Chunk;

public class PrettyPrint {
    static final String[] SCALE = new String[]{"N/A (-ve)", "Zero  ", "%4.0f  B", "%.1f KB", "%.1f MB", "%.2f GB", "%.3f TB", "%.3f PB"};
    static double[] powers10 = new double[]{1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
    public static long[] powers10i = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static String msecs(long msecs, boolean truncate) {
        long hr = TimeUnit.MILLISECONDS.toHours(msecs);
        long min2 = TimeUnit.MILLISECONDS.toMinutes(msecs -= TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(msecs -= TimeUnit.MINUTES.toMillis(min2));
        long ms = TimeUnit.MILLISECONDS.toMillis(msecs -= TimeUnit.SECONDS.toMillis(sec));
        if (!truncate) {
            return String.format("%02d:%02d:%02d.%03d", hr, min2, sec, ms);
        }
        if (hr != 0L) {
            return String.format("%2d:%02d:%02d.%03d", hr, min2, sec, ms);
        }
        if (min2 != 0L) {
            return String.format("%2d min %2d.%03d sec", min2, sec, ms);
        }
        return String.format("%2d.%03d sec", sec, ms);
    }

    public static String usecs(long usecs) {
        long hr = TimeUnit.MICROSECONDS.toHours(usecs);
        long min2 = TimeUnit.MICROSECONDS.toMinutes(usecs -= TimeUnit.HOURS.toMicros(hr));
        long sec = TimeUnit.MICROSECONDS.toSeconds(usecs -= TimeUnit.MINUTES.toMicros(min2));
        long ms = TimeUnit.MICROSECONDS.toMillis(usecs -= TimeUnit.SECONDS.toMicros(sec));
        usecs -= TimeUnit.MILLISECONDS.toMicros(ms);
        if (hr != 0L) {
            return String.format("%2d:%02d:%02d.%03d", hr, min2, sec, ms);
        }
        if (min2 != 0L) {
            return String.format("%2d min %2d.%03d sec", min2, sec, ms);
        }
        if (sec != 0L) {
            return String.format("%2d.%03d sec", sec, ms);
        }
        if (ms != 0L) {
            return String.format("%3d.%03d msec", ms, usecs);
        }
        return String.format("%3d usec", usecs);
    }

    public static String toAge(Date from, Date to) {
        if (from == null || to == null) {
            return "N/A";
        }
        final Period period = new Period(from.getTime(), to.getTime());
        DurationFieldType[] dtf = new ArrayList<DurationFieldType>(){
            {
                this.add(DurationFieldType.years());
                this.add(DurationFieldType.months());
                this.add(DurationFieldType.days());
                if (period.getYears() == 0 && period.getMonths() == 0 && period.getDays() == 0) {
                    this.add(DurationFieldType.hours());
                    this.add(DurationFieldType.minutes());
                }
            }
        }.toArray(new DurationFieldType[0]);
        PeriodFormatter pf = PeriodFormat.getDefault();
        return pf.print(period.normalizedStandard(PeriodType.forFields(dtf)));
    }

    static int byteScale(long bytes) {
        if (bytes < 0L) {
            return -1;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            if (bytes >= 1L << i2 * 10) continue;
            return i2;
        }
        return 6;
    }

    static double bytesScaled(long bytes, int scale) {
        if (scale <= 0) {
            return bytes;
        }
        return (double)bytes / (double)(1L << (scale - 1) * 10);
    }

    public static String bytes(long bytes) {
        return PrettyPrint.bytes(bytes, PrettyPrint.byteScale(bytes));
    }

    static String bytes(long bytes, int scale) {
        return String.format(SCALE[scale + 1], PrettyPrint.bytesScaled(bytes, scale));
    }

    public static String bytesPerSecond(long bytes) {
        if (bytes < 0L) {
            return "N/A";
        }
        return PrettyPrint.bytes(bytes) + "/S";
    }

    public static double pow10(long m4, int e2) {
        return e2 < 0 ? (double)m4 / PrettyPrint.pow10(-e2) : (double)m4 * PrettyPrint.pow10(e2);
    }

    private static double pow10(int exp) {
        return exp >= -10 && exp <= 10 ? powers10[exp + 10] : Math.pow(10.0, exp);
    }

    public static long pow10i(int exp) {
        return exp > -1 && exp < 19 ? powers10i[exp] : (long)Math.pow(10.0, exp);
    }

    public static boolean fitsIntoInt(double d2) {
        return Math.abs((double)((int)d2) - d2) < 1.0E-8;
    }

    public static String UUID(long lo, long hi) {
        long lo0 = lo >> 32 & 0xFFFFFFFFL;
        long lo1 = lo >> 16 & 0xFFFFL;
        long lo2 = lo >> 0 & 0xFFFFL;
        long hi0 = hi >> 48 & 0xFFFFL;
        long hi1 = hi >> 0 & 0xFFFFFFFFFFFFL;
        return String.format("%08X-%04X-%04X-%04X-%012X", lo0, lo1, lo2, hi0, hi1);
    }

    public static String uuid(UUID uuid) {
        return uuid == null ? "(N/A)" : PrettyPrint.UUID(uuid.getLeastSignificantBits(), uuid.getMostSignificantBits());
    }

    public static String number(Chunk chk, double d2, int precision) {
        long l2 = (long)d2;
        if ((double)l2 == d2) {
            return Long.toString(l2);
        }
        if (precision > 0) {
            return PrettyPrint.x2(d2, PrettyPrint.pow10(-precision));
        }
        Class<?> chunkClass = chk.getClass();
        if (chunkClass == C1SChunk.class) {
            return PrettyPrint.x2(d2, ((C1SChunk)chk).scale());
        }
        if (chunkClass == C2SChunk.class) {
            return PrettyPrint.x2(d2, ((C2SChunk)chk).scale());
        }
        if (chunkClass == C4SChunk.class) {
            return PrettyPrint.x2(d2, ((C4SChunk)chk).scale());
        }
        return Double.toString(d2);
    }

    private static String x2(double d2, double scale) {
        String s2 = Double.toString(d2);
        int ex = (int)Math.log10(scale);
        int x2 = s2.indexOf(46);
        int y2 = x2 + 1 + -ex;
        if (x2 != -1 && y2 < s2.length()) {
            s2 = s2.substring(0, x2 + 1 + -ex);
        }
        while (s2.charAt(s2.length() - 1) == '0') {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    public static String formatPct(double pct) {
        String s2 = "N/A";
        if (!Double.isNaN(pct)) {
            s2 = String.format("%5.2f %%", 100.0 * pct);
        }
        return s2;
    }

    public static String withOrdinalIndicator(long i2) {
        String ord;
        int d2 = (int)((double)Math.abs(i2) / Math.pow(10.0, 1.0)) % 10;
        if (d2 == 1) {
            ord = "th";
        } else {
            d2 = (int)((double)Math.abs(i2) / Math.pow(10.0, 0.0)) % 10;
            switch (d2) {
                case 1: {
                    ord = "st";
                    break;
                }
                case 2: {
                    ord = "nd";
                    break;
                }
                case 3: {
                    ord = "rd";
                    break;
                }
                default: {
                    ord = "th";
                }
            }
        }
        return i2 + ord;
    }
}

