/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.Weaver;
import water.api.Schema;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2ONotFoundArgumentException;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;
import water.util.EnumUtils;
import water.util.JSONUtils;
import water.util.JSONValue;
import water.util.Log;
import water.util.ReflectionUtils;
import water.util.SB;

public class PojoUtils {
    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming) {
        PojoUtils.copyProperties(dest, origin, field_naming, null);
    }

    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming, String[] skip_fields) {
        PojoUtils.copyProperties(dest, origin, field_naming, skip_fields, null);
    }

    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming, String[] skip_fields, String[] only_fields) {
        Field[] orig_fields;
        if (null == dest || null == origin) {
            return;
        }
        Field[] dest_fields = Weaver.getWovenFields(dest.getClass());
        for (Field orig_field : orig_fields = Weaver.getWovenFields(origin.getClass())) {
            String origin_name = orig_field.getName();
            String dest_name = field_naming.toDest(origin_name);
            if (skip_fields != null && (ArrayUtils.contains(skip_fields, origin_name) || ArrayUtils.contains(skip_fields, dest_name)) || only_fields != null && !ArrayUtils.contains(only_fields, origin_name) && !ArrayUtils.contains(only_fields, dest_name)) continue;
            try {
                Schema s2;
                KeyV3 k2;
                Field dest_field = null;
                for (Field fd : dest_fields) {
                    if (!fd.getName().equals(dest_name)) continue;
                    dest_field = fd;
                    break;
                }
                if (dest_field == null) continue;
                dest_field.setAccessible(true);
                orig_field.setAccessible(true);
                if (null == orig_field.get(origin)) {
                    dest_field.set(dest, null);
                    continue;
                }
                if (dest_field.getType().isArray() && orig_field.getType().isArray() && dest_field.getType().getComponentType() != orig_field.getType().getComponentType()) {
                    Iced[] translation;
                    Iced[] orig_array_copy;
                    int length;
                    Class<?> dest_component_class;
                    Object[] copy;
                    if (dest_field.getType().getComponentType().isAssignableFrom(orig_field.getType().getComponentType())) {
                        dest_field.set(dest, orig_field.get(origin));
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Double.TYPE && orig_field.getType().getComponentType() == Double.class) {
                        copy = (double[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Double.class && orig_field.getType().getComponentType() == Double.TYPE) {
                        copy = (Double[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Integer.TYPE && orig_field.getType().getComponentType() == Integer.class) {
                        copy = (int[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Integer.class && orig_field.getType().getComponentType() == Integer.TYPE) {
                        copy = (Integer[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (Schema.class.isAssignableFrom(dest_field.getType().getComponentType()) && Schema.getImplClass(dest_field.getType().getComponentType()).isAssignableFrom(orig_field.getType().getComponentType())) {
                        dest_component_class = dest_field.getType().getComponentType();
                        Iced[] orig_array = (Iced[])orig_field.get(origin);
                        length = orig_array.length;
                        orig_array_copy = Arrays.copyOf(orig_array, length);
                        translation = (Schema[])Array.newInstance(dest_component_class, length);
                        int version = ((Schema)dest).getSchemaVersion();
                        for (int i2 = 0; i2 < length; ++i2) {
                            Iced impl = orig_array_copy[i2];
                            if (null == impl) {
                                translation[i2++] = null;
                                continue;
                            }
                            Schema s3 = null;
                            try {
                                s3 = SchemaServer.schema(version, impl);
                            }
                            catch (H2ONotFoundArgumentException e2) {
                                s3 = (Schema)dest_field.getType().getComponentType().newInstance();
                            }
                            translation[i2] = s3.fillFromImpl(impl);
                        }
                        dest_field.set(dest, translation);
                        continue;
                    }
                    if (Schema.class.isAssignableFrom(orig_field.getType().getComponentType()) && Iced.class.isAssignableFrom(dest_field.getType().getComponentType())) {
                        dest_component_class = dest_field.getType().getComponentType();
                        Schema[] orig_array = (Schema[])orig_field.get(origin);
                        length = orig_array.length;
                        orig_array_copy = Arrays.copyOf(orig_array, length);
                        translation = (Iced[])Array.newInstance(dest_component_class, length);
                        for (int i3 = 0; i3 < length; ++i3) {
                            Iced s4 = orig_array_copy[i3];
                            translation[i3] = s4 == null ? null : ((Schema)s4).createAndFillImpl();
                        }
                        dest_field.set(dest, translation);
                        continue;
                    }
                    throw H2O.fail("Don't know how to cast an array of: " + orig_field.getType().getComponentType() + " to an array of: " + dest_field.getType().getComponentType());
                }
                if (dest_field.getType() == Key.class && Keyed.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, ((Keyed)orig_field.get((Object)origin))._key);
                    continue;
                }
                if (orig_field.getType() == Key.class && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    Value v2 = DKV.get((Key)orig_field.get(origin));
                    dest_field.set(dest, null == v2 ? null : v2.get());
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(dest_field.getType()) && Keyed.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, KeyV3.make(dest_field.getType(), ((Keyed)orig_field.get((Object)origin))._key));
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(orig_field.getType()) && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    k2 = (KeyV3)orig_field.get(origin);
                    Value v3 = DKV.get(Key.make(k2.name));
                    dest_field.set(dest, null == v3 ? null : v3.get());
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(dest_field.getType()) && Key.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, KeyV3.make(dest_field.getType(), (Key)orig_field.get(origin)));
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(orig_field.getType()) && Key.class.isAssignableFrom(dest_field.getType())) {
                    k2 = (KeyV3)orig_field.get(origin);
                    dest_field.set(dest, null == k2.name ? null : Key.make(k2.name));
                    continue;
                }
                if (dest_field.getType() == Pattern.class && String.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, Pattern.compile((String)orig_field.get(origin)));
                    continue;
                }
                if (orig_field.getType() == Pattern.class && String.class.isAssignableFrom(dest_field.getType())) {
                    dest_field.set(dest, orig_field.get(origin).toString());
                    continue;
                }
                if (dest_field.getType() == FrameV3.ColSpecifierV3.class && String.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, new FrameV3.ColSpecifierV3((String)orig_field.get(origin)));
                    continue;
                }
                if (orig_field.getType() == FrameV3.ColSpecifierV3.class && String.class.isAssignableFrom(dest_field.getType())) {
                    dest_field.set(dest, ((FrameV3.ColSpecifierV3)orig_field.get((Object)origin)).column_name);
                    continue;
                }
                if (Enum.class.isAssignableFrom(dest_field.getType()) && String.class.isAssignableFrom(orig_field.getType())) {
                    Class<?> dest_class = dest_field.getType();
                    dest_field.set(dest, EnumUtils.valueOfIgnoreCase(dest_class, (String)orig_field.get(origin)));
                    continue;
                }
                if (Enum.class.isAssignableFrom(orig_field.getType()) && String.class.isAssignableFrom(dest_field.getType())) {
                    Object o2 = orig_field.get(origin);
                    dest_field.set(dest, o2 == null ? null : o2.toString());
                    continue;
                }
                if (Schema.class.isAssignableFrom(dest_field.getType()) && Schema.getImplClass(dest_field.getType()).isAssignableFrom(orig_field.getType())) {
                    int dest_version = Schema.extractVersionFromSchemaName(dest_field.getType().getSimpleName());
                    Iced ori = (Iced)orig_field.get(origin);
                    dest_field.set(dest, SchemaServer.schema(dest_version, ori.getClass()).fillFromImpl(ori));
                    continue;
                }
                if (Schema.class.isAssignableFrom(orig_field.getType()) && Schema.getImplClass(orig_field.getType()).isAssignableFrom(dest_field.getType())) {
                    s2 = (Schema)orig_field.get(origin);
                    dest_field.set(dest, s2.fillImpl(s2.createImpl()));
                    continue;
                }
                if (Schema.class.isAssignableFrom(dest_field.getType()) && Key.class.isAssignableFrom(orig_field.getType())) {
                    Key origin_key = (Key)orig_field.get(origin);
                    Value v4 = DKV.get(origin_key);
                    if (null == v4 || null == v4.get()) {
                        dest_field.set(dest, null);
                        continue;
                    }
                    if (((Schema)dest_field.get(dest)).getImplClass().isAssignableFrom(v4.get().getClass())) {
                        Schema s5 = (Schema)dest_field.get(dest);
                        dest_field.set(dest, SchemaServer.schema(s5.getSchemaVersion(), s5.getImplClass()).fillFromImpl(v4.get()));
                        continue;
                    }
                    Log.err("Can't fill Schema of type: " + dest_field.getType() + " with value of type: " + v4.getClass() + " fetched from Key: " + origin_key);
                    dest_field.set(dest, null);
                    continue;
                }
                if (Schema.class.isAssignableFrom(orig_field.getType()) && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    s2 = (Schema)orig_field.get(origin);
                    dest_field.set(dest, ((Keyed)s2.fillImpl(s2.createImpl()))._key);
                    continue;
                }
                dest_field.set(dest, orig_field.get(origin));
            }
            catch (IllegalAccessException e3) {
                Log.err("Illegal access exception trying to copy field: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
            }
            catch (InstantiationException e4) {
                Log.err("Instantiation exception trying to copy field: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
            }
            catch (Exception e5) {
                Log.err(e5.getClass().getCanonicalName() + " Exception: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
                throw e5;
            }
        }
    }

    public static void filterFields(Object o2, String includes, String excludes) {
        String[] exclude_paths;
        if (null == o2) {
            return;
        }
        if (null == excludes || "".equals(excludes)) {
            return;
        }
        if (null != includes) {
            throw new H2OIllegalArgumentException("_include_fields", "filterFields", includes);
        }
        for (String path : exclude_paths = excludes.split(",")) {
            Object[] field_value;
            int slash = path.indexOf("/");
            if (-1 == slash || slash == path.length()) {
                Field f2 = ReflectionUtils.findNamedField(o2, path);
                if (null == f2) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
                try {
                    f2.set(o2, null);
                    continue;
                }
                catch (IllegalAccessException e2) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            String first = path.substring(0, slash);
            String rest = path.substring(slash + 1);
            Field f3 = ReflectionUtils.findNamedField(o2, first);
            if (null == f3) {
                throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
            }
            if (f3.getType().isArray() && Object.class.isAssignableFrom(f3.getType().getComponentType())) {
                try {
                    for (Object child : field_value = (Object[])f3.get(o2)) {
                        PojoUtils.filterFields(child, null, rest);
                    }
                    continue;
                }
                catch (IllegalAccessException e3) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            if (Object.class.isAssignableFrom(f3.getType())) {
                try {
                    field_value = f3.get(o2);
                    PojoUtils.filterFields(field_value, null, rest);
                    continue;
                }
                catch (IllegalAccessException e4) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
        }
    }

    public static boolean equals(Object a2, Field fa, Object b2, Field fb) {
        try {
            Object va = fa.get(a2);
            Object vb = fb.get(b2);
            return va == null ? vb == null : va.equals(vb);
        }
        catch (IllegalAccessException e2) {
            Log.err(e2);
            return false;
        }
    }

    public static void setField(Object o2, String fieldName, Object value, FieldNaming objectNamingConvention) {
        String destFieldName = null;
        switch (objectNamingConvention) {
            case CONSISTENT: {
                destFieldName = fieldName;
                break;
            }
            case DEST_HAS_UNDERSCORES: {
                if (fieldName.startsWith("_")) {
                    destFieldName = fieldName;
                    break;
                }
                destFieldName = "_" + fieldName;
                break;
            }
            case ORIGIN_HAS_UNDERSCORES: {
                if (fieldName.startsWith("_")) {
                    destFieldName = fieldName.substring(1);
                    break;
                }
                throw new IllegalArgumentException("Wrong combination of options!");
            }
        }
        PojoUtils.setField(o2, destFieldName, value);
    }

    public static void setField(Object o2, String fieldName, Object value) {
        block39: {
            try {
                Field f2 = PojoUtils.getFieldEvenInherited(o2, fieldName);
                f2.setAccessible(true);
                if (null == value) {
                    f2.set(o2, null);
                    return;
                }
                if (List.class.isAssignableFrom(value.getClass()) && f2.getType().isArray() && f2.getType().getComponentType() == String.class) {
                    PojoUtils.setField(o2, fieldName, ((List)value).toArray(new String[0]));
                    return;
                }
                if (f2.getType().isPrimitive() && f2.getType() != value.getClass()) {
                    if (f2.getType() == Integer.TYPE && (value.getClass() == Double.class || value.getClass() == Float.class)) {
                        f2.set(o2, ((Double)value).intValue());
                    } else if (f2.getType() == Long.TYPE && (value.getClass() == Double.class || value.getClass() == Float.class)) {
                        f2.set(o2, ((Double)value).longValue());
                    } else if (f2.getType() == Integer.TYPE && value.getClass() == Integer.class) {
                        f2.set(o2, (int)((Integer)value));
                    } else if (f2.getType() == Long.TYPE && (value.getClass() == Long.class || value.getClass() == Integer.class)) {
                        f2.set(o2, (long)((Long)value));
                    } else if (f2.getType() == Float.TYPE && value instanceof Number) {
                        f2.set(o2, Float.valueOf(((Number)value).floatValue()));
                    } else {
                        f2.set(o2, value);
                    }
                    break block39;
                }
                if (f2.getType().isArray() && value.getClass().isArray() || value instanceof List) {
                    Object[] valuesTyped;
                    Class<?> valueComponentType;
                    if (value instanceof List) {
                        List valueList = (List)value;
                        if (valueList.isEmpty()) {
                            valueComponentType = f2.getType().getComponentType();
                            value = Array.newInstance(valueComponentType, 0);
                        } else {
                            value = valueList.toArray();
                            valueComponentType = valueList.get(0).getClass();
                        }
                    } else {
                        valueComponentType = value.getClass().getComponentType();
                    }
                    if (f2.getType().getComponentType() == valueComponentType) {
                        f2.set(o2, value);
                        break block39;
                    }
                    if (f2.getType().getComponentType() == Integer.TYPE && valueComponentType == Integer.class) {
                        valuesTyped = (Object[])value;
                        int[] valuesCast = new int[valuesTyped.length];
                        for (int i2 = 0; i2 < valuesTyped.length; ++i2) {
                            valuesCast[i2] = ((Number)valuesTyped[i2]).intValue();
                        }
                        f2.set(o2, valuesCast);
                        break block39;
                    }
                    if (f2.getType().getComponentType() == Long.TYPE && valueComponentType == Long.class) {
                        valuesTyped = (Object[])value;
                        long[] valuesCast = new long[valuesTyped.length];
                        for (int i3 = 0; i3 < valuesTyped.length; ++i3) {
                            valuesCast[i3] = ((Number)valuesTyped[i3]).longValue();
                        }
                        f2.set(o2, valuesCast);
                        break block39;
                    }
                    if (f2.getType().getComponentType() == Double.TYPE && (valueComponentType == Float.class || valueComponentType == Double.class || valueComponentType == Integer.class || valueComponentType == Long.class)) {
                        valuesTyped = (Object[])value;
                        double[] valuesCast = new double[valuesTyped.length];
                        for (int i4 = 0; i4 < valuesTyped.length; ++i4) {
                            valuesCast[i4] = ((Number)valuesTyped[i4]).doubleValue();
                        }
                        f2.set(o2, valuesCast);
                        break block39;
                    }
                    if (f2.getType().getComponentType() == Float.TYPE && (valueComponentType == Float.class || valueComponentType == Double.class || valueComponentType == Integer.class || valueComponentType == Long.class)) {
                        valuesTyped = (Object[])value;
                        float[] valuesCast = new float[valuesTyped.length];
                        for (int i5 = 0; i5 < valuesTyped.length; ++i5) {
                            valuesCast[i5] = ((Number)valuesTyped[i5]).floatValue();
                        }
                        f2.set(o2, valuesCast);
                        break block39;
                    }
                    if (f2.getType().getComponentType().isEnum()) {
                        valuesTyped = (Object[])value;
                        Enum[] valuesCast = (Enum[])Array.newInstance(f2.getType().getComponentType(), valuesTyped.length);
                        for (int i6 = 0; i6 < valuesTyped.length; ++i6) {
                            Enum enu;
                            String v2 = (String)valuesTyped[i6];
                            valuesCast[i6] = enu = (Enum)EnumUtils.valueOfIgnoreCase(f2.getType().getComponentType(), v2).orElseThrow(() -> new IllegalArgumentException("Field = " + fieldName + " element cannot be set to value = " + Arrays.toString(valuesTyped)));
                        }
                        f2.set(o2, valuesCast);
                        break block39;
                    }
                    if (Schema.class.isAssignableFrom(f2.getType().getComponentType())) {
                        valuesTyped = (Object[])value;
                        Schema[] valuesCast = (Schema[])Array.newInstance(f2.getType().getComponentType(), valuesTyped.length);
                        try {
                            for (int i7 = 0; i7 < valuesTyped.length; ++i7) {
                                Schema v3 = (Schema)f2.getType().getComponentType().newInstance();
                                valuesCast[i7] = v3.fillFromAny(valuesTyped[i7]);
                            }
                            f2.set(o2, valuesCast);
                            break block39;
                        }
                        catch (InstantiationException e2) {
                            throw new IllegalArgumentException("Field = " + fieldName + " element cannot be set to value = " + value, e2);
                        }
                    }
                    throw new IllegalArgumentException("setField can't yet convert an array of: " + value.getClass().getComponentType() + " to an array of: " + f2.getType().getComponentType());
                }
                if (f2.getType().isEnum() && value instanceof String) {
                    IllegalArgumentException fieldNotSettablException = new IllegalArgumentException("Field = " + fieldName + " cannot be set to value = " + value);
                    Enum enu = (Enum)EnumUtils.valueOfIgnoreCase(f2.getType(), (String)value).orElseThrow(() -> fieldNotSettablException);
                    f2.set(o2, enu);
                } else {
                    if (!f2.getType().isPrimitive() && !f2.getType().isAssignableFrom(value.getClass())) {
                        throw new IllegalArgumentException("setField can't yet convert a: " + value.getClass() + " to a: " + f2.getType());
                    }
                    f2.set(o2, value);
                }
            }
            catch (NoSuchFieldException e3) {
                throw new IllegalArgumentException("Field " + fieldName + " not found!", e3);
            }
            catch (IllegalAccessException e4) {
                throw new IllegalArgumentException("Field=" + fieldName + " cannot be set to value=" + value, e4);
            }
        }
    }

    public static Field getFieldEvenInherited(Object o2, String name) throws NoSuchFieldException, SecurityException {
        for (Class<?> clazz = o2.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchFieldException("Failed to find field: " + name + " in object: " + o2);
    }

    public static Object getFieldValue(Object o2, String name, FieldNaming fieldNaming) {
        if (o2 == null) {
            throw new IllegalArgumentException("Cannot get the field from null object!");
        }
        String destName = fieldNaming.toDest(name);
        try {
            Field f2 = PojoUtils.getFieldEvenInherited(o2, destName);
            return f2.get(o2);
        }
        catch (NoSuchFieldException e2) {
            throw new IllegalArgumentException("Field not found: '" + name + "/" + destName + "' on object " + o2);
        }
        catch (IllegalAccessException e3) {
            throw new IllegalArgumentException("Cannot get value of the field: '" + name + "/" + destName + "' on object " + o2);
        }
    }

    public static <T> T fillFromJson(T o2, String json) {
        NonBlockingHashMap<String, Object> setFields = JSONUtils.parse(json);
        return PojoUtils.fillFromMap(o2, setFields);
    }

    private static <T> T fillFromMap(T o2, Map<String, Object> setFields) {
        for (String key : setFields.keySet()) {
            Field f2;
            try {
                f2 = PojoUtils.getFieldEvenInherited(o2, key);
                f2.setAccessible(true);
            }
            catch (NoSuchFieldException e2) {
                throw new IllegalArgumentException("Field not found: '" + key + "' on object " + o2);
            }
            Object value = setFields.get(key);
            if (JSONValue.class == f2.getType()) {
                PojoUtils.setField(o2, key, JSONValue.fromValue(value));
                continue;
            }
            if (value instanceof Map) {
                try {
                    if (null == f2.get(o2)) {
                        f2.set(o2, f2.getType().newInstance());
                    }
                    PojoUtils.fillFromMap(f2.get(o2), (Map)value);
                    continue;
                }
                catch (IllegalAccessException e3) {
                    throw new IllegalArgumentException("Cannot get value of the field: '" + key + "' on object " + o2);
                }
                catch (InstantiationException e4) {
                    try {
                        throw new IllegalArgumentException("Cannot create new child object of type: " + PojoUtils.getFieldEvenInherited(o2, key).getClass().getCanonicalName() + " for field: '" + key + "' on object " + o2);
                    }
                    catch (NoSuchFieldException ee) {
                        throw new IllegalArgumentException("Cannot create new child object of type for field: '" + key + "' on object " + o2);
                    }
                }
            }
            if (value instanceof List) {
                List values = (List)value;
                if (f2.getType().isArray() && Schema.class.isAssignableFrom(f2.getType().getComponentType()) && values.size() > 0) {
                    if (values.stream().allMatch(Map.class::isInstance)) {
                        Schema[] valuesDest = (Schema[])Array.newInstance(f2.getType().getComponentType(), values.size());
                        try {
                            int i2 = 0;
                            for (Map valueMap : values) {
                                Schema v2 = (Schema)f2.getType().getComponentType().newInstance();
                                valuesDest[i2++] = PojoUtils.fillFromMap(v2, valueMap);
                            }
                            f2.set(o2, valuesDest);
                            continue;
                        }
                        catch (IllegalAccessException e5) {
                            throw new IllegalArgumentException("Cannot get value of the field: '" + key + "' on object " + o2);
                        }
                        catch (InstantiationException e6) {
                            throw new IllegalArgumentException("Field = " + key + " element cannot be set to value = " + value, e6);
                        }
                    }
                }
                PojoUtils.setField(o2, key, value);
                continue;
            }
            if (f2.getType().isAssignableFrom(FrameV3.ColSpecifierV3.class)) {
                PojoUtils.setField(o2, key, new FrameV3.ColSpecifierV3((String)value));
                continue;
            }
            if (KeyV3.class.isAssignableFrom(f2.getType())) {
                PojoUtils.setField(o2, key, KeyV3.make(f2.getType(), Key.make((String)value)));
                continue;
            }
            PojoUtils.setField(o2, key, value);
        }
        return o2;
    }

    public static boolean arraysEquals(Object a2, Object b2) {
        if (a2 == null || !a2.getClass().isArray()) {
            throw new H2OIllegalArgumentException("a", "arraysEquals", a2);
        }
        if (b2 == null || !b2.getClass().isArray()) {
            throw new H2OIllegalArgumentException("b", "arraysEquals", b2);
        }
        if (a2.getClass().getComponentType() != b2.getClass().getComponentType()) {
            throw new H2OIllegalArgumentException("Can't compare arrays of different types: " + a2.getClass().getComponentType() + " and: " + b2.getClass().getComponentType());
        }
        if (a2.getClass().getComponentType() == Boolean.TYPE) {
            return Arrays.equals((boolean[])a2, (boolean[])b2);
        }
        if (a2.getClass().getComponentType() == Boolean.class) {
            return Arrays.equals((Object[])((Boolean[])a2), (Object[])((Boolean[])b2));
        }
        if (a2.getClass().getComponentType() == Character.TYPE) {
            return Arrays.equals((char[])a2, (char[])b2);
        }
        if (a2.getClass().getComponentType() == Short.TYPE) {
            return Arrays.equals((short[])a2, (short[])b2);
        }
        if (a2.getClass().getComponentType() == Short.class) {
            return Arrays.equals((Object[])((Short[])a2), (Object[])((Short[])b2));
        }
        if (a2.getClass().getComponentType() == Integer.TYPE) {
            return Arrays.equals((int[])a2, (int[])b2);
        }
        if (a2.getClass().getComponentType() == Integer.class) {
            return Arrays.equals((Object[])((Integer[])a2), (Object[])((Integer[])b2));
        }
        if (a2.getClass().getComponentType() == Float.TYPE) {
            return Arrays.equals((float[])a2, (float[])b2);
        }
        if (a2.getClass().getComponentType() == Float.class) {
            return Arrays.equals((Object[])((Float[])a2), (Object[])((Float[])b2));
        }
        if (a2.getClass().getComponentType() == Double.TYPE) {
            return Arrays.equals((double[])a2, (double[])b2);
        }
        if (a2.getClass().getComponentType() == Double.class) {
            return Arrays.equals((Object[])((Double[])a2), (Object[])((Double[])b2));
        }
        return Arrays.deepEquals((Object[])a2, (Object[])b2);
    }

    public static String toJavaDoubleArray(double[] array) {
        if (array == null) {
            return "null";
        }
        SB sb = new SB();
        sb.p("new double[] {");
        for (int i2 = 0; i2 < array.length; ++i2) {
            sb.p(" ");
            sb.p(array[i2]);
            if (i2 >= array.length - 1) continue;
            sb.p(",");
        }
        sb.p("}");
        return sb.getContent();
    }

    public static enum FieldNaming {
        CONSISTENT{

            @Override
            String toDest(String origin) {
                return origin;
            }

            @Override
            String toOrigin(String dest) {
                return dest;
            }
        }
        ,
        DEST_HAS_UNDERSCORES{

            @Override
            String toDest(String origin) {
                return "_" + origin;
            }

            @Override
            String toOrigin(String dest) {
                return dest.substring(1);
            }
        }
        ,
        ORIGIN_HAS_UNDERSCORES{

            @Override
            String toDest(String origin) {
                return origin.substring(1);
            }

            @Override
            String toOrigin(String dest) {
                return "_" + dest;
            }
        };


        abstract String toDest(String var1);

        abstract String toOrigin(String var1);
    }
}

