/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import sun.misc.Unsafe;
import water.nbhm.UtilUnsafe;
import water.util.SB;

public abstract class AtomicUtils {

    public static class IntArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Ibase = _unsafe.arrayBaseOffset(int[].class);
        private static final int _Iscale = _unsafe.arrayIndexScale(int[].class);

        private static long rawIndex(int[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Ibase + idx * _Iscale;
        }

        public static void incr(int[] is, int i2) {
            IntArray.add(is, i2, 1);
        }

        public static void add(int[] is, int i2, int x2) {
            long adr = IntArray.rawIndex(is, i2);
            int old = is[i2];
            while (!_unsafe.compareAndSwapInt(is, adr, old, old + x2)) {
                old = is[i2];
            }
        }
    }

    public static class LongArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        public static void incr(long[] ls, int i2) {
            LongArray.add(ls, i2, 1L);
        }

        public static void add(long[] ls, int i2, long x2) {
            long adr = LongArray.rawIndex(ls, i2);
            long old = ls[i2];
            while (!_unsafe.compareAndSwapLong(ls, adr, old, old + x2)) {
                old = ls[i2];
            }
        }
    }

    public static class DoubleArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Dbase = _unsafe.arrayBaseOffset(double[].class);
        private static final int _Dscale = _unsafe.arrayIndexScale(double[].class);

        private static long rawIndex(double[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Dbase + idx * _Dscale;
        }

        public static boolean CAS(double[] ds, int i2, double old, double newd) {
            return _unsafe.compareAndSwapLong(ds, DoubleArray.rawIndex(ds, i2), Double.doubleToRawLongBits(old), Double.doubleToRawLongBits(newd));
        }

        public static void add(double[] ds, int i2, double y2) {
            double old;
            while (!DoubleArray.CAS(ds, i2, old = ds[i2], old + y2)) {
            }
        }

        public static void min(double[] ds, int i2, double min2) {
            double old;
            while (!DoubleArray.CAS(ds, i2, old = ds[i2], Math.min(old, min2))) {
            }
        }

        public static void max(double[] ds, int i2, double max) {
            double old;
            while (!DoubleArray.CAS(ds, i2, old = ds[i2], Math.max(old, max))) {
            }
        }
    }

    public static abstract class FloatArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Fbase = _unsafe.arrayBaseOffset(float[].class);
        private static final int _Fscale = _unsafe.arrayIndexScale(float[].class);

        private static long rawIndex(float[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Fbase + idx * _Fscale;
        }

        public static void add(float[] ds, int i2, float y2) {
            long adr = FloatArray.rawIndex(ds, i2);
            float old = ds[i2];
            while (!_unsafe.compareAndSwapInt(ds, adr, Float.floatToRawIntBits(old), Float.floatToRawIntBits(old + y2))) {
                old = ds[i2];
            }
        }

        public static String toString(float[] fs) {
            SB sb = new SB();
            sb.p('[');
            for (float f2 : fs) {
                sb.p(f2 == Float.MAX_VALUE ? "max" : (f2 == -3.4028235E38f ? "min" : Float.toString(f2))).p(',');
            }
            return sb.p(']').toString();
        }
    }
}

