/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.RandomBase;
import water.util.RandomUtils;

public class ArrayUtils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final DecimalFormat default_dformat = new DecimalFormat("0.#####");

    public static int[] cumsum(int[] from) {
        int arryLen = from.length;
        int[] cumsumR = new int[arryLen];
        int result = 0;
        for (int index = 0; index < arryLen; ++index) {
            result += result + from[index];
            cumsumR[index] = result;
        }
        return cumsumR;
    }

    public static long sum(long[] from) {
        long result = 0L;
        for (long d2 : from) {
            result += d2;
        }
        return result;
    }

    public static long sum(long[] from, int startIdx, int endIdx) {
        long result = 0L;
        for (int i2 = startIdx; i2 < endIdx; ++i2) {
            result += from[i2];
        }
        return result;
    }

    public static int sum(int[] from) {
        int result = 0;
        for (int d2 : from) {
            result += d2;
        }
        return result;
    }

    public static long suml(int[] from) {
        long result = 0L;
        for (int d2 : from) {
            result += (long)d2;
        }
        return result;
    }

    public static float sum(float[] from) {
        float result = 0.0f;
        for (float d2 : from) {
            result += d2;
        }
        return result;
    }

    public static double sum(double[] from) {
        double result = 0.0;
        for (double d2 : from) {
            result += d2;
        }
        return result;
    }

    public static float[] reduceMin(float[] a2, float[] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = Math.min(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static float[] reduceMax(float[] a2, float[] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = Math.max(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static double innerProduct(double[] x2, double[] y2) {
        double result = 0.0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            result += x2[i2] * y2[i2];
        }
        return result;
    }

    public static double innerProductPartial(double[] x2, int[] x_index, double[] y2) {
        double result = 0.0;
        for (int i2 = 0; i2 < y2.length; ++i2) {
            result += x2[x_index[i2]] * y2[i2];
        }
        return result;
    }

    public static double[] mmul(double[][] M2, double[] V) {
        double[] res = new double[M2.length];
        for (int i2 = 0; i2 < M2.length; ++i2) {
            double d2 = 0.0;
            for (int j2 = 0; j2 < V.length; ++j2) {
                d2 += M2[i2][j2] * V[j2];
            }
            res[i2] = d2;
        }
        return res;
    }

    public static double[][] outerProduct(double[] x2, double[] y2) {
        double[][] result = new double[x2.length][y2.length];
        for (int i2 = 0; i2 < x2.length; ++i2) {
            for (int j2 = 0; j2 < y2.length; ++j2) {
                result[i2][j2] = x2[i2] * y2[j2];
            }
        }
        return result;
    }

    public static double[] sqrtArr(double[] x2) {
        assert (x2 != null);
        int len = x2.length;
        for (int index = 0; index < len; ++index) {
            assert (x2[index] >= 0.0);
            x2[index] = StrictMath.sqrt(x2[index]);
        }
        return x2;
    }

    public static double l2norm2(double[] x2) {
        return ArrayUtils.l2norm2(x2, false);
    }

    public static double l2norm2(double[][] xs, boolean skipLast) {
        double res = 0.0;
        for (double[] x2 : xs) {
            res += ArrayUtils.l2norm2(x2, skipLast);
        }
        return res;
    }

    public static double l2norm2(double[] x2, boolean skipLast) {
        double sum = 0.0;
        int last = x2.length - (skipLast ? 1 : 0);
        for (int i2 = 0; i2 < last; ++i2) {
            sum += x2[i2] * x2[i2];
        }
        return sum;
    }

    public static double l2norm2(double[] x2, double[] y2) {
        assert (x2.length == y2.length);
        double sse = 0.0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            double diff = x2[i2] - y2[i2];
            sse += diff * diff;
        }
        return sse;
    }

    public static double l2norm2(double[][] x2, double[][] y2) {
        assert (x2.length == y2.length && x2[0].length == y2[0].length);
        double sse = 0.0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            sse += ArrayUtils.l2norm2(x2[i2], y2[i2]);
        }
        return sse;
    }

    public static double l1norm(double[] x2) {
        return ArrayUtils.l1norm(x2, false);
    }

    public static double l1norm(double[] x2, boolean skipLast) {
        double sum = 0.0;
        int last = x2.length - (skipLast ? 1 : 0);
        for (int i2 = 0; i2 < last; ++i2) {
            sum += x2[i2] >= 0.0 ? x2[i2] : -x2[i2];
        }
        return sum;
    }

    public static double rNorm(double[][] arr, char type) {
        double rnorm = Double.NEGATIVE_INFINITY;
        int numArr = arr.length;
        for (int rind = 0; rind < numArr; ++rind) {
            double tempSum = 0.0;
            for (int cind = 0; cind < numArr; ++cind) {
                tempSum += type == 'o' ? Math.abs(arr[rind][cind]) : Math.abs(arr[cind][rind]);
            }
            if (!(tempSum > rnorm)) continue;
            rnorm = tempSum;
        }
        return rnorm;
    }

    public static double linfnorm(double[] x2, boolean skipLast) {
        double res = Double.NEGATIVE_INFINITY;
        int last = x2.length - (skipLast ? 1 : 0);
        for (int i2 = 0; i2 < last; ++i2) {
            if (x2[i2] > res) {
                res = x2[i2];
            }
            if (!(-x2[i2] > res)) continue;
            res = -x2[i2];
        }
        return res;
    }

    public static double l2norm(double[] x2) {
        return Math.sqrt(ArrayUtils.l2norm2(x2));
    }

    public static double l2norm(double[] x2, boolean skipLast) {
        return Math.sqrt(ArrayUtils.l2norm2(x2, skipLast));
    }

    public static double l2norm(double[] x2, double[] y2) {
        return Math.sqrt(ArrayUtils.l2norm2(x2, y2));
    }

    public static double l2norm(double[][] x2, double[][] y2) {
        return Math.sqrt(ArrayUtils.l2norm2(x2, y2));
    }

    public static byte[] add(byte[] a2, byte[] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = (byte)(a2[n2] + b2[i2]);
        }
        return a2;
    }

    public static int[] add(int[] a2, int[] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] + b2[i2];
        }
        return a2;
    }

    public static int[][] add(int[][] a2, int[][] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static long[] add(long[] a2, long[] b2) {
        if (b2 == null) {
            return a2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] + b2[i2];
        }
        return a2;
    }

    public static long[][] add(long[][] a2, long[][] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static long[][][] add(long[][][] a2, long[][][] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static float[] add(float[] a2, float[] b2) {
        if (b2 == null) {
            return a2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] + b2[i2];
        }
        return a2;
    }

    public static float[] add(float ca, float[] a2, float cb, float[] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = ca * a2[i2] + cb * b2[i2];
        }
        return a2;
    }

    public static float[][] add(float[][] a2, float[][] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static boolean[] or(boolean[] a2, boolean[] b2) {
        if (b2 == null) {
            return a2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] | b2[i2];
        }
        return a2;
    }

    public static double[][] deepClone(double[][] ary) {
        double[][] res = (double[][])ary.clone();
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = (double[])ary[i2].clone();
        }
        return res;
    }

    public static <T extends Iced> T[][] deepClone(T[][] ary) {
        Iced[][] res = (Iced[][])ary.clone();
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = ArrayUtils.deepClone((Iced[])res[i2]);
        }
        return res;
    }

    public static <T extends Iced> T[] deepClone(T[] ary) {
        Iced[] res = (Iced[])ary.clone();
        for (int j2 = 0; j2 < res.length; ++j2) {
            if (res[j2] == null) continue;
            res[j2] = res[j2].clone();
        }
        return res;
    }

    public static double[] add(double[] a2, double[] b2) {
        if (a2 == null) {
            return b2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] + b2[i2];
        }
        return a2;
    }

    public static double[] add(double[] a2, double b2) {
        int i2 = 0;
        while (i2 < a2.length) {
            int n2 = i2++;
            a2[n2] = a2[n2] + b2;
        }
        return a2;
    }

    public static int[] add(int[] a2, int b2) {
        int i2 = 0;
        while (i2 < a2.length) {
            int n2 = i2++;
            a2[n2] = a2[n2] + b2;
        }
        return a2;
    }

    public static double[] wadd(double[] a2, double[] b2, double w2) {
        if (a2 == null) {
            return b2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            a2[n2] = a2[n2] + w2 * b2[i2];
        }
        return a2;
    }

    public static double[] wadd(double[] a2, double[] b2, double[] c2, double w2) {
        if (a2 == null) {
            return b2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            c2[i2] = a2[i2] + w2 * b2[i2];
        }
        return c2;
    }

    public static double[] add(double[] a2, double[] b2, double[] c2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = b2[i2] + c2[i2];
        }
        return a2;
    }

    public static double[][] add(double[][] a2, double[][] b2) {
        if (a2 == null) {
            return b2;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static double[][][] add(double[][][] a2, double[][][] b2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = ArrayUtils.add(a2[i2], b2[i2]);
        }
        return a2;
    }

    public static double avg(double[] nums) {
        double sum = 0.0;
        for (double n2 : nums) {
            sum += n2;
        }
        return sum / (double)nums.length;
    }

    public static double avg(long[] nums) {
        long sum = 0L;
        for (long n2 : nums) {
            sum += n2;
        }
        return sum / (long)nums.length;
    }

    public static long[] add(long[] nums, long a2) {
        int i2 = 0;
        while (i2 < nums.length) {
            int n2 = i2++;
            nums[n2] = nums[n2] + a2;
        }
        return nums;
    }

    public static float[] div(float[] nums, int n2) {
        int i2 = 0;
        while (i2 < nums.length) {
            int n3 = i2++;
            nums[n3] = nums[n3] / (float)n2;
        }
        return nums;
    }

    public static float[] div(float[] nums, float n2) {
        assert (!Float.isInfinite(n2)) : "Trying to divide " + Arrays.toString(nums) + " by  " + n2;
        int i2 = 0;
        while (i2 < nums.length) {
            int n3 = i2++;
            nums[n3] = nums[n3] / n2;
        }
        return nums;
    }

    public static double[] div(double[] nums, double n2) {
        assert (!Double.isInfinite(n2)) : "Trying to divide " + Arrays.toString(nums) + " by  " + n2;
        int i2 = 0;
        while (i2 < nums.length) {
            int n3 = i2++;
            nums[n3] = nums[n3] / n2;
        }
        return nums;
    }

    public static double[][] div(double[][] ds, long[] n2) {
        for (int i2 = 0; i2 < ds.length; ++i2) {
            ArrayUtils.div(ds[i2], (double)n2[i2]);
        }
        return ds;
    }

    public static double[][] div(double[][] ds, double[] n2) {
        for (int i2 = 0; i2 < ds.length; ++i2) {
            ArrayUtils.div(ds[i2], n2[i2]);
        }
        return ds;
    }

    public static double[] div(double[] ds, long[] n2) {
        for (int i2 = 0; i2 < ds.length; ++i2) {
            int n3 = i2;
            ds[n3] = ds[n3] / (double)n2[i2];
        }
        return ds;
    }

    public static double[] div(double[] ds, double[] n2) {
        for (int i2 = 0; i2 < ds.length; ++i2) {
            int n3 = i2;
            ds[n3] = ds[n3] / n2[i2];
        }
        return ds;
    }

    public static double[][] mult(double[][] ds, double[] n2) {
        for (int i2 = 0; i2 < ds.length; ++i2) {
            ArrayUtils.mult(ds[i2], n2[i2]);
        }
        return ds;
    }

    public static float[] mult(float[] nums, float n2) {
        int i2 = 0;
        while (i2 < nums.length) {
            int n3 = i2++;
            nums[n3] = nums[n3] * n2;
        }
        return nums;
    }

    public static double[] mult(double[] nums, double n2) {
        if (nums != null) {
            int i2 = 0;
            while (i2 < nums.length) {
                int n3 = i2++;
                nums[n3] = nums[n3] * n2;
            }
        }
        return nums;
    }

    public static double[][] mult(double[][] ary, double n2) {
        if (ary == null) {
            return null;
        }
        for (double[] row : ary) {
            ArrayUtils.mult(row, n2);
        }
        return ary;
    }

    public static double[] mult(double[] nums, double[] nums2) {
        for (int i2 = 0; i2 < nums.length; ++i2) {
            int n2 = i2;
            nums[n2] = nums[n2] * nums2[i2];
        }
        return nums;
    }

    public static double subAndMul(double[] data, double[] p2, double[] n2) {
        double res = 0.0;
        for (int col = 0; col < data.length; ++col) {
            res += (data[col] - p2[col]) * n2[col];
        }
        return res;
    }

    public static double[] invert(double[] ary) {
        if (ary == null) {
            return null;
        }
        for (int i2 = 0; i2 < ary.length; ++i2) {
            ary[i2] = 1.0 / ary[i2];
        }
        return ary;
    }

    public static double[] multArrVec(double[][] ary, double[] nums) {
        if (ary == null) {
            return null;
        }
        double[] res = new double[ary.length];
        return ArrayUtils.multArrVec(ary, nums, res);
    }

    public static double[] multArrVecPartial(double[][] ary, double[] nums, int[] numColInd) {
        if (ary == null) {
            return null;
        }
        double[] res = new double[ary.length];
        for (int ind = 0; ind < ary.length; ++ind) {
            res[ind] = ArrayUtils.innerProductPartial(nums, numColInd, ary[ind]);
        }
        return res;
    }

    public static double[] diagArray(double[][] ary) {
        if (ary == null) {
            return null;
        }
        int arraylen = ary.length;
        double[] res = new double[ary.length];
        for (int index = 0; index < arraylen; ++index) {
            res[index] = ary[index][index];
        }
        return res;
    }

    public static int locate(double[] arr, double val, double tol) {
        int arrLen = arr.length;
        for (int index = 0; index < arrLen; ++index) {
            if (!(Math.abs(arr[index] - val) < tol)) continue;
            return index;
        }
        return -1;
    }

    public static double[] multArrVec(double[][] ary, double[] nums, double[] res) {
        if (ary == null || nums == null) {
            return null;
        }
        assert (ary[0].length == nums.length) : "Inner dimensions must match: Got " + ary[0].length + " != " + nums.length;
        for (int i2 = 0; i2 < ary.length; ++i2) {
            res[i2] = ArrayUtils.innerProduct(ary[i2], nums);
        }
        return res;
    }

    public static double[] multVecArr(double[] nums, double[][] ary) {
        if (ary == null || nums == null) {
            return null;
        }
        assert (nums.length == ary.length) : "Inner dimensions must match: Got " + nums.length + " != " + ary.length;
        double[] res = new double[ary[0].length];
        for (int j2 = 0; j2 < ary[0].length; ++j2) {
            res[j2] = 0.0;
            for (int i2 = 0; i2 < ary.length; ++i2) {
                int n2 = j2;
                res[n2] = res[n2] + nums[i2] * ary[i2][j2];
            }
        }
        return res;
    }

    public static double[][] multArrArr(double[][] ary1, double[][] ary2, double[][] res) {
        if (ary1 == null || ary2 == null) {
            return null;
        }
        assert (ary1[0].length == ary2.length) : "Inner dimensions must match: Got " + ary1[0].length + " != " + ary2.length;
        for (int i2 = 0; i2 < ary1.length; ++i2) {
            for (int j2 = 0; j2 < ary2[0].length; ++j2) {
                double tmp = 0.0;
                for (int k2 = 0; k2 < ary1[0].length; ++k2) {
                    tmp += ary1[i2][k2] * ary2[k2][j2];
                }
                res[i2][j2] = tmp;
            }
        }
        return res;
    }

    public static double[][] multArrArr(double[][] ary1, double[][] ary2) {
        if (ary1 == null || ary2 == null) {
            return null;
        }
        double[][] res = new double[ary1.length][ary2[0].length];
        return ArrayUtils.multArrArr(ary1, ary2, res);
    }

    public static double[][] transpose(double[][] ary) {
        if (ary == null) {
            return null;
        }
        double[][] res = new double[ary[0].length][ary.length];
        for (int i2 = 0; i2 < res.length; ++i2) {
            for (int j2 = 0; j2 < res[0].length; ++j2) {
                res[i2][j2] = ary[j2][i2];
            }
        }
        return res;
    }

    public static double[][] expandArray(double[][] ary, int newColNum) {
        if (ary == null) {
            return null;
        }
        assert (ary.length < newColNum) : "new array should be greater than original array in second dimension.";
        int oldMatRow = ary.length;
        double[][] res = new double[newColNum][newColNum];
        for (int i2 = 0; i2 < oldMatRow; ++i2) {
            System.arraycopy(ary[i2], 0, res[i2], 0, oldMatRow);
        }
        return res;
    }

    public static double[][] transposeTriangular(double[][] ary, boolean upperTriangular) {
        if (ary == null) {
            return null;
        }
        int rowNums = ary.length;
        double[][] res = new double[ary.length][];
        for (int rowIndex = 0; rowIndex < rowNums; ++rowIndex) {
            int colNum = upperTriangular ? rowIndex + 1 : rowNums - rowIndex;
            res[rowIndex] = new double[colNum];
            for (int colIndex = 0; colIndex < colNum; ++colIndex) {
                res[rowIndex][colIndex] = ary[colIndex + rowIndex][rowIndex];
            }
        }
        return res;
    }

    public static <T> T[] cloneOrNull(T[] ary) {
        return ary == null ? null : (Object[])ary.clone();
    }

    public static <T> T[][] transpose(T[][] ary) {
        int i2;
        if (ary == null || ary.length == 0) {
            return ary;
        }
        Object[][] res = (Object[][])Arrays.copyOf(ary, ary[0].length);
        for (i2 = 0; i2 < res.length; ++i2) {
            res[i2] = Arrays.copyOf(ary[0], ary.length);
        }
        for (i2 = 0; i2 < res.length; ++i2) {
            for (int j2 = 0; j2 < res[0].length; ++j2) {
                res[i2][j2] = ary[j2][i2];
            }
        }
        return res;
    }

    public static int[] range(int start, int end) {
        int[] r2 = new int[end - start + 1];
        for (int i2 = 0; i2 < r2.length; ++i2) {
            r2[i2] = i2 + start;
        }
        return r2;
    }

    public static double[][] formGram(double[][] x2, boolean transpose) {
        int k2;
        int j2;
        int i2;
        if (x2 == null) {
            return null;
        }
        int dim_in = transpose ? x2[0].length : x2.length;
        int dim_out = transpose ? x2.length : x2[0].length;
        double[][] xgram = new double[dim_out][dim_out];
        if (transpose) {
            for (i2 = 0; i2 < dim_in; ++i2) {
                for (j2 = 0; j2 < dim_out; ++j2) {
                    for (k2 = j2; k2 < dim_out; ++k2) {
                        double[] dArray = xgram[j2];
                        int n2 = k2;
                        dArray[n2] = dArray[n2] + x2[j2][i2] * x2[k2][i2];
                    }
                }
            }
        } else {
            for (i2 = 0; i2 < dim_in; ++i2) {
                for (j2 = 0; j2 < dim_out; ++j2) {
                    for (k2 = j2; k2 < dim_out; ++k2) {
                        double[] dArray = xgram[j2];
                        int n3 = k2;
                        dArray[n3] = dArray[n3] + x2[i2][j2] * x2[i2][k2];
                    }
                }
            }
        }
        for (i2 = 0; i2 < dim_in; ++i2) {
            for (j2 = 0; j2 < dim_out; ++j2) {
                for (k2 = 0; k2 < j2; ++k2) {
                    xgram[j2][k2] = xgram[k2][j2];
                }
            }
        }
        return xgram;
    }

    public static double[][] formGram(double[][] x2) {
        return ArrayUtils.formGram(x2, false);
    }

    public static double[] permute(double[] vec, int[] idx) {
        if (vec == null) {
            return null;
        }
        assert (vec.length == idx.length) : "Length of vector must match permutation vector length: Got " + vec.length + " != " + idx.length;
        double[] res = new double[vec.length];
        for (int i2 = 0; i2 < vec.length; ++i2) {
            res[i2] = vec[idx[i2]];
        }
        return res;
    }

    public static double[][] permuteCols(double[][] ary, int[] idx) {
        if (ary == null) {
            return null;
        }
        assert (ary[0].length == idx.length) : "Number of columns must match permutation vector length: Got " + ary[0].length + " != " + idx.length;
        double[][] res = new double[ary.length][ary[0].length];
        for (int j2 = 0; j2 < ary[0].length; ++j2) {
            for (int i2 = 0; i2 < ary.length; ++i2) {
                res[i2][j2] = ary[i2][idx[j2]];
            }
        }
        return res;
    }

    public static double[][] permuteRows(double[][] ary, int[] idx) {
        if (ary == null) {
            return null;
        }
        assert (ary.length == idx.length) : "Number of rows must match permutation vector length: Got " + ary.length + " != " + idx.length;
        double[][] res = new double[ary.length][ary[0].length];
        for (int i2 = 0; i2 < ary.length; ++i2) {
            res[i2] = ArrayUtils.permute(ary[i2], idx);
        }
        return res;
    }

    public static double[][] generateLineSearchVecs(double[] srcVec, double[] gradient, int n2, double step) {
        double[][] res = new double[n2][];
        double x2 = step;
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = MemoryManager.malloc8d(srcVec.length);
            for (int j2 = 0; j2 < res[i2].length; ++j2) {
                res[i2][j2] = srcVec[j2] + gradient[j2] * x2;
            }
            x2 *= step;
        }
        return res;
    }

    public static String arrayToString(int[] ary) {
        if (ary == null || ary.length == 0) {
            return "";
        }
        int m4 = ary.length - 1;
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (true) {
            sb.append(ary[i2]);
            if (i2 == m4) {
                return sb.toString();
            }
            sb.append(", ");
            ++i2;
        }
    }

    public static String[] toString(long[] dom) {
        String[] result = new String[dom.length];
        for (int i2 = 0; i2 < dom.length; ++i2) {
            result[i2] = String.valueOf(dom[i2]);
        }
        return result;
    }

    public static String[] toString(int[] dom) {
        String[] result = new String[dom.length];
        for (int i2 = 0; i2 < dom.length; ++i2) {
            result[i2] = String.valueOf(dom[i2]);
        }
        return result;
    }

    public static String[] toString(Object[] ary) {
        String[] result = new String[ary.length];
        for (int i2 = 0; i2 < ary.length; ++i2) {
            Class<?> klazz;
            Object o2 = ary[i2];
            result[i2] = o2 != null && o2.getClass().isArray() ? (byte[].class.equals(klazz = ary[i2].getClass()) ? Arrays.toString((byte[])o2) : (short[].class.equals(klazz) ? Arrays.toString((short[])o2) : (int[].class.equals(klazz) ? Arrays.toString((int[])o2) : (long[].class.equals(klazz) ? Arrays.toString((long[])o2) : (boolean[].class.equals(klazz) ? Arrays.toString((boolean[])o2) : (float[].class.equals(klazz) ? Arrays.toString((float[])o2) : (double[].class.equals(klazz) ? Arrays.toString((double[])o2) : Arrays.toString((Object[])o2)))))))) : String.valueOf(o2);
        }
        return result;
    }

    public static String toStringQuotedElements(Object[] a2) {
        return ArrayUtils.toStringQuotedElements(a2, -1);
    }

    public static String toStringQuotedElements(Object[] a2, int maxItems) {
        if (a2 == null) {
            return "null";
        }
        if (a2.length == 0) {
            return "[]";
        }
        int max = a2.length;
        int ellipsisIdx = max + 1;
        if (maxItems > 0 && maxItems < a2.length) {
            max = maxItems + 1;
            ellipsisIdx = max / 2;
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        for (int i2 = 0; i2 < max; ++i2) {
            int idx;
            int n2 = i2 == ellipsisIdx ? -1 : (idx = i2 < ellipsisIdx ? i2 : a2.length - max + i2);
            if (idx >= 0) {
                b2.append('\"').append(a2[idx]).append('\"');
            } else {
                b2.append("...").append(a2.length - maxItems).append(" not listed...");
            }
            if (i2 >= max - 1) continue;
            b2.append(", ");
        }
        return b2.append(']').toString();
    }

    public static <T> boolean contains(T[] arr, T target) {
        if (null == arr) {
            return false;
        }
        for (T t2 : arr) {
            if (t2 == target) {
                return true;
            }
            if (t2 == null || !t2.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] a2, byte d2) {
        for (byte anA : a2) {
            if (anA != d2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] a2, int d2) {
        for (int anA : a2) {
            if (anA != d2) continue;
            return true;
        }
        return false;
    }

    public static byte[] subarray(byte[] a2, int off, int len) {
        return Arrays.copyOfRange(a2, off, off + len);
    }

    public static <T> T[] subarray(T[] a2, int off, int len) {
        return Arrays.copyOfRange(a2, off, off + len);
    }

    public static <T> T[][] subarray2DLazy(T[][] a2, int columnOffset, int len) {
        return (Object[][])Arrays.copyOfRange(a2, columnOffset, columnOffset + len);
    }

    public static int maxIndex(int[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] > from[result]) {
                result = i2;
                maxCount = 1;
                continue;
            }
            if (from[i2] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(float[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] > from[result]) {
                result = i2;
                maxCount = 1;
                continue;
            }
            if (from[i2] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(double[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] > from[result]) {
                result = i2;
                maxCount = 1;
                continue;
            }
            if (from[i2] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(int[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] <= from[result]) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(long[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] <= from[result]) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(long[] from, int off) {
        int result = off;
        for (int i2 = off + 1; i2 < from.length; ++i2) {
            if (from[i2] <= from[result]) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(float[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] > from[result])) continue;
            result = i2;
        }
        return result;
    }

    public static int maxIndex(double[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] > from[result])) continue;
            result = i2;
        }
        return result;
    }

    public static int minIndex(int[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] >= from[result]) continue;
            result = i2;
        }
        return result;
    }

    public static int minIndex(float[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] < from[result])) continue;
            result = i2;
        }
        return result;
    }

    public static int minIndex(double[] from) {
        int result = 0;
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] < from[result])) continue;
            result = i2;
        }
        return result;
    }

    public static double maxValue(double[] ary) {
        return ArrayUtils.maxValue(ary, 0, ary.length);
    }

    public static double maxValue(double[] ary, int from, int to) {
        double result = ary[from];
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (!(ary[i2] > result)) continue;
            result = ary[i2];
        }
        return result;
    }

    public static float maxValue(float[] ary) {
        return ArrayUtils.maxValue(ary, 0, ary.length);
    }

    public static float maxValue(float[] ary, int from, int to) {
        float result = ary[from];
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (!(ary[i2] > result)) continue;
            result = ary[i2];
        }
        return result;
    }

    public static float minValue(float[] from) {
        float result = from[0];
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (!(from[i2] < result)) continue;
            result = from[i2];
        }
        return result;
    }

    public static double minValue(double[] ary, int from, int to) {
        double result = ary[from];
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (!(ary[i2] < result)) continue;
            result = ary[i2];
        }
        return result;
    }

    public static double minValue(double[] from) {
        return Arrays.stream(from).min().getAsDouble();
    }

    public static double[] minMaxValue(double[] from) {
        double min2 = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i2 = 0; i2 < from.length; ++i2) {
            if (from[i2] < min2) {
                min2 = from[i2];
            }
            if (!(from[i2] > max)) continue;
            max = from[i2];
        }
        return new double[]{min2, max};
    }

    public static long maxValue(long[] from) {
        return Arrays.stream(from).max().getAsLong();
    }

    public static int maxValue(Integer[] from) {
        return Arrays.stream(from).max(Integer::compare).get();
    }

    public static int maxValue(int[] from) {
        return Arrays.stream(from).max().getAsInt();
    }

    public static long minValue(long[] from) {
        long result = from[0];
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] >= result) continue;
            result = from[i2];
        }
        return result;
    }

    public static long minValue(int[] from) {
        int result = from[0];
        for (int i2 = 1; i2 < from.length; ++i2) {
            if (from[i2] >= result) continue;
            result = from[i2];
        }
        return result;
    }

    public static <T> int find(T[] ts, T elem) {
        return ArrayUtils.find(ts, elem, 0);
    }

    public static <T> int find(T[] ts, T elem, int off) {
        for (int i2 = off; i2 < ts.length; ++i2) {
            if (elem != ts[i2] && !elem.equals(ts[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static int findWithPrefix(String[] array, String prefix) {
        return ArrayUtils.findWithPrefix(array, prefix, 0);
    }

    public static int findWithPrefix(String[] array, String prefix, int off) {
        for (int i2 = off; i2 < array.length; ++i2) {
            if (array[i2].equals(prefix)) {
                return i2;
            }
            if (!array[i2].startsWith(prefix)) continue;
            return -i2 - 2;
        }
        return -1;
    }

    public static int find(long[] ls, long elem) {
        for (int i2 = 0; i2 < ls.length; ++i2) {
            if (elem != ls[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int find(int[] ls, int elem) {
        for (int i2 = 0; i2 < ls.length; ++i2) {
            if (elem != ls[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int linearSearch(double[] vals, double v2) {
        int N2 = vals.length;
        for (int i2 = 0; i2 < N2; ++i2) {
            if (vals[i2] == v2) {
                return i2;
            }
            if (!(vals[i2] > v2)) continue;
            return -i2 - 1;
        }
        return -1;
    }

    public static String pprint(double[][] arr) {
        return ArrayUtils.pprint(arr, default_dformat);
    }

    public static String pprint(double[][] arr, DecimalFormat dformat) {
        String dStr;
        double d2;
        int c2;
        int colDim = 0;
        for (double[] line : arr) {
            colDim = Math.max(colDim, line.length);
        }
        StringBuilder sb = new StringBuilder();
        int max_width = 0;
        int[] ilengths = new int[colDim];
        Arrays.fill(ilengths, -1);
        for (double[] line : arr) {
            for (c2 = 0; c2 < line.length; ++c2) {
                d2 = line[c2];
                dStr = dformat.format(d2);
                if (dStr.indexOf(46) == -1) {
                    dStr = dStr + ".0";
                }
                ilengths[c2] = Math.max(ilengths[c2], dStr.indexOf(46));
                int prefix = d2 >= 0.0 ? 1 : 2;
                max_width = Math.max(dStr.length() + prefix, max_width);
            }
        }
        for (double[] line : arr) {
            for (c2 = 0; c2 < line.length; ++c2) {
                d2 = line[c2];
                dStr = dformat.format(d2);
                if (dStr.indexOf(46) == -1) {
                    dStr = dStr + ".0";
                }
                for (int x2 = dStr.indexOf(46); x2 < ilengths[c2] + 1; ++x2) {
                    sb.append(' ');
                }
                sb.append(dStr);
                if (dStr.indexOf(46) == -1) {
                    sb.append('.');
                }
                for (int i2 = dStr.length() - Math.max(0, dStr.indexOf(46)); i2 <= 5; ++i2) {
                    sb.append('0');
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int[] unpackInts(long ... longs) {
        int len = 2 * longs.length;
        int[] result = new int[len];
        int i2 = 0;
        for (long l2 : longs) {
            result[i2++] = (int)(l2 & 0xFFFFFFFFL);
            result[i2++] = (int)(l2 >> 32);
        }
        return result;
    }

    private static void swap(long[] a2, int i2, int change) {
        long helper = a2[i2];
        a2[i2] = a2[change];
        a2[change] = helper;
    }

    private static void swap(int[] a2, int i2, int change) {
        int helper = a2[i2];
        a2[i2] = a2[change];
        a2[change] = helper;
    }

    public static int[] shuffleArray(int[] a2, int n2, int[] result, long seed, int startIndex) {
        int i2;
        if (n2 <= 0) {
            return result;
        }
        RandomBase random = RandomUtils.getRNG(seed);
        if (result == null || result.length != n2) {
            result = new int[n2];
        }
        result[0] = a2[startIndex];
        for (i2 = 1; i2 < n2; ++i2) {
            int j2 = random.nextInt(i2 + 1);
            if (j2 != i2) {
                result[i2] = result[j2];
            }
            result[j2] = a2[startIndex + i2];
        }
        for (i2 = 0; i2 < n2; ++i2) {
            assert (ArrayUtils.contains(result, a2[startIndex + i2]));
        }
        return result;
    }

    public static void shuffleArray(int[] a2, Random rng) {
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int change = i2 + rng.nextInt(n2 - i2);
            ArrayUtils.swap(a2, i2, change);
        }
    }

    public static long[] distinctLongs(int n2, long bound, Random rng) {
        if ((long)n2 > bound) {
            throw new IllegalArgumentException("argument bound (=" + bound + ") needs to be lower or equal to n (=" + n2 + ")");
        }
        if (!(rng instanceof RandomBase)) {
            throw new IllegalArgumentException("Random implementation needs to be created by RandomUtils and inherit from RandomBase");
        }
        HashSet<Long> rows = new HashSet<Long>();
        while (rows.size() < n2) {
            rows.add(((RandomBase)rng).nextLong(bound));
        }
        return rows.stream().sorted().mapToLong(Long::longValue).toArray();
    }

    public static double[][] gaussianArray(int n2, int m4) {
        return ArrayUtils.gaussianArray(n2, m4, System.currentTimeMillis());
    }

    public static double[][] gaussianArray(int n2, int m4, long seed) {
        if (n2 <= 0 || m4 <= 0) {
            return null;
        }
        double[][] result = new double[n2][m4];
        RandomBase random = RandomUtils.getRNG(seed);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int j2 = 0; j2 < m4; ++j2) {
                result[i2][j2] = random.nextGaussian();
            }
        }
        return result;
    }

    public static double[] gaussianVector(int n2) {
        return ArrayUtils.gaussianVector(n2, System.currentTimeMillis());
    }

    public static double[] gaussianVector(int n2, long seed) {
        return ArrayUtils.gaussianVector(n2, RandomUtils.getRNG(seed));
    }

    public static double[] gaussianVector(int n2, Random random) {
        if (n2 <= 0) {
            return null;
        }
        double[] result = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = random.nextGaussian();
        }
        return result;
    }

    public static double[] gaussianVector(long seed, double[] vseed) {
        if (vseed == null) {
            return null;
        }
        RandomBase random = RandomUtils.getRNG(seed);
        int arraySize = vseed.length;
        for (int i2 = 0; i2 < arraySize; ++i2) {
            vseed[i2] = random.nextGaussian();
        }
        return vseed;
    }

    public static int numInts(String ... a2) {
        int cnt = 0;
        for (String s2 : a2) {
            if (!ArrayUtils.isInt(s2)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static boolean isInt(String ... ary) {
        for (String s2 : ary) {
            int i2;
            if (s2 == null || s2.isEmpty()) {
                return false;
            }
            int n2 = i2 = s2.charAt(0) == '-' ? 1 : 0;
            while (i2 < s2.length()) {
                if (!Character.isDigit(s2.charAt(i2))) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    public static int[] toInt(String[] a2, int off, int len) {
        int[] res = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = Integer.valueOf(a2[off + i2]);
        }
        return res;
    }

    public static Integer[] toIntegers(int[] a2, int off, int len) {
        Integer[] res = new Integer[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = a2[off + i2];
        }
        return res;
    }

    public static int[] toInt(Integer[] a2, int off, int len) {
        int[] res = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = a2[off + i2];
        }
        return res;
    }

    public static String[] domainUnion(String[] a2, String[] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        int cIinA = ArrayUtils.numInts(a2);
        int cIinB = ArrayUtils.numInts(b2);
        if (cIinA == 0 && cIinB == 0 || cIinA == a2.length && cIinB == b2.length) {
            return ArrayUtils.union(a2, b2, cIinA == 0);
        }
        int[] ai = ArrayUtils.toInt(a2, 0, cIinA);
        Arrays.sort(ai);
        int[] bi = ArrayUtils.toInt(b2, 0, cIinB);
        Arrays.sort(bi);
        String[] ri = ArrayUtils.toString(ArrayUtils.union(ai, bi));
        String[] si = ArrayUtils.union(a2, b2, cIinA, a2.length - cIinA, cIinB, b2.length - cIinB, true);
        return ArrayUtils.join(ri, si);
    }

    public static String[] union(String[] a2, String[] b2, boolean lexo) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        return ArrayUtils.union(a2, b2, 0, a2.length, 0, b2.length, lexo);
    }

    public static String[] union(String[] a2, String[] b2, int aoff, int alen, int boff, int blen, boolean lexo) {
        assert (a2 != null && b2 != null) : "Union expect non-null input!";
        String[] r2 = new String[alen + blen];
        int ia = aoff;
        int ib = boff;
        int i2 = 0;
        while (ia < aoff + alen && ib < boff + blen) {
            int c2;
            int n2 = c2 = lexo ? a2[ia].compareTo(b2[ib]) : Integer.valueOf(a2[ia]).compareTo(Integer.valueOf(b2[ib]));
            if (c2 < 0) {
                r2[i2++] = a2[ia++];
                continue;
            }
            if (c2 == 0) {
                r2[i2++] = a2[ia++];
                ++ib;
                continue;
            }
            r2[i2++] = b2[ib++];
        }
        if (ia < aoff + alen) {
            while (ia < aoff + alen) {
                r2[i2++] = a2[ia++];
            }
        }
        if (ib < boff + blen) {
            while (ib < boff + blen) {
                r2[i2++] = b2[ib++];
            }
        }
        return Arrays.copyOf(r2, i2);
    }

    public static int[] union(int[] a2, int[] b2) {
        assert (a2 != null && b2 != null) : "Union expect non-null input!";
        int[] r2 = new int[a2.length + b2.length];
        int ia = 0;
        int ib = 0;
        int i2 = 0;
        while (ia < a2.length && ib < b2.length) {
            int c2 = a2[ia] - b2[ib];
            if (c2 < 0) {
                r2[i2++] = a2[ia++];
                continue;
            }
            if (c2 == 0) {
                r2[i2++] = a2[ia++];
                ++ib;
                continue;
            }
            r2[i2++] = b2[ib++];
        }
        if (ia < a2.length) {
            while (ia < a2.length) {
                r2[i2++] = a2[ia++];
            }
        }
        if (ib < b2.length) {
            while (ib < b2.length) {
                r2[i2++] = b2[ib++];
            }
        }
        return Arrays.copyOf(r2, i2);
    }

    public static long[] join(long[] a2, long[] b2) {
        long[] res = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, res, a2.length, b2.length);
        return res;
    }

    public static float[] join(float[] a2, float[] b2) {
        float[] res = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, res, a2.length, b2.length);
        return res;
    }

    public static <T> T[] join(T[] a2, T[] b2) {
        T[] res = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, res, a2.length, b2.length);
        return res;
    }

    public static boolean hasNaNsOrInfs(double[] ary) {
        for (double d2 : ary) {
            if (!Double.isNaN(d2) && !Double.isInfinite(d2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaNs(double[] ary) {
        for (double d2 : ary) {
            if (!Double.isNaN(d2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaNsOrInfs(float[] ary) {
        for (float d2 : ary) {
            if (!Double.isNaN(d2) && !Double.isInfinite(d2)) continue;
            return true;
        }
        return false;
    }

    public static int[] seq(int start, int stop) {
        assert (start < stop);
        int len = stop - start;
        int[] res = new int[len];
        for (int i2 = start; i2 < stop; ++i2) {
            res[i2 - start] = i2;
        }
        return res;
    }

    public static int[] difference(int[] a2, int[] b2) {
        if (a2 == null) {
            return new int[0];
        }
        if (b2 == null) {
            return (int[])a2.clone();
        }
        int[] r2 = new int[a2.length];
        int cnt = 0;
        for (int x2 : a2) {
            if (ArrayUtils.contains(b2, x2)) continue;
            r2[cnt++] = x2;
        }
        return Arrays.copyOf(r2, cnt);
    }

    public static String[] difference(String[] a2, String[] b2) {
        if (a2 == null) {
            return new String[0];
        }
        if (b2 == null) {
            return (String[])a2.clone();
        }
        String[] r2 = new String[a2.length];
        int cnt = 0;
        for (String s2 : a2) {
            if (ArrayUtils.contains(b2, s2)) continue;
            r2[cnt++] = s2;
        }
        return Arrays.copyOf(r2, cnt);
    }

    public static double[][] append(double[][] a2, double[][] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        assert (a2[0].length == b2[0].length);
        double[][] c2 = (double[][])Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static byte[] append(byte[] a2, byte ... b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        byte[] c2 = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static int[] append(int[] a2, int[] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        int[] c2 = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static long[] append(long[] a2, long[] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        long[] c2 = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static double[] append(double[] a2, double[] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        double[] c2 = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static String[] append(String[] a2, String[] b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        String[] c2 = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static <T> T[] append(T[] a2, T ... b2) {
        if (a2 == null) {
            return b2;
        }
        T[] tmp = Arrays.copyOf(a2, a2.length + b2.length);
        System.arraycopy(b2, 0, tmp, a2.length, b2.length);
        return tmp;
    }

    public static int[] append(int[] a2, int b2) {
        if (a2 == null || a2.length == 0) {
            return new int[]{b2};
        }
        int[] tmp = Arrays.copyOf(a2, a2.length + 1);
        tmp[a2.length] = b2;
        return tmp;
    }

    public static double[] append(double[] a2, double b2) {
        if (a2 == null || a2.length == 0) {
            return new double[]{b2};
        }
        double[] tmp = Arrays.copyOf(a2, a2.length + 1);
        tmp[a2.length] = b2;
        return tmp;
    }

    public static String[] prepend(String[] ary, String s2) {
        if (ary == null) {
            return new String[]{s2};
        }
        String[] nary = new String[ary.length + 1];
        nary[0] = s2;
        System.arraycopy(ary, 0, nary, 1, ary.length);
        return nary;
    }

    public static <T> T[] copyAndFillOf(T[] original, int newLength, T padding) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        Object[] newArray = Arrays.copyOf(original, newLength);
        if (original.length < newLength) {
            System.arraycopy(original, 0, newArray, 0, original.length);
            Arrays.fill(newArray, original.length, newArray.length, padding);
        } else {
            System.arraycopy(original, 0, newArray, 0, newLength);
        }
        return newArray;
    }

    public static double[] copyAndFillOf(double[] original, int newLength, double padding) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        double[] newArray = new double[newLength];
        if (original.length < newLength) {
            System.arraycopy(original, 0, newArray, 0, original.length);
            Arrays.fill(newArray, original.length, newArray.length, padding);
        } else {
            System.arraycopy(original, 0, newArray, 0, newLength);
        }
        return newArray;
    }

    public static long[] copyAndFillOf(long[] original, int newLength, long padding) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        long[] newArray = new long[newLength];
        if (original.length < newLength) {
            System.arraycopy(original, 0, newArray, 0, original.length);
            Arrays.fill(newArray, original.length, newArray.length, padding);
        } else {
            System.arraycopy(original, 0, newArray, 0, newLength);
        }
        return newArray;
    }

    public static int[] copyAndFillOf(int[] original, int newLength, int padding) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        int[] newArray = new int[newLength];
        if (original.length < newLength) {
            System.arraycopy(original, 0, newArray, 0, original.length);
            Arrays.fill(newArray, original.length, newArray.length, padding);
        } else {
            System.arraycopy(original, 0, newArray, 0, newLength);
        }
        return newArray;
    }

    public static double[] copyFromIntArray(int[] a2) {
        double[] da = new double[a2.length];
        for (int i2 = 0; i2 < a2.length; ++i2) {
            da[i2] = a2[i2];
        }
        return da;
    }

    public static int[] sortedMerge(int[] a2, int[] b2) {
        int[] c2 = MemoryManager.malloc4(a2.length + b2.length);
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < c2.length; ++k2) {
            c2[k2] = i2 == a2.length ? b2[j2++] : (j2 == b2.length ? a2[i2++] : (b2[j2] < a2[i2] ? b2[j2++] : a2[i2++]));
        }
        return c2;
    }

    public static double[] sortedMerge(double[] a2, double[] b2) {
        double[] c2 = MemoryManager.malloc8d(a2.length + b2.length);
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < c2.length; ++k2) {
            c2[k2] = i2 == a2.length ? b2[j2++] : (j2 == b2.length ? a2[i2++] : (b2[j2] < a2[i2] ? b2[j2++] : a2[i2++]));
        }
        return c2;
    }

    public static void sortedMerge(int[] aIds, double[] aVals, int[] bIds, double[] bVals, int[] resIds, double[] resVals) {
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < resIds.length; ++k2) {
            if (i2 == aIds.length) {
                System.arraycopy(bIds, j2, resIds, k2, resIds.length - k2);
                System.arraycopy(bVals, j2, resVals, k2, resVals.length - k2);
                j2 = bIds.length;
                break;
            }
            if (j2 == bIds.length) {
                System.arraycopy(aIds, i2, resIds, k2, resIds.length - k2);
                System.arraycopy(aVals, i2, resVals, k2, resVals.length - k2);
                i2 = aIds.length;
                break;
            }
            if (aIds[i2] > bIds[j2]) {
                resIds[k2] = bIds[j2];
                resVals[k2] = bVals[j2];
                ++j2;
                continue;
            }
            resIds[k2] = aIds[i2];
            resVals[k2] = aVals[i2];
            ++i2;
        }
        assert (i2 == aIds.length && j2 == bIds.length);
    }

    public static String[] select(String[] ary, int[] idxs) {
        String[] res = new String[idxs.length];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = ary[idxs[i2]];
        }
        return res;
    }

    public static String[] select(String[] ary, byte[] idxs) {
        String[] res = new String[idxs.length];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = ary[idxs[i2]];
        }
        return res;
    }

    public static double[] select(double[] ary, int[] idxs) {
        double[] res = MemoryManager.malloc8d(idxs.length);
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = ary[idxs[i2]];
        }
        return res;
    }

    public static int[] select(int[] ary, int[] idxs) {
        int[] res = MemoryManager.malloc4(idxs.length);
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = ary[idxs[i2]];
        }
        return res;
    }

    public static byte[] select(byte[] array, int[] idxs) {
        byte[] res = MemoryManager.malloc1(idxs.length);
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = array[idxs[i2]];
        }
        return res;
    }

    public static double[] expandAndScatter(double[] ary, int N2, int[] ids) {
        assert (ary.length == ids.length) : "ary.length = " + ary.length + " != " + ids.length + " = ids.length";
        double[] res = MemoryManager.malloc8d(N2);
        for (int i2 = 0; i2 < ids.length; ++i2) {
            res[ids[i2]] = ary[i2];
        }
        return res;
    }

    public static void sort(int[] idxs, double[] values) {
        ArrayUtils.sort(idxs, values, 500, 1);
    }

    public static void sort(int[] idxs, double[] values, int cutoff) {
        ArrayUtils.sort(idxs, values, cutoff, 1);
    }

    public static void sort(int[] idxs, final double[] values, int cutoff, final int increasing) {
        if (idxs.length < cutoff) {
            for (int i2 = 0; i2 < idxs.length; ++i2) {
                for (int j2 = i2; j2 > 0 && values[idxs[j2 - 1]] * (double)increasing > values[idxs[j2]] * (double)increasing; --j2) {
                    int tmp = idxs[j2];
                    idxs[j2] = idxs[j2 - 1];
                    idxs[j2 - 1] = tmp;
                }
            }
        } else {
            int i3;
            Integer[] d2 = new Integer[idxs.length];
            for (i3 = 0; i3 < idxs.length; ++i3) {
                d2[i3] = idxs[i3];
            }
            Arrays.sort(d2, new Comparator<Integer>(){

                @Override
                public int compare(Integer x2, Integer y2) {
                    return values[x2] * (double)increasing < values[y2] * (double)increasing ? -1 : (values[x2] * (double)increasing > values[y2] * (double)increasing ? 1 : 0);
                }
            });
            for (i3 = 0; i3 < idxs.length; ++i3) {
                idxs[i3] = d2[i3];
            }
        }
    }

    public static double[] subtract(double[] a2, double[] b2) {
        double[] c2 = MemoryManager.malloc8d(a2.length);
        ArrayUtils.subtract(a2, b2, c2);
        return c2;
    }

    public static double[][] subtract(double[][] a2, double[][] b2) {
        double[][] c2 = MemoryManager.malloc8d(a2.length, a2[0].length);
        for (int rowIndex = 0; rowIndex < c2.length; ++rowIndex) {
            c2[rowIndex] = ArrayUtils.subtract(a2[rowIndex], b2[rowIndex], c2[rowIndex]);
        }
        return c2;
    }

    public static int[] subtract(int[] a2, int[] b2) {
        int[] c2 = MemoryManager.malloc4(a2.length);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            c2[i2] = a2[i2] - b2[i2];
        }
        return c2;
    }

    public static double[] subtract(double[] a2, double[] b2, double[] c2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            c2[i2] = a2[i2] - b2[i2];
        }
        return c2;
    }

    public static <T> T[] flat(T[][] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return null;
        }
        int tlen = 0;
        for (T[] t2 : arr) {
            tlen += t2 != null ? t2.length : 0;
        }
        T[] result = Arrays.copyOf(arr[0], tlen);
        int j2 = arr[0].length;
        for (int i2 = 1; i2 < arr.length; ++i2) {
            if (arr[i2] == null) continue;
            System.arraycopy(arr[i2], 0, result, j2, arr[i2].length);
            j2 += arr[i2].length;
        }
        return result;
    }

    public static double[][] convertTo2DMatrix(double[] x2, int N2) {
        assert (x2.length % N2 == 0) : "number of coefficient should be divisible by number of coefficients per class ";
        int len = x2.length / N2;
        double[][] res = new double[len][];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = MemoryManager.malloc8d(N2);
            System.arraycopy(x2, i2 * N2, res[i2], 0, N2);
        }
        return res;
    }

    public static Object[][] zip(Object[] a2, Object[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Cannot zip arrays of different lengths!");
        }
        Object[][] result = new Object[a2.length][2];
        for (int i2 = 0; i2 < a2.length; ++i2) {
            result[i2][0] = a2[i2];
            result[i2][1] = b2[i2];
        }
        return result;
    }

    public static <K, V> int crossProductSize(Map<K, V[]> hyperSpace) {
        int size = 1;
        for (Map.Entry<K, V[]> entry : hyperSpace.entrySet()) {
            V[] value = entry.getValue();
            size *= value != null ? value.length : 1;
        }
        return size;
    }

    public static Integer[] interval(Integer start, Integer end) {
        return ArrayUtils.interval(start, end, 1);
    }

    public static Integer[] interval(Integer start, Integer end, Integer step) {
        int len = 1 + (end - start) / step;
        Integer[] result = new Integer[len];
        int i2 = 0;
        int value = start;
        while (i2 < len) {
            result[i2] = value;
            ++i2;
            value += step.intValue();
        }
        return result;
    }

    public static Float[] interval(Float start, Float end, Float step) {
        int len = 1 + (int)((end.floatValue() - start.floatValue()) / step.floatValue());
        Float[] result = new Float[len];
        Float value = start;
        int i2 = 0;
        while (i2 < len) {
            result[i2] = value;
            value = Float.valueOf(start.floatValue() + (float)(++i2) * step.floatValue());
        }
        return result;
    }

    public static Double[] interval(Double start, Double end, Double step) {
        int len = 1 + (int)((end - start) / step);
        Double[] result = new Double[len];
        Double value = start;
        int i2 = 0;
        while (i2 < len) {
            result[i2] = value;
            value = start + (double)(++i2) * step;
        }
        return result;
    }

    public static String[] remove(String[] ary, String s2) {
        if (s2 == null) {
            return ary;
        }
        int cnt = 0;
        int idx = ArrayUtils.find(ary, s2);
        while (idx >= 0) {
            ++cnt;
            ++idx;
            idx = ArrayUtils.find(ary, s2, idx);
        }
        if (cnt == 0) {
            return ary;
        }
        String[] res = new String[ary.length - cnt];
        int j2 = 0;
        for (String x2 : ary) {
            if (x2.equals(s2)) continue;
            res[j2++] = x2;
        }
        return res;
    }

    public static int[] sorted_set_diff(int[] x2, int[] y2) {
        assert (ArrayUtils.isSorted(x2));
        assert (ArrayUtils.isSorted(y2));
        int[] res = new int[x2.length];
        int j2 = 0;
        int k2 = 0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            while (j2 < y2.length && y2[j2] < x2[i2]) {
                ++j2;
            }
            if (j2 != y2.length && y2[j2] == x2[i2]) continue;
            res[k2++] = x2[i2];
        }
        return Arrays.copyOf(res, k2);
    }

    public static Frame frame(Key<Frame> key, String[] names, double[] ... rows) {
        assert (names == null || names.length == rows[0].length);
        Futures fs = new Futures();
        Vec[] vecs = new Vec[rows[0].length];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(vecs.length);
        int rowLayout = -1;
        for (int c2 = 0; c2 < vecs.length; ++c2) {
            AppendableVec vec = new AppendableVec(keys[c2], 3);
            NewChunk chunk = new NewChunk(vec, 0);
            for (double[] row : rows) {
                chunk.addNum(row[c2]);
            }
            chunk.close(0, fs);
            if (rowLayout == -1) {
                rowLayout = vec.compute_rowLayout();
            }
            vecs[c2] = vec.close(rowLayout, fs);
        }
        fs.blockForPending();
        Frame fr = new Frame(key, names, vecs);
        if (key != null) {
            DKV.put(key, fr);
        }
        return fr;
    }

    public static Frame frame(double[] ... rows) {
        return ArrayUtils.frame(null, rows);
    }

    public static Frame frame(String[] names, double[] ... rows) {
        return ArrayUtils.frame(Key.make(), names, rows);
    }

    public static Frame frame(String name, Vec vec) {
        Frame f2 = new Frame(new Vec[0]);
        f2.add(name, vec);
        return f2;
    }

    public static int[] removeSorted(int[] a2, int[] b2) {
        int[] indeces = new int[b2.length];
        indeces[0] = Arrays.binarySearch(a2, 0, a2.length, b2[0]);
        if (indeces[0] < 0) {
            throw new NoSuchElementException("value " + b2[0] + " not found in the first array.");
        }
        for (int i2 = 1; i2 < b2.length; ++i2) {
            indeces[i2] = Arrays.binarySearch(a2, indeces[i2 - 1], a2.length, b2[i2]);
            if (indeces[i2] >= 0) continue;
            throw new NoSuchElementException("value " + b2[i2] + " not found in the first array.");
        }
        return ArrayUtils.removeIds(a2, indeces);
    }

    public static int[] removeIds(int[] x2, int[] ids) {
        int[] res = new int[x2.length - ids.length];
        int j2 = 0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (j2 == ids.length || i2 != ids[j2]) {
                res[i2 - j2] = x2[i2];
                continue;
            }
            ++j2;
        }
        return res;
    }

    public static double[] removeIds(double[] x2, int[] ids) {
        double[] res = new double[x2.length - ids.length];
        int j2 = 0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (j2 == ids.length || i2 != ids[j2]) {
                res[i2 - j2] = x2[i2];
                continue;
            }
            ++j2;
        }
        return res;
    }

    public static boolean hasNzs(double[] x2) {
        if (x2 == null) {
            return false;
        }
        for (double d2 : x2) {
            if (d2 == 0.0) continue;
            return true;
        }
        return false;
    }

    public static int countNonzeros(double[] beta) {
        int res = 0;
        for (double d2 : beta) {
            if (d2 == 0.0) continue;
            ++res;
        }
        return res;
    }

    public static long[] subtract(long n2, long[] nums) {
        for (int i2 = 0; i2 < nums.length; ++i2) {
            nums[i2] = n2 - nums[i2];
        }
        return nums;
    }

    public static <T> T[] remove(T[] ary, int id) {
        if (id < 0 || id >= ary.length) {
            return Arrays.copyOf(ary, ary.length);
        }
        if (id == ary.length - 1) {
            return Arrays.copyOf(ary, id);
        }
        if (id == 0) {
            return Arrays.copyOfRange(ary, 1, ary.length);
        }
        return ArrayUtils.append(Arrays.copyOf(ary, id), Arrays.copyOfRange(ary, id + 1, ary.length));
    }

    public static byte[] remove(byte[] ary, int id) {
        if (id < 0 || id >= ary.length) {
            return Arrays.copyOf(ary, ary.length);
        }
        if (id == ary.length - 1) {
            return Arrays.copyOf(ary, id);
        }
        if (id == 0) {
            return Arrays.copyOfRange(ary, 1, ary.length);
        }
        return ArrayUtils.append(Arrays.copyOf(ary, id), Arrays.copyOfRange(ary, id + 1, ary.length));
    }

    public static int[] remove(int[] ary, int id) {
        if (id < 0 || id >= ary.length) {
            return Arrays.copyOf(ary, ary.length);
        }
        if (id == ary.length - 1) {
            return Arrays.copyOf(ary, id);
        }
        if (id == 0) {
            return Arrays.copyOfRange(ary, 1, ary.length);
        }
        return ArrayUtils.append(Arrays.copyOf(ary, id), Arrays.copyOfRange(ary, id + 1, ary.length));
    }

    public static long[] remove(long[] ary, int id) {
        if (id < 0 || id >= ary.length) {
            return Arrays.copyOf(ary, ary.length);
        }
        if (id == ary.length - 1) {
            return Arrays.copyOf(ary, id);
        }
        if (id == 0) {
            return Arrays.copyOfRange(ary, 1, ary.length);
        }
        return ArrayUtils.append(Arrays.copyOf(ary, id), Arrays.copyOfRange(ary, id + 1, ary.length));
    }

    public static double[] padUniformly(double[] origPoints, int newLength) {
        int origLength = origPoints.length;
        if (newLength <= origLength || origLength <= 1) {
            return origPoints;
        }
        int extraPoints = newLength - origLength;
        int extraPointsPerBin = extraPoints / (origLength - 1);
        double[] res = new double[newLength];
        int pos = 0;
        int rem = extraPoints - extraPointsPerBin * (origLength - 1);
        for (int i2 = 0; i2 < origLength - 1; ++i2) {
            double startPos = origPoints[i2];
            double delta = origPoints[i2 + 1] - startPos;
            int ext = extraPointsPerBin + (i2 < rem ? 1 : 0);
            res[pos++] = startPos;
            for (int j2 = 0; j2 < ext; ++j2) {
                res[pos++] = startPos + ((double)j2 + 0.5) / (double)ext * delta;
            }
        }
        res[pos] = origPoints[origLength - 1];
        return res;
    }

    public static double[] makeUniqueAndLimitToRange(double[] splitPoints, double min2, double maxEx) {
        double last = splitPoints[0];
        double[] uniqueValidPoints = new double[splitPoints.length + 2];
        int count2 = 0;
        for (int i2 = 0; i2 < splitPoints.length; ++i2) {
            double pos = splitPoints[i2];
            if (pos >= min2 && count2 == 0) {
                uniqueValidPoints[count2++] = min2;
                if (pos > min2) {
                    uniqueValidPoints[count2++] = pos;
                }
                last = pos;
                continue;
            }
            if (pos > maxEx) break;
            if (!(pos > min2) || !(pos < maxEx) || i2 != 0 && pos == last) continue;
            uniqueValidPoints[count2++] = pos;
            last = pos;
        }
        if (count2 == 0) {
            return new double[]{min2};
        }
        return Arrays.copyOfRange(uniqueValidPoints, 0, count2);
    }

    public static double[] limitToRange(double[] sortedSplitPoints, double min2, double maxEx) {
        int start = Arrays.binarySearch(sortedSplitPoints, min2);
        if (start < 0) {
            start = -start - 1;
        }
        if (start == sortedSplitPoints.length) {
            --start;
        }
        if (sortedSplitPoints[start] > min2 && start > 0) {
            --start;
        }
        assert (start >= 0);
        assert (sortedSplitPoints[start] <= min2);
        int end = Arrays.binarySearch(sortedSplitPoints, maxEx);
        if (end < 0) {
            end = -end - 1;
        }
        assert (end > 0 && end <= sortedSplitPoints.length) : "End index (" + end + ") should be > 0 and <= split points size (" + sortedSplitPoints.length + "). " + ArrayUtils.collectArrayInfo(sortedSplitPoints);
        assert (end >= start) : "End index (" + end + ") should be >= start index (" + start + "). " + ArrayUtils.collectArrayInfo(sortedSplitPoints);
        assert (sortedSplitPoints[end - 1] < maxEx) : "Split valued at index end-1 (" + sortedSplitPoints[end - 1] + ") should be < maxEx value (" + maxEx + "). " + ArrayUtils.collectArrayInfo(sortedSplitPoints);
        return Arrays.copyOfRange(sortedSplitPoints, start, end);
    }

    private static String collectArrayInfo(double[] array) {
        StringBuilder info = new StringBuilder("Array info - length: " + array.length + " values: ");
        for (double value : array) {
            info.append(value + " ");
        }
        return info.toString();
    }

    public static double[] extractCol(int i2, double[][] ary) {
        double[] res = new double[ary.length];
        for (int j2 = 0; j2 < ary.length; ++j2) {
            res[j2] = ary[j2][i2];
        }
        return res;
    }

    public static long encodeAsLong(byte[] b2) {
        return ArrayUtils.encodeAsLong(b2, 0, b2.length);
    }

    public static long encodeAsLong(byte[] b2, int off, int len) {
        assert (len <= 8) : "Cannot encode more then 8 bytes into long: len = " + len;
        long r2 = 0L;
        int shift = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            r2 |= ((long)b2[i2 + off] & 0xFFL) << shift;
            shift += 8;
        }
        return r2;
    }

    public static int encodeAsInt(byte[] b2) {
        assert (b2.length == 4) : "Cannot encode more than 4 bytes into int: len = " + b2.length;
        return (b2[0] & 0xFF) + ((b2[1] & 0xFF) << 8) + ((b2[2] & 0xFF) << 16) + ((b2[3] & 0xFF) << 24);
    }

    public static int encodeAsInt(byte[] bs, int at) {
        if (at + 4 > bs.length) {
            throw new IndexOutOfBoundsException("Cannot encode more than 4 bytes into int: len = " + bs.length + ", pos=" + at);
        }
        return (bs[at] & 0xFF) + ((bs[at + 1] & 0xFF) << 8) + ((bs[at + 2] & 0xFF) << 16) + ((bs[at + 3] & 0xFF) << 24);
    }

    public static byte[] decodeAsInt(int what, byte[] bs, int at) {
        if (bs.length < at + 4) {
            throw new IndexOutOfBoundsException("Wrong position " + at + ", array length is " + bs.length);
        }
        for (int i2 = at; i2 < at + 4 && i2 < bs.length; ++i2) {
            bs[i2] = (byte)(what & 0xFF);
            what >>= 8;
        }
        return bs;
    }

    public static byte[] toByteArray(long ... nums) {
        if (nums == null || nums.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[8 * nums.length];
        int c2 = 0;
        for (long n2 : nums) {
            for (int i2 = 0; i2 < 8; ++i2) {
                result[c2 * 8 + i2] = (byte)(n2 >>> 56 - 8 * i2 & 0xFFL);
            }
            ++c2;
        }
        return result;
    }

    public static byte[] toByteArray(int[] ary) {
        byte[] r2 = new byte[ary.length];
        for (int i2 = 0; i2 < ary.length; ++i2) {
            r2[i2] = (byte)(ary[i2] & 0xFF);
        }
        return r2;
    }

    public static boolean equalsAny(long value, long ... lhs) {
        if (lhs == null || lhs.length == 0) {
            return false;
        }
        for (long lhValue : lhs) {
            if (value != lhValue) continue;
            return true;
        }
        return false;
    }

    public static Character[] box(char[] arr) {
        Character[] res = new Character[arr.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            res[i2] = Character.valueOf(arr[i2]);
        }
        return res;
    }

    public static int[] toPrimitive(ArrayList<Integer> arr) {
        int[] res = new int[arr.size()];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = arr.get(i2);
        }
        return res;
    }

    public static boolean isSorted(int[] vals) {
        for (int i2 = 1; i2 < vals.length; ++i2) {
            if (vals[i2 - 1] <= vals[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(double[] vals) {
        for (int i2 = 1; i2 < vals.length; ++i2) {
            if (!(vals[i2 - 1] > vals[i2])) continue;
            return false;
        }
        return true;
    }

    public static byte[] constAry(int len, byte b2) {
        byte[] ary = new byte[len];
        Arrays.fill(ary, b2);
        return ary;
    }

    public static double[] constAry(int len, double c2) {
        double[] ary = new double[len];
        Arrays.fill(ary, c2);
        return ary;
    }

    public static double[] toDouble(float[] floats) {
        if (floats == null) {
            return null;
        }
        double[] ary = new double[floats.length];
        for (int i2 = 0; i2 < floats.length; ++i2) {
            ary[i2] = floats[i2];
        }
        return ary;
    }

    public static double[] toDouble(int[] ints) {
        if (ints == null) {
            return null;
        }
        double[] ary = new double[ints.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ary[i2] = ints[i2];
        }
        return ary;
    }

    public static boolean isInstance(Object object, Class[] comparedClasses) {
        for (Class c2 : comparedClasses) {
            if (!c2.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static int occurrenceCount(byte[] array, byte element) {
        int cnt = 0;
        for (byte b2 : array) {
            if (b2 != element) continue;
            ++cnt;
        }
        return cnt;
    }

    public static String findLongestCommonPrefix(String[] inputArray) {
        String referenceWord = inputArray[0];
        String result = "";
        for (int j2 = 1; j2 <= referenceWord.length(); ++j2) {
            String prefix = referenceWord.substring(0, j2);
            if (!ArrayUtils.isPresentInAllWords(prefix, inputArray) || result.length() >= prefix.length()) continue;
            result = prefix;
        }
        return result;
    }

    private static boolean isPresentInAllWords(String prefix, String[] words) {
        int n2 = words.length;
        for (int k2 = 1; k2 < n2; ++k2) {
            if (words[k2].startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public static double[] uniformDistFromArray(double[][] array, long seed) {
        double[] p2 = new double[array.length];
        RandomBase random = RandomUtils.getRNG(seed);
        for (int col = 0; col < array.length; ++col) {
            double[] minMax = ArrayUtils.minMaxValue(array[col]);
            double min2 = minMax[0];
            double max = minMax[1];
            p2[col] = min2 + random.nextDouble() * (max - min2);
        }
        return p2;
    }

    public static void interpolateLinear(double[] array) {
        assert (array.length > 0 && !Double.isNaN(array[array.length - 1])) : "Input array length should be > 0 and the first item should not be NaN";
        if (array.length == 1) {
            return;
        }
        ArrayList<Integer> nonNullIdx = new ArrayList<Integer>();
        ArrayList<Integer> steps = new ArrayList<Integer>();
        int tmpStep = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!Double.isNaN(array[i2])) {
                nonNullIdx.add(i2);
                if (tmpStep != 0) {
                    steps.add(tmpStep);
                }
                tmpStep = 0;
                continue;
            }
            ++tmpStep;
        }
        if (nonNullIdx.size() == 0) {
            return;
        }
        double start = Double.NaN;
        double end = Double.NaN;
        double step = Double.NaN;
        double mean = Double.NaN;
        for (int i3 = 0; i3 < array.length; ++i3) {
            if (i3 == 0 && Double.isNaN(array[i3])) {
                start = 0.0;
                end = array[(Integer)nonNullIdx.get(0)];
                mean = step = 1.0 / (double)((Integer)steps.get(0) + 1);
                array[i3] = start * (1.0 - mean) + end * mean;
                mean += step;
                continue;
            }
            if (!Double.isNaN(array[i3]) && nonNullIdx.size() > 1 && steps.size() > 0) {
                start = array[(Integer)nonNullIdx.get(0)];
                end = array[(Integer)nonNullIdx.get(1)];
                mean = step = 1.0 / (double)((Integer)steps.get(0) + 1);
                nonNullIdx.remove(0);
                steps.remove(0);
                continue;
            }
            if (!Double.isNaN(array[i3])) continue;
            array[i3] = start * (1.0 - mean) + end * mean;
            mean += step;
        }
    }

    public static class CopyArrayToFrame
    extends MRTask<CopyArrayToFrame> {
        int _startColIndex;
        int _endColIndex;
        int _rowNum;
        public double[][] _frameContent;

        public CopyArrayToFrame(int startCol, int endCol, long rowNum, double[][] frameContent) {
            assert (startCol >= 0 && endCol >= startCol && rowNum > 0L);
            this._startColIndex = startCol;
            this._endColIndex = endCol;
            this._rowNum = (int)rowNum;
            int colNum = endCol - startCol + 1;
            assert (this._rowNum == frameContent.length && frameContent[0].length == colNum);
            this._frameContent = frameContent;
        }

        @Override
        public void map(Chunk[] c2) {
            assert (this._endColIndex < c2.length);
            int endCol = this._endColIndex + 1;
            int rowOffset = (int)c2[0].start();
            int chkRows = c2[0]._len;
            for (int rowIndex = 0; rowIndex < chkRows; ++rowIndex) {
                for (int colIndex = this._startColIndex; colIndex < endCol; ++colIndex) {
                    c2[colIndex].set(rowIndex, this._frameContent[rowIndex + rowOffset][colIndex - this._startColIndex]);
                }
            }
        }
    }

    public static class FrameToArray
    extends MRTask<FrameToArray> {
        int _startColIndex;
        int _endColIndex;
        int _rowNum;
        public double[][] _frameContent;

        public FrameToArray(int startCol, int endCol, long rowNum, double[][] frameContent) {
            assert (startCol >= 0 && endCol >= startCol && rowNum > 0L);
            this._startColIndex = startCol;
            this._endColIndex = endCol;
            this._rowNum = (int)rowNum;
            int colNum = endCol - startCol + 1;
            if (frameContent == null) {
                this._frameContent = MemoryManager.malloc8d(this._rowNum, colNum);
            } else {
                assert (this._rowNum == frameContent.length && frameContent[0].length == colNum);
                for (int index = 0; index < colNum; ++index) {
                    Arrays.fill(frameContent[index], 0.0);
                }
                this._frameContent = frameContent;
            }
        }

        @Override
        public void map(Chunk[] c2) {
            assert (this._endColIndex < c2.length);
            int endCol = this._endColIndex + 1;
            int rowOffset = (int)c2[0].start();
            int chkRows = c2[0]._len;
            for (int rowIndex = 0; rowIndex < chkRows; ++rowIndex) {
                for (int colIndex = this._startColIndex; colIndex < endCol; ++colIndex) {
                    this._frameContent[rowIndex + rowOffset][colIndex - this._startColIndex] = c2[colIndex].atd(rowIndex);
                }
            }
        }

        @Override
        public void reduce(FrameToArray other) {
            ArrayUtils.add(this._frameContent, other._frameContent);
        }

        public double[][] getArray() {
            return this._frameContent;
        }
    }
}

