/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.IOException;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.ColumnFactory;
import water.udf.DataChunk;
import water.udf.DataColumn;
import water.udf.DataColumns;
import water.udf.specialized.Enums;
import water.util.fp.Function;

public class TypedFrame<X>
extends Frame {
    private final ColumnFactory<X> factory;
    private final long length;
    private final Function<Long, X> function;
    private Column<X> column;

    public TypedFrame() {
        super(new Vec[0]);
        this.factory = null;
        this.length = -1L;
        this.function = null;
    }

    public TypedFrame(DataColumns.BaseFactory<X> factory, long length, Function<Long, X> function) {
        super(new Vec[0]);
        this.factory = factory;
        this.length = length;
        this.function = function;
    }

    public static <X> TypedFrame<X> forColumn(final DataColumns.BaseFactory<X> factory, final Column<X> column) {
        return new TypedFrame<X>(factory, column.size(), column){

            @Override
            protected Vec buildZeroVec() {
                return factory.buildZeroVec(column);
            }
        };
    }

    protected Vec buildZeroVec() {
        return this.factory.buildZeroVec(this.length);
    }

    protected Vec makeVec() throws IOException {
        Vec vec0 = this.buildZeroVec();
        MRTask task = new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    DataChunk tc = (DataChunk)TypedFrame.this.factory.apply(c2);
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        long i2 = (long)r2 + c2.start();
                        tc.set(r2, TypedFrame.this.function.apply(i2));
                    }
                }
            }
        };
        Object mrTask = task.doAll(vec0);
        return ((MRTask)mrTask)._fr.vecs()[0];
    }

    protected DataColumn<X> newColumn(Vec vec) throws IOException {
        return this.factory.newColumn(vec);
    }

    public DataColumn<X> newColumn() throws IOException {
        return this.newColumn(this.makeVec());
    }

    public static final class EnumFrame
    extends TypedFrame<Integer> {
        private final String[] domain;

        public EnumFrame(long length, Function<Long, Integer> function, String[] domain) {
            super(Enums.enums(domain), length, function);
            this.domain = domain;
        }
    }
}

