/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.fvec.Chunk;
import water.fvec.RawChunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.DependentChunk;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.util.Java7;
import water.util.fp.Function2;

public class Fun2Column<X, Y, Z>
extends FunColumnBase<Z> {
    private final Function2<X, Y, Z> f;
    private final Column<X> xs;
    private final Column<Y> ys;

    @Override
    public int rowLayout() {
        return this.xs.rowLayout();
    }

    public Fun2Column() {
        this.f = null;
        this.xs = null;
        this.ys = null;
    }

    public Fun2Column(Function2<X, Y, Z> f2, Column<X> xs, Column<Y> ys) {
        super(xs);
        this.f = f2;
        this.xs = xs;
        this.ys = ys;
        assert (xs.isCompatibleWith(ys)) : "Columns must be compatible: " + xs + ", " + ys;
    }

    @Override
    public Z get(long idx) {
        return this.isNA(idx) ? null : (Z)this.f.apply(this.xs.apply(idx), this.ys.apply(idx));
    }

    @Override
    public TypedChunk<Z> chunkAt(int i2) {
        return new FunChunk(this.xs.chunkAt(i2), this.ys.chunkAt(i2));
    }

    @Override
    public boolean isNA(long idx) {
        return this.xs.isNA(idx) || this.ys.isNA(idx);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof Fun2Column) {
            Fun2Column other = (Fun2Column)o2;
            return Java7.Objects.equals(this.f, other.f) && this.xs.equals(other.xs);
        }
        return false;
    }

    public int hashCode() {
        return 61 * this.xs.hashCode() + Java7.Objects.hashCode(this.f);
    }

    public String toString() {
        return "Fun2Column(" + this.f.getClass().getSimpleName() + "," + this.xs + "," + this.ys + ")";
    }

    public class FunChunk
    extends DependentChunk<Z> {
        private final TypedChunk<X> cx;
        private final TypedChunk<Y> cy;
        private RawChunk myChunk;

        @Override
        public Chunk rawChunk() {
            return this.myChunk;
        }

        @Override
        public Vec vec() {
            return Fun2Column.this.vec();
        }

        public FunChunk(TypedChunk<X> cx, TypedChunk<Y> cy) {
            super(cx);
            this.myChunk = new RawChunk(this);
            this.cx = cx;
            this.cy = cy;
        }

        @Override
        public boolean isNA(int i2) {
            return this.cx.isNA(i2) || this.cy.isNA(i2);
        }

        @Override
        public Z get(int i2) {
            return Fun2Column.this.f.apply(this.cx.get(i2), this.cy.get(i2));
        }
    }
}

