/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.vals;

import java.util.Arrays;
import water.rapids.Val;

public class ValRow
extends Val {
    private final double[] _ds;
    private final String[] _names;

    public ValRow(double[] ds, String[] names) {
        this._ds = ds;
        this._names = names;
        if (ds != null && names != null && ds.length != names.length) {
            throw new IllegalArgumentException("Lengths of data and names mismatch: " + Arrays.toString(ds) + " and " + Arrays.toString(names));
        }
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public boolean isRow() {
        return true;
    }

    @Override
    public double[] getRow() {
        return this._ds;
    }

    @Override
    public double[] getNums() {
        return this._ds;
    }

    public String toString() {
        return Arrays.toString(this._ds);
    }

    public String[] getNames() {
        return this._names;
    }

    public ValRow slice(int[] cols) {
        double[] ds = new double[cols.length];
        String[] ns = new String[cols.length];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            ds[i2] = this._ds[cols[i2]];
            ns[i2] = this._names[cols[i2]];
        }
        return new ValRow(ds, ns);
    }
}

