/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.timeseries;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.distribution.NormalDistribution;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstIsax
extends AstPrimitive {
    protected double[][] _domain_hm = null;

    @Override
    public String[] args() {
        return new String[]{"ary", "numWords", "maxCardinality", "optimize_card"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "isax";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        AstRoot n2 = asts[2];
        AstRoot mc = asts[3];
        boolean optm_card = asts[4].exec(env).getNum() == 1.0;
        for (Vec v2 : fr.vecs()) {
            if (v2.isNumeric()) continue;
            throw new IllegalArgumentException("iSax only applies to numeric columns!");
        }
        int numWords = (int)n2.exec(env).getNum();
        int maxCardinality = (int)mc.exec(env).getNum();
        if (numWords < 0) {
            throw new IllegalArgumentException("numWords must be greater than 0!");
        }
        if (maxCardinality < 0) {
            throw new IllegalArgumentException("maxCardinality must be greater than 0!");
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (int i2 = 0; i2 < numWords; ++i2) {
            columns.add("c" + i2);
        }
        Frame fr2 = ((IsaxTask)new IsaxTask(numWords, maxCardinality).doAll(numWords, (byte)3, fr)).outputFrame(null, columns.toArray(new String[numWords]), null);
        int[] maxCards = new int[numWords];
        if (optm_card) {
            int i3;
            for (double[] r2 : this._domain_hm = new double[numWords][maxCardinality]) {
                Arrays.fill(r2, Double.NaN);
            }
            for (i3 = 0; i3 < fr2.numCols(); ++i3) {
                String[] domains = fr2.vec(i3).toCategoricalVec().domain();
                for (int j2 = 0; j2 < domains.length; ++j2) {
                    this._domain_hm[i3][j2] = Double.valueOf(domains[j2]);
                }
            }
            for (i3 = 0; i3 < numWords; ++i3) {
                int cnt = 0;
                for (double d2 : this._domain_hm[i3]) {
                    if (Double.isNaN(d2)) break;
                    ++cnt;
                }
                maxCards[i3] = cnt;
            }
            Frame fr2_reduced = ((IsaxReduceCard)new IsaxReduceCard(this._domain_hm, maxCardinality).doAll(numWords, (byte)3, fr2)).outputFrame(null, columns.toArray(new String[numWords]), null);
            Frame fr3 = ((IsaxStringTask)new IsaxStringTask(maxCards).doAll(1, (byte)2, fr2_reduced)).outputFrame(null, new String[]{"iSax_index"}, null);
            fr2.delete();
            fr3.add(fr2_reduced);
            return new ValFrame(fr3);
        }
        for (int i4 = 0; i4 < numWords; ++i4) {
            maxCards[i4] = maxCardinality;
        }
        Frame fr3 = ((IsaxStringTask)new IsaxStringTask(maxCards).doAll(1, (byte)2, fr2)).outputFrame(null, new String[]{"iSax_index"}, null);
        fr3.add(fr2);
        return new ValFrame(fr3);
    }

    public static class IsaxTask
    extends MRTask<IsaxTask> {
        private int nw;
        private int mc;
        private static NormalDistribution nd = new NormalDistribution();
        private ArrayList<Double> probBoundaries;

        IsaxTask(int numWords, int maxCardinality) {
            this.nw = numWords;
            this.mc = maxCardinality;
            double step = 1.0 / (double)this.mc;
            this.probBoundaries = new ArrayList();
            for (int i2 = 0; i2 < this.mc; ++i2) {
                this.probBoundaries.add(nd.inverseCumulativeProbability((double)i2 * step));
            }
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int step = cs.length / this.nw;
            int chunkSize = cs[0].len();
            int w_i = 0;
            double[] seriesSums = new double[chunkSize];
            double[] seriesCounts = new double[chunkSize];
            double[] seriesSSE = new double[chunkSize];
            double[][] chunkMeans = new double[chunkSize][this.nw];
            for (int i2 = 0; i2 < cs.length; i2 += step) {
                for (int j2 = 0; j2 < chunkSize; ++j2) {
                    double mySum = 0.0;
                    double myCount = 0.0;
                    for (Chunk c2 : ArrayUtils.subarray(cs, i2, i2 + step)) {
                        if (c2 == null) continue;
                        double oldMean = myCount < 1.0 ? 0.0 : mySum / myCount;
                        mySum += c2.atd(j2);
                        int n2 = j2;
                        seriesSums[n2] = seriesSums[n2] + c2.atd(j2);
                        int n3 = j2;
                        seriesCounts[n3] = seriesCounts[n3] + 1.0;
                        int n4 = j2;
                        seriesSSE[n4] = seriesSSE[n4] + (c2.atd(j2) - oldMean) * (c2.atd(j2) - mySum / (myCount += 1.0));
                    }
                    chunkMeans[j2][w_i] = mySum / myCount;
                }
                if (++w_i >= this.nw) break;
            }
            for (int w2 = 0; w2 < this.nw; ++w2) {
                for (int i3 = 0; i3 < chunkSize; ++i3) {
                    double seriesMean = seriesSums[i3] / seriesCounts[i3];
                    double seriesStd = Math.sqrt(seriesSSE[i3] / (seriesCounts[i3] - 1.0));
                    double zscore = (chunkMeans[i3][w2] - seriesMean) / seriesStd;
                    int p_i = 0;
                    while (this.probBoundaries.get(p_i + 1) < zscore && ++p_i != this.mc - 1) {
                    }
                    nc[w2].addNum(p_i, 0);
                }
            }
        }
    }

    public static class IsaxStringTask
    extends MRTask<IsaxStringTask> {
        int[] maxCards;

        IsaxStringTask(int[] mc) {
            this.maxCards = mc;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int csize = cs[0].len();
            for (int c_i = 0; c_i < csize; ++c_i) {
                StringBuffer sb = new StringBuffer("");
                for (int cs_i = 0; cs_i < cs.length; ++cs_i) {
                    sb.append(cs[cs_i].at8(c_i) + "^" + this.maxCards[cs_i] + "_");
                }
                nc[0].addStr(sb.toString().substring(0, sb.length() - 1));
            }
        }
    }

    public static class IsaxReduceCard
    extends MRTask<IsaxReduceCard> {
        double[][] _domain_hm;
        int maxCardinality;

        IsaxReduceCard(double[][] dm, int mc) {
            this._domain_hm = dm;
            this.maxCardinality = mc;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i2 = 0; i2 < cs.length; ++i2) {
                boolean ltMaxCardFlag = Double.isNaN(ArrayUtils.sum(this._domain_hm[i2]));
                for (int j2 = 0; j2 < cs[i2].len(); ++j2) {
                    int idxOf = ltMaxCardFlag ? Arrays.binarySearch(this._domain_hm[i2], (double)((int)cs[i2].at8(j2))) : (int)cs[i2].at8(j2);
                    nc[i2].addNum(idxOf);
                }
            }
        }
    }
}

