/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.timeseries;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstDiffLag1
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "difflag1";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env).getFrame());
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("Expected a single column for diff. Got: " + fr.numCols() + " columns.");
        }
        if (!fr.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Expected a numeric column for diff. Got: " + fr.anyVec().get_type_str());
        }
        final double[] lastElemPerChk = GetLastElemPerChunkTask.get(fr.anyVec());
        return new ValFrame(((MRTask)new MRTask(){

            @Override
            public void map(Chunk c2, NewChunk nc) {
                if (c2.cidx() == 0) {
                    nc.addNA();
                } else {
                    nc.addNum(c2.atd(0) - lastElemPerChk[c2.cidx() - 1]);
                }
                for (int row = 1; row < c2._len; ++row) {
                    nc.addNum(c2.atd(row) - c2.atd(row - 1));
                }
            }
        }.doAll(fr.types(), fr)).outputFrame(fr.names(), fr.domains()));
    }

    private static class GetLastElemPerChunkTask
    extends MRTask<GetLastElemPerChunkTask> {
        double[] _res;

        GetLastElemPerChunkTask(Vec v2) {
            this._res = new double[v2.espc().length];
        }

        static double[] get(Vec v2) {
            GetLastElemPerChunkTask t2 = new GetLastElemPerChunkTask(v2);
            t2.doAll(v2);
            return t2._res;
        }

        @Override
        public void map(Chunk c2) {
            this._res[c2.cidx()] = c2.atd(c2._len - 1);
        }

        @Override
        public void reduce(GetLastElemPerChunkTask t2) {
            ArrayUtils.add(this._res, t2._res);
        }
    }
}

