/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import hex.RegexTokenizer;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstTokenize
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "regex"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "tokenize";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String regex = asts[2].exec(env).getStr();
        for (Vec v2 : fr.vecs()) {
            if (v2.isString()) continue;
            throw new IllegalArgumentException("tokenize() requires all input columns to be of a String type. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string column first.");
        }
        Frame tokenized = new RegexTokenizer(regex).transform(fr);
        return new ValFrame(tokenized);
    }
}

