/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstReplaceFirst
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "pattern", "replacement", "ignore_case"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "replacefirst";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String pattern = asts[2].exec(env).getStr();
        String replacement = asts[3].exec(env).getStr();
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        boolean ignoreCase = asts[4].exec(env).getNum() == 1.0;
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("replacefirst() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.replaceFirstCategoricalCol(v3, pattern, replacement, ignoreCase) : this.replaceFirstStringCol(v3, pattern, replacement, ignoreCase);
            ++i2;
        }
        return new ValFrame(new Frame(fr.names(), nvs));
    }

    private Vec replaceFirstCategoricalCol(Vec vec, String pattern, String replacement, boolean ignoreCase) {
        Pattern compiledPattern = Pattern.compile(pattern);
        String[] doms = (String[])vec.domain().clone();
        HashSet<String> newDomainSet = new HashSet<String>();
        for (int i2 = 0; i2 < doms.length; ++i2) {
            doms[i2] = ignoreCase ? compiledPattern.matcher(doms[i2].toLowerCase(Locale.ENGLISH)).replaceFirst(replacement) : compiledPattern.matcher(doms[i2]).replaceFirst(replacement);
            newDomainSet.add(doms[i2]);
        }
        if (newDomainSet.size() == doms.length) {
            newDomainSet = null;
            return vec.makeCopy(doms);
        }
        newDomainSet = null;
        return VecUtils.remapDomain(doms, vec);
    }

    private Vec replaceFirstStringCol(Vec vec, String pat, String rep, boolean ic) {
        final String pattern = pat;
        final String replacement = rep;
        final boolean ignoreCase = ic;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    Pattern compiledPattern = Pattern.compile(pattern);
                    for (int i3 = 0; i3 < chk._len; ++i3) {
                        if (chk.isNA(i3)) {
                            newChk.addNA();
                            continue;
                        }
                        if (ignoreCase) {
                            newChk.addStr(compiledPattern.matcher(chk.atStr(tmpStr, i3).toString().toLowerCase(Locale.ENGLISH)).replaceFirst(replacement));
                            continue;
                        }
                        newChk.addStr(compiledPattern.matcher(chk.atStr(tmpStr, i3).toString()).replaceFirst(replacement));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

