/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.Iced;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValFrame;

public class AstGrep
extends AstBuiltin<AstGrep> {
    @Override
    public String[] args() {
        return new String[]{"ary", "regex", "ignore_case", "invert", "output_logical"};
    }

    @Override
    public int nargs() {
        return 6;
    }

    @Override
    public String str() {
        return "grep";
    }

    @Override
    protected Val exec(Val[] args) {
        Frame result;
        Frame fr = args[1].getFrame();
        String regex = args[2].getStr();
        boolean ignoreCase = args[3].getNum() == 1.0;
        boolean invert = args[4].getNum() == 1.0;
        boolean outputLogical = args[5].getNum() == 1.0;
        GrepHelper grepHelper = new GrepHelper(regex, ignoreCase, invert, outputLogical);
        if (fr.numCols() != 1 || !fr.anyVec().isCategorical() && !fr.anyVec().isString()) {
            throw new IllegalArgumentException("can only grep on a single categorical/string column.");
        }
        Vec v2 = fr.anyVec();
        assert (v2 != null);
        if (v2.isCategorical()) {
            int[] filtered = AstGrep.grepDomain(grepHelper, v2);
            Arrays.sort(filtered);
            result = ((GrepCatTask)new GrepCatTask(grepHelper, filtered).doAll((byte)3, v2)).outputFrame();
        } else {
            result = ((GrepStrTask)new GrepStrTask(grepHelper).doAll((byte)3, v2)).outputFrame();
        }
        return new ValFrame(result);
    }

    private static int[] grepDomain(GrepHelper grepHelper, Vec v2) {
        Pattern p2 = grepHelper.compilePattern();
        String[] domain = v2.domain();
        int cnt = 0;
        int[] filtered = new int[domain.length];
        for (int i2 = 0; i2 < domain.length; ++i2) {
            if (!p2.matcher(domain[i2]).find()) continue;
            filtered[cnt++] = i2;
        }
        int[] result = new int[cnt];
        System.arraycopy(filtered, 0, result, 0, cnt);
        return result;
    }

    private static class PositionWriter
    extends OutputWriter {
        PositionWriter(NewChunk nc, long start, boolean invert) {
            super(nc, start, invert);
        }

        @Override
        void addNA(int row) {
            if (this._invert) {
                this._nc.addNum(this._start + (long)row);
            }
        }

        @Override
        void addRow(int row, boolean matched) {
            if (matched != this._invert) {
                this._nc.addNum(this._start + (long)row);
            }
        }
    }

    private static class IndicatorWriter
    extends OutputWriter {
        IndicatorWriter(NewChunk nc, long start, boolean invert) {
            super(nc, start, invert);
        }

        @Override
        void addNA(int row) {
            this._nc.addNum(this._invert ? 1.0 : 0.0);
        }

        @Override
        void addRow(int row, boolean matched) {
            this._nc.addNum(matched != this._invert ? 1.0 : 0.0);
        }
    }

    private static abstract class OutputWriter {
        static final double MATCH = 1.0;
        static final double NO_MATCH = 0.0;
        NewChunk _nc;
        long _start;
        boolean _invert;

        OutputWriter(NewChunk nc, long start, boolean invert) {
            this._nc = nc;
            this._start = start;
            this._invert = invert;
        }

        abstract void addNA(int var1);

        abstract void addRow(int var1, boolean var2);

        static OutputWriter makeWriter(GrepHelper gh, NewChunk nc, long start) {
            return gh._outputLogical ? new IndicatorWriter(nc, start, gh._invert) : new PositionWriter(nc, start, gh._invert);
        }
    }

    private static class GrepHelper
    extends Iced<GrepHelper> {
        private String _regex;
        private boolean _ignoreCase;
        private boolean _invert;
        private boolean _outputLogical;

        public GrepHelper() {
        }

        GrepHelper(String regex, boolean ignoreCase, boolean invert, boolean outputLogical) {
            this._regex = regex;
            this._ignoreCase = ignoreCase;
            this._invert = invert;
            this._outputLogical = outputLogical;
        }

        Pattern compilePattern() {
            int flags = this._ignoreCase ? 66 : 0;
            return Pattern.compile(this._regex, flags);
        }
    }

    private static class GrepStrTask
    extends MRTask<GrepStrTask> {
        private final GrepHelper _gh;

        GrepStrTask(GrepHelper gh) {
            this._gh = gh;
        }

        @Override
        public void map(Chunk c2, NewChunk n2) {
            OutputWriter w2 = OutputWriter.makeWriter(this._gh, n2, c2.start());
            Pattern p2 = this._gh.compilePattern();
            Matcher m4 = p2.matcher("");
            BufferedString bs = new BufferedString();
            int rows = c2._len;
            for (int r2 = 0; r2 < rows; ++r2) {
                if (c2.isNA(r2)) {
                    w2.addNA(r2);
                    continue;
                }
                m4.reset(c2.atStr(bs, r2).toString());
                w2.addRow(r2, m4.find());
            }
        }
    }

    private static class GrepCatTask
    extends MRTask<GrepCatTask> {
        private final int[] _matchingCats;
        private final GrepHelper _gh;

        GrepCatTask(GrepHelper gh, int[] matchingCats) {
            this._matchingCats = matchingCats;
            this._gh = gh;
        }

        @Override
        public void map(Chunk c2, NewChunk n2) {
            OutputWriter w2 = OutputWriter.makeWriter(this._gh, n2, c2.start());
            int rows = c2._len;
            for (int r2 = 0; r2 < rows; ++r2) {
                if (c2.isNA(r2)) {
                    w2.addNA(r2);
                    continue;
                }
                int cat = (int)c2.at8(r2);
                int pos = Arrays.binarySearch(this._matchingCats, cat);
                w2.addRow(r2, pos >= 0);
            }
        }
    }
}

